/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.shape.random;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.shape.GeometricShapeBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0014J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0004R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\n\u00a8\u0006\u001f"}, d2={"Lorg/locationtech/jts/shape/random/RandomPointsBuilder;", "Lorg/locationtech/jts/shape/GeometricShapeBuilder;", "<init>", "()V", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "maskPoly", "Lorg/locationtech/jts/geom/Geometry;", "getMaskPoly", "()Lorg/locationtech/jts/geom/Geometry;", "setMaskPoly", "(Lorg/locationtech/jts/geom/Geometry;)V", "extentLocator", "Lorg/locationtech/jts/algorithm/locate/PointOnGeometryLocator;", "setExtent", "", "mask", "geometry", "getGeometry", "isInExtent", "", "p", "Lorg/locationtech/jts/geom/Coordinate;", "createCoord", "x", "", "y", "createRandomCoord", "env", "Lorg/locationtech/jts/geom/Envelope;", "kts-core"})
public final class RandomPointsBuilder
extends GeometricShapeBuilder {
    @Nullable
    private Geometry maskPoly;
    @Nullable
    private PointOnGeometryLocator extentLocator;

    @Nullable
    protected final Geometry getMaskPoly() {
        return this.maskPoly;
    }

    protected final void setMaskPoly(@Nullable Geometry geometry) {
        this.maskPoly = geometry;
    }

    public RandomPointsBuilder() {
        super(new GeometryFactory());
    }

    public RandomPointsBuilder(@Nullable GeometryFactory geomFact) {
        GeometryFactory geometryFactory = geomFact;
        Intrinsics.checkNotNull((Object)geometryFactory);
        super(geometryFactory);
    }

    public final void setExtent(@NotNull Geometry mask) {
        Intrinsics.checkNotNullParameter((Object)mask, (String)"mask");
        if (!(mask instanceof Polygonal)) {
            throw new IllegalArgumentException("Only polygonal extents are supported");
        }
        this.maskPoly = mask;
        this.setExtent(mask.getEnvelopeInternal());
        this.extentLocator = new IndexedPointInAreaLocator(mask);
    }

    @Override
    @NotNull
    public Geometry getGeometry() {
        Object[] pts = new Coordinate[this.getNumPts()];
        int i = 0;
        while (i < this.getNumPts()) {
            Coordinate p = this.createRandomCoord(this.getExtent());
            if (this.extentLocator != null && !this.isInExtent(p)) continue;
            pts[i++] = p;
        }
        return this.getGeomFactory().createMultiPointFromCoords((Coordinate[])ArraysKt.requireNoNulls((Object[])pts));
    }

    protected final boolean isInExtent(@NotNull Coordinate p) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (this.extentLocator != null) {
            PointOnGeometryLocator pointOnGeometryLocator = this.extentLocator;
            Intrinsics.checkNotNull((Object)pointOnGeometryLocator);
            bl = pointOnGeometryLocator.locate(p) != 2;
        } else {
            bl = this.getExtent().contains(p);
        }
        return bl;
    }

    @Override
    @NotNull
    protected Coordinate createCoord(double x, double y) {
        Coordinate pt = new Coordinate(x, y);
        this.getGeomFactory().getPrecisionModel().makePrecise(pt);
        return pt;
    }

    @NotNull
    protected final Coordinate createRandomCoord(@NotNull Envelope env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        double x = env.getMinX() + env.getWidth() * Random.Default.nextDouble();
        double y = env.getMinY() + env.getHeight() * Random.Default.nextDouble();
        return this.createCoord(x, y);
    }
}

