/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.LineSegment;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u0011\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/simplify/DouglasPeuckerLineSimplifier;", "", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "<init>", "([Lorg/locationtech/jts/geom/Coordinate;)V", "[Lorg/locationtech/jts/geom/Coordinate;", "usePt", "", "distanceTolerance", "", "setDistanceTolerance", "", "simplify", "()[Lorg/locationtech/jts/geom/Coordinate;", "seg", "Lorg/locationtech/jts/geom/LineSegment;", "simplifySection", "i", "", "j", "Companion", "kts-core"})
public final class DouglasPeuckerLineSimplifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinate[] pts;
    private boolean[] usePt;
    private double distanceTolerance;
    @NotNull
    private final LineSegment seg;

    public DouglasPeuckerLineSimplifier(@NotNull Coordinate[] pts) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        this.pts = pts;
        this.seg = new LineSegment(null, null, 3, null);
    }

    public final void setDistanceTolerance(double distanceTolerance) {
        this.distanceTolerance = distanceTolerance;
    }

    @NotNull
    public final Coordinate[] simplify() {
        this.usePt = new boolean[this.pts.length];
        int n = this.pts.length;
        for (int i = 0; i < n; ++i) {
            boolean[] blArray = this.usePt;
            if (this.usePt == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"usePt");
                blArray = null;
            }
            blArray[i] = true;
        }
        this.simplifySection(0, this.pts.length - 1);
        CoordinateList coordList = new CoordinateList();
        int n2 = this.pts.length;
        for (int i = 0; i < n2; ++i) {
            boolean[] blArray = this.usePt;
            if (this.usePt == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"usePt");
                blArray = null;
            }
            if (!blArray[i]) continue;
            coordList.add(new Coordinate(this.pts[i]));
        }
        return coordList.toCoordinateArray();
    }

    private final void simplifySection(int i, int j) {
        int k;
        if (i + 1 == j) {
            return;
        }
        this.seg.p0 = this.pts[i];
        this.seg.p1 = this.pts[j];
        double maxDistance = -1.0;
        int maxIndex = i;
        for (k = i + 1; k < j; ++k) {
            double distance = this.seg.distance(this.pts[k]);
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
            maxIndex = k;
        }
        if (maxDistance <= this.distanceTolerance) {
            for (k = i + 1; k < j; ++k) {
                boolean[] blArray = this.usePt;
                if (this.usePt == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"usePt");
                    blArray = null;
                }
                blArray[k] = false;
            }
        } else {
            this.simplifySection(i, maxIndex);
            this.simplifySection(maxIndex, j);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/simplify/DouglasPeuckerLineSimplifier$Companion;", "", "<init>", "()V", "simplify", "", "Lorg/locationtech/jts/geom/Coordinate;", "pts", "distanceTolerance", "", "([Lorg/locationtech/jts/geom/Coordinate;D)[Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Coordinate[] simplify(@NotNull Coordinate[] pts, double distanceTolerance) {
            Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
            DouglasPeuckerLineSimplifier simp = new DouglasPeuckerLineSimplifier(pts);
            simp.setDistanceTolerance(distanceTolerance);
            return simp.simplify();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

