/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.math.MathUtil;
import org.locationtech.jts.simplify.RingHull;
import org.locationtech.jts.simplify.RingHullIndex;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\tJ\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0019\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J,\u0010 \u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J,\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0010\u0010%\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0018\u00010\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006'"}, d2={"Lorg/locationtech/jts/simplify/PolygonHullSimplifier;", "", "inputGeom", "Lorg/locationtech/jts/geom/Geometry;", "isOuter", "", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Z)V", "vertexNumFraction", "", "areaDeltaRatio", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "setVertexNumFraction", "", "setAreaDeltaRatio", "result", "getResult", "()Lorg/locationtech/jts/geom/Geometry;", "computeMultiPolygonAll", "multiPoly", "Lorg/locationtech/jts/geom/MultiPolygon;", "computeMultiPolygonEach", "computePolygon", "Lorg/locationtech/jts/geom/Polygon;", "poly", "initPolygon", "", "Lorg/locationtech/jts/simplify/RingHull;", "hullIndex", "Lorg/locationtech/jts/simplify/RingHullIndex;", "ringArea", "createRingHull", "ring", "Lorg/locationtech/jts/geom/LinearRing;", "areaTotal", "polygonHull", "ringHulls", "Companion", "kts-core"})
public final class PolygonHullSimplifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry inputGeom;
    private final boolean isOuter;
    private double vertexNumFraction;
    private double areaDeltaRatio;
    @NotNull
    private final GeometryFactory geomFactory;

    public PolygonHullSimplifier(@NotNull Geometry inputGeom, boolean isOuter) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        this.inputGeom = inputGeom;
        this.vertexNumFraction = -1.0;
        this.areaDeltaRatio = -1.0;
        this.geomFactory = this.inputGeom.getFactory();
        this.isOuter = isOuter;
        if (!(this.inputGeom instanceof Polygonal)) {
            throw new IllegalArgumentException("Input geometry must be  polygonal");
        }
    }

    public final void setVertexNumFraction(double vertexNumFraction) {
        double frac;
        this.vertexNumFraction = frac = MathUtil.INSTANCE.clamp(vertexNumFraction, 0.0, 1.0);
    }

    public final void setAreaDeltaRatio(double areaDeltaRatio) {
        this.areaDeltaRatio = areaDeltaRatio;
    }

    @NotNull
    public final Geometry getResult() {
        if (this.vertexNumFraction == 1.0 || this.areaDeltaRatio == 0.0) {
            return this.inputGeom.copy();
        }
        if (this.inputGeom instanceof MultiPolygon) {
            boolean isOverlapPossible = this.isOuter && ((MultiPolygon)this.inputGeom).getNumGeometries() > 1;
            return isOverlapPossible ? this.computeMultiPolygonAll((MultiPolygon)this.inputGeom) : this.computeMultiPolygonEach((MultiPolygon)this.inputGeom);
        }
        if (this.inputGeom instanceof Polygon) {
            return this.computePolygon((Polygon)this.inputGeom);
        }
        throw new IllegalArgumentException("Input geometry must be polygonal");
    }

    private final Geometry computeMultiPolygonAll(MultiPolygon multiPoly) {
        RingHullIndex hullIndex = new RingHullIndex();
        int nPoly = multiPoly.getNumGeometries();
        List[] polyHulls = new ArrayList[nPoly];
        int n = multiPoly.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            List<RingHull> ringHulls;
            Geometry geometry = multiPoly.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            Polygon poly = (Polygon)geometry;
            polyHulls[i] = ringHulls = this.initPolygon(poly, hullIndex);
        }
        List polys = new ArrayList();
        int n2 = multiPoly.getNumGeometries();
        for (int i = 0; i < n2; ++i) {
            Geometry geometry = multiPoly.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            Polygon poly = (Polygon)geometry;
            Polygon hull = this.polygonHull(poly, polyHulls[i], hullIndex);
            polys.add(hull);
        }
        return this.geomFactory.createMultiPolygon(GeometryFactory.Companion.toPolygonArray(polys));
    }

    private final Geometry computeMultiPolygonEach(MultiPolygon multiPoly) {
        List polys = new ArrayList();
        int n = multiPoly.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geometry = multiPoly.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            Polygon poly = (Polygon)geometry;
            Polygon hull = this.computePolygon(poly);
            polys.add(hull);
        }
        return this.geomFactory.createMultiPolygon(GeometryFactory.Companion.toPolygonArray(polys));
    }

    private final Polygon computePolygon(Polygon poly) {
        boolean isOverlapPossible;
        RingHullIndex hullIndex = null;
        boolean bl = isOverlapPossible = !this.isOuter && poly.getNumInteriorRing() > 0;
        if (isOverlapPossible) {
            hullIndex = new RingHullIndex();
        }
        List<RingHull> hulls = this.initPolygon(poly, hullIndex);
        return this.polygonHull(poly, hulls, hullIndex);
    }

    private final List<RingHull> initPolygon(Polygon poly, RingHullIndex hullIndex) {
        List hulls = new ArrayList();
        if (poly.isEmpty()) {
            return hulls;
        }
        double areaTotal = 0.0;
        if (this.areaDeltaRatio >= 0.0) {
            areaTotal = this.ringArea(poly);
        }
        hulls.add(this.createRingHull(poly.getExteriorRing(), this.isOuter, areaTotal, hullIndex));
        int n = poly.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            hulls.add(this.createRingHull(poly.getInteriorRingN(i), !this.isOuter, areaTotal, hullIndex));
        }
        return hulls;
    }

    private final double ringArea(Polygon poly) {
        LinearRing linearRing = poly.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        CoordinateSequence coordinateSequence = linearRing.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        double area = Area.ofRing(coordinateSequence);
        int n = poly.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            CoordinateSequence coordinateSequence2 = poly.getInteriorRingN(i).getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence2);
            area += Area.ofRing(coordinateSequence2);
        }
        return area;
    }

    private final RingHull createRingHull(LinearRing ring, boolean isOuter, double areaTotal, RingHullIndex hullIndex) {
        RingHull ringHull;
        block3: {
            LinearRing linearRing = ring;
            Intrinsics.checkNotNull((Object)linearRing);
            ringHull = new RingHull(linearRing, isOuter);
            if (this.vertexNumFraction >= 0.0) {
                int targetVertexCount = (int)Math.INSTANCE.ceil(this.vertexNumFraction * (double)(ring.getNumPoints() - 1));
                ringHull.setMinVertexNum(targetVertexCount);
            } else if (this.areaDeltaRatio >= 0.0) {
                CoordinateSequence coordinateSequence = ring.getCoordinateSequence();
                Intrinsics.checkNotNull((Object)coordinateSequence);
                double ringArea = Area.ofRing(coordinateSequence);
                double ringWeight = ringArea / areaTotal;
                double maxAreaDelta = ringWeight * this.areaDeltaRatio * ringArea;
                ringHull.setMaxAreaDelta(maxAreaDelta);
            }
            RingHullIndex ringHullIndex = hullIndex;
            if (ringHullIndex == null) break block3;
            ringHullIndex.add(ringHull);
        }
        return ringHull;
    }

    private final Polygon polygonHull(Polygon poly, List<RingHull> ringHulls, RingHullIndex hullIndex) {
        if (poly.isEmpty()) {
            return GeometryFactory.createPolygon$default(this.geomFactory, null, null, 3, null);
        }
        int ringIndex = 0;
        List<RingHull> list = ringHulls;
        Intrinsics.checkNotNull(list);
        RingHull ringHull = list.get(ringIndex++);
        Intrinsics.checkNotNull((Object)ringHull);
        LinearRing shellHull = ringHull.getHull(hullIndex);
        List holeHulls = new ArrayList();
        int n = poly.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            RingHull ringHull2 = ringHulls.get(ringIndex++);
            Intrinsics.checkNotNull((Object)ringHull2);
            LinearRing hull = ringHull2.getHull(hullIndex);
            holeHulls.add(hull);
        }
        LinearRing[] resultHoles = GeometryFactory.Companion.toLinearRingArray(holeHulls);
        return this.geomFactory.createPolygon(shellHull, resultHoles);
    }

    @JvmStatic
    @NotNull
    public static final Geometry hull(@NotNull Geometry geom, boolean isOuter, double vertexNumFraction) {
        return Companion.hull(geom, isOuter, vertexNumFraction);
    }

    @JvmStatic
    @NotNull
    public static final Geometry hullByAreaDelta(@NotNull Geometry geom, boolean isOuter, double areaDeltaRatio) {
        return Companion.hullByAreaDelta(geom, isOuter, areaDeltaRatio);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0007\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/simplify/PolygonHullSimplifier$Companion;", "", "<init>", "()V", "hull", "Lorg/locationtech/jts/geom/Geometry;", "geom", "isOuter", "", "vertexNumFraction", "", "hullByAreaDelta", "areaDeltaRatio", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Geometry hull(@NotNull Geometry geom, boolean isOuter, double vertexNumFraction) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            PolygonHullSimplifier hull = new PolygonHullSimplifier(geom, isOuter);
            hull.setVertexNumFraction(Math.INSTANCE.abs(vertexNumFraction));
            return hull.getResult();
        }

        @JvmStatic
        @NotNull
        public final Geometry hullByAreaDelta(@NotNull Geometry geom, boolean isOuter, double areaDeltaRatio) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            PolygonHullSimplifier hull = new PolygonHullSimplifier(geom, isOuter);
            hull.setAreaDeltaRatio(Math.INSTANCE.abs(areaDeltaRatio));
            return hull.getResult();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

