/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.locationtech.jts.simplify.VWLineSimplifier;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/locationtech/jts/simplify/VWSimplifier;", "", "inputGeom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "distanceTolerance", "", "isEnsureValidTopology", "", "setDistanceTolerance", "", "setEnsureValid", "resultGeometry", "getResultGeometry", "()Lorg/locationtech/jts/geom/Geometry;", "VWTransformer", "Companion", "kts-core"})
public final class VWSimplifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry inputGeom;
    private double distanceTolerance;
    private boolean isEnsureValidTopology;

    public VWSimplifier(@NotNull Geometry inputGeom) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        this.inputGeom = inputGeom;
        this.isEnsureValidTopology = true;
    }

    public final void setDistanceTolerance(double distanceTolerance) {
        if (distanceTolerance < 0.0) {
            throw new IllegalArgumentException("Tolerance must be non-negative");
        }
        this.distanceTolerance = distanceTolerance;
    }

    public final void setEnsureValid(boolean isEnsureValidTopology) {
        this.isEnsureValidTopology = isEnsureValidTopology;
    }

    @NotNull
    public final Geometry getResultGeometry() {
        return this.inputGeom.isEmpty() ? this.inputGeom.copy() : new VWTransformer(this.isEnsureValidTopology, this.distanceTolerance).transform(this.inputGeom);
    }

    @JvmStatic
    @NotNull
    public static final Geometry simplify(@NotNull Geometry geom, double distanceTolerance) {
        return Companion.simplify(geom, distanceTolerance);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/simplify/VWSimplifier$Companion;", "", "<init>", "()V", "simplify", "Lorg/locationtech/jts/geom/Geometry;", "geom", "distanceTolerance", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Geometry simplify(@NotNull Geometry geom, double distanceTolerance) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            VWSimplifier simp = new VWSimplifier(geom);
            simp.setDistanceTolerance(distanceTolerance);
            return simp.getResultGeometry();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u001c\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u001e\u0010\u0010\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u001a\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/simplify/VWSimplifier$VWTransformer;", "Lorg/locationtech/jts/geom/util/GeometryTransformer;", "isEnsureValidTopology", "", "distanceTolerance", "", "<init>", "(ZD)V", "transformCoordinates", "Lorg/locationtech/jts/geom/CoordinateSequence;", "coords", "parent", "Lorg/locationtech/jts/geom/Geometry;", "transformPolygon", "geom", "Lorg/locationtech/jts/geom/Polygon;", "transformLinearRing", "Lorg/locationtech/jts/geom/LinearRing;", "transformMultiPolygon", "Lorg/locationtech/jts/geom/MultiPolygon;", "createValidArea", "rawAreaGeom", "kts-core"})
    public static final class VWTransformer
    extends GeometryTransformer {
        private final boolean isEnsureValidTopology;
        private final double distanceTolerance;

        public VWTransformer(boolean isEnsureValidTopology, double distanceTolerance) {
            this.isEnsureValidTopology = isEnsureValidTopology;
            this.distanceTolerance = distanceTolerance;
        }

        public /* synthetic */ VWTransformer(boolean bl, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            this(bl, d);
        }

        @Override
        @NotNull
        protected CoordinateSequence transformCoordinates(@Nullable CoordinateSequence coords, @Nullable Geometry parent) {
            CoordinateSequence coordinateSequence = coords;
            Intrinsics.checkNotNull((Object)coordinateSequence);
            Coordinate[] inputPts = coordinateSequence.toCoordinateArray();
            Coordinate[] newPts = null;
            newPts = inputPts.length == 0 ? new Coordinate[]{} : VWLineSimplifier.Companion.simplify(inputPts, this.distanceTolerance);
            GeometryFactory geometryFactory = this.getFactory();
            Intrinsics.checkNotNull((Object)geometryFactory);
            return geometryFactory.getCoordinateSequenceFactory().create(newPts);
        }

        @Override
        @Nullable
        protected Geometry transformPolygon(@NotNull Polygon geom, @Nullable Geometry parent) {
            Geometry geometry;
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            if (geom.isEmpty()) {
                return null;
            }
            Geometry rawGeom = super.transformPolygon(geom, parent);
            if (parent instanceof MultiPolygon) {
                geometry = rawGeom;
            } else {
                Geometry geometry2 = rawGeom;
                Intrinsics.checkNotNull((Object)geometry2);
                geometry = this.createValidArea(geometry2);
            }
            return geometry;
        }

        @Override
        @Nullable
        protected Geometry transformLinearRing(@Nullable LinearRing geom, @Nullable Geometry parent) {
            boolean removeDegenerateRings = parent instanceof Polygon;
            Geometry simpResult = super.transformLinearRing(geom, parent);
            return removeDegenerateRings && !(simpResult instanceof LinearRing) ? null : simpResult;
        }

        @Override
        @NotNull
        protected Geometry transformMultiPolygon(@NotNull MultiPolygon geom, @Nullable Geometry parent) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            Geometry rawGeom = super.transformMultiPolygon(geom, parent);
            return this.createValidArea(rawGeom);
        }

        private final Geometry createValidArea(Geometry rawAreaGeom) {
            return this.isEnsureValidTopology && !rawAreaGeom.isValid() ? rawAreaGeom.buffer(0.0) : rawAreaGeom;
        }
    }
}

