/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.legacy.map.TreeMap;
import org.locationtech.jts.triangulate.ConformingDelaunayTriangulator;
import org.locationtech.jts.triangulate.ConstraintVertex;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.Segment;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u0013\u001a\u00020\u00112\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u0015\u001a\u00020\u0011H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010 \u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fR\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Lorg/locationtech/jts/triangulate/ConformingDelaunayTriangulationBuilder;", "", "<init>", "()V", "siteCoords", "", "Lorg/locationtech/jts/geom/Coordinate;", "constraintLines", "Lorg/locationtech/jts/geom/Geometry;", "tolerance", "", "subdiv", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision;", "constraintVertexMap", "", "Lorg/locationtech/jts/triangulate/quadedge/Vertex;", "setSites", "", "geom", "setConstraints", "setTolerance", "create", "createSiteVertices", "", "coords", "createVertices", "subdivision", "getSubdivision", "()Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision;", "getEdges", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "getTriangles", "Companion", "kts-core"})
public final class ConformingDelaunayTriangulationBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Collection<? extends Coordinate> siteCoords;
    @Nullable
    private Geometry constraintLines;
    private double tolerance;
    @Nullable
    private QuadEdgeSubdivision subdiv;
    @NotNull
    private final Map<Coordinate, Vertex> constraintVertexMap = new TreeMap(null, 1, null);

    public final void setSites(@Nullable Geometry geom) {
        this.siteCoords = DelaunayTriangulationBuilder.Companion.extractUniqueCoordinates(geom);
    }

    public final void setConstraints(@Nullable Geometry constraintLines) {
        this.constraintLines = constraintLines;
    }

    public final void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    private final void create() {
        if (this.subdiv != null) {
            return;
        }
        Envelope siteEnv = DelaunayTriangulationBuilder.Companion.envelope(this.siteCoords);
        List segments = new ArrayList();
        if (this.constraintLines != null) {
            Geometry geometry = this.constraintLines;
            Intrinsics.checkNotNull((Object)geometry);
            siteEnv.expandToInclude(geometry.getEnvelopeInternal());
            Geometry geometry2 = this.constraintLines;
            Intrinsics.checkNotNull((Object)geometry2);
            this.createVertices(geometry2);
            Geometry geometry3 = this.constraintLines;
            Intrinsics.checkNotNull((Object)geometry3);
            segments = ConformingDelaunayTriangulationBuilder.Companion.createConstraintSegments(geometry3);
        }
        List<Vertex> sites = this.createSiteVertices(this.siteCoords);
        ConformingDelaunayTriangulator cdt = new ConformingDelaunayTriangulator((Collection<? extends Vertex>)sites, this.tolerance);
        cdt.setConstraints(segments, (List<Vertex>)new ArrayList<Vertex>(this.constraintVertexMap.values()));
        cdt.formInitialDelaunay();
        cdt.enforceConstraints();
        this.subdiv = cdt.getSubdivision();
    }

    private final List<Vertex> createSiteVertices(Collection<? extends Coordinate> coords) {
        List verts = new ArrayList();
        Collection<? extends Coordinate> collection = coords;
        Intrinsics.checkNotNull(collection);
        for (Coordinate coordinate : collection) {
            if (this.constraintVertexMap.containsKey(coordinate)) continue;
            verts.add(new ConstraintVertex(coordinate));
        }
        return verts;
    }

    private final void createVertices(Geometry geom) {
        Coordinate[] coords = geom.getCoordinates();
        Intrinsics.checkNotNull((Object)coords);
        int n = coords.length;
        for (int i = 0; i < n; ++i) {
            Vertex v = new ConstraintVertex(coords[i]);
            this.constraintVertexMap.put(coords[i], v);
        }
    }

    @Nullable
    public final QuadEdgeSubdivision getSubdivision() {
        this.create();
        return this.subdiv;
    }

    @NotNull
    public final Geometry getEdges(@Nullable GeometryFactory geomFact) {
        this.create();
        QuadEdgeSubdivision quadEdgeSubdivision = this.subdiv;
        Intrinsics.checkNotNull((Object)quadEdgeSubdivision);
        GeometryFactory geometryFactory = geomFact;
        Intrinsics.checkNotNull((Object)geometryFactory);
        return quadEdgeSubdivision.getEdges(geometryFactory);
    }

    @NotNull
    public final Geometry getTriangles(@Nullable GeometryFactory geomFact) {
        this.create();
        QuadEdgeSubdivision quadEdgeSubdivision = this.subdiv;
        Intrinsics.checkNotNull((Object)quadEdgeSubdivision);
        GeometryFactory geometryFactory = geomFact;
        Intrinsics.checkNotNull((Object)geometryFactory);
        return quadEdgeSubdivision.getTriangles(geometryFactory);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u0004\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/triangulate/ConformingDelaunayTriangulationBuilder$Companion;", "", "<init>", "()V", "createConstraintSegments", "", "Lorg/locationtech/jts/triangulate/Segment;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "", "line", "Lorg/locationtech/jts/geom/LineString;", "constraintSegs", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final List<Segment> createConstraintSegments(Geometry geom) {
            List<Geometry> lines = LinearComponentExtracter.Companion.getLines(geom);
            List constraintSegs = new ArrayList();
            for (Geometry geometry : lines) {
                Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
                LineString line = (LineString)geometry;
                this.createConstraintSegments(line, constraintSegs);
            }
            return constraintSegs;
        }

        private final void createConstraintSegments(LineString line, List<Segment> constraintSegs) {
            Coordinate[] coords = line.getCoordinates();
            int n = coords.length;
            for (int i = 1; i < n; ++i) {
                constraintSegs.add(new Segment(coords[i - 1], coords[i]));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

