/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.triangulate.ConstraintSplitPointFinder;
import org.locationtech.jts.triangulate.Segment;
import org.locationtech.jts.triangulate.SplitSegment;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/triangulate/NonEncroachingSplitPointFinder;", "Lorg/locationtech/jts/triangulate/ConstraintSplitPointFinder;", "<init>", "()V", "findSplitPoint", "Lorg/locationtech/jts/geom/Coordinate;", "seg", "Lorg/locationtech/jts/triangulate/Segment;", "encroachPt", "Companion", "kts-core"})
public final class NonEncroachingSplitPointFinder
implements ConstraintSplitPointFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public Coordinate findSplitPoint(@NotNull Segment seg, @Nullable Coordinate encroachPt) {
        double nonEncroachDiam;
        Intrinsics.checkNotNullParameter((Object)seg, (String)"seg");
        LineSegment lineSeg = seg.getLineSegment();
        double segLen = lineSeg.getLength();
        double midPtLen = segLen / (double)2;
        SplitSegment splitSeg = new SplitSegment(lineSeg);
        Coordinate projPt = Companion.projectedSplitPoint(seg, encroachPt);
        Coordinate coordinate = encroachPt;
        Intrinsics.checkNotNull((Object)coordinate);
        double maxSplitLen = nonEncroachDiam = projPt.distance(coordinate) * (double)2 * 0.8;
        if (maxSplitLen > midPtLen) {
            maxSplitLen = midPtLen;
        }
        splitSeg.setMinimumLength(maxSplitLen);
        splitSeg.splitAt(projPt);
        return splitSeg.getSplitPoint();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/triangulate/NonEncroachingSplitPointFinder$Companion;", "", "<init>", "()V", "projectedSplitPoint", "Lorg/locationtech/jts/geom/Coordinate;", "seg", "Lorg/locationtech/jts/triangulate/Segment;", "encroachPt", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Coordinate projectedSplitPoint(@NotNull Segment seg, @Nullable Coordinate encroachPt) {
            Intrinsics.checkNotNullParameter((Object)seg, (String)"seg");
            LineSegment lineSeg = seg.getLineSegment();
            Coordinate coordinate = encroachPt;
            Intrinsics.checkNotNull((Object)coordinate);
            return lineSeg.project(coordinate);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

