/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B9\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nBC\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\t\u0010\fB'\b\u0016\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\t\u0010\u0010B\u001d\b\u0016\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\t\u0010\u0011J\u0006\u0010\u0014\u001a\u00020\u000eJ\u0006\u0010\u0015\u001a\u00020\u000eJ\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\u001c\u001a\u00020\u0013J\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\u001e\u001a\u00020\u001f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0000J\u0010\u0010#\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\"\u001a\u00020\u0000J\b\u0010$\u001a\u00020%H\u0016R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/locationtech/jts/triangulate/Segment;", "", "x1", "", "y1", "z1", "x2", "y2", "z2", "<init>", "(DDDDDD)V", "data", "(DDDDDDLjava/lang/Object;)V", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Ljava/lang/Object;)V", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)V", "ls", "Lorg/locationtech/jts/geom/LineSegment;", "getStart", "getEnd", "getStartX", "getStartY", "getStartZ", "getEndX", "getEndY", "getEndZ", "getLineSegment", "getData", "setData", "", "equalsTopo", "", "s", "intersection", "toString", "", "kts-core"})
public final class Segment {
    @NotNull
    private LineSegment ls;
    @Nullable
    private Object data;

    public Segment(double x1, double y1, double z1, double x2, double y2, double z2) {
        this(new Coordinate(x1, y1, z1), new Coordinate(x2, y2, z2));
    }

    public Segment(double x1, double y1, double z1, double x2, double y2, double z2, @Nullable Object data) {
        this(new Coordinate(x1, y1, z1), new Coordinate(x2, y2, z2), data);
    }

    public Segment(@Nullable Coordinate p0, @Nullable Coordinate p1, @Nullable Object data) {
        Coordinate coordinate = p0;
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = p1;
        Intrinsics.checkNotNull((Object)coordinate2);
        this.ls = new LineSegment(coordinate, coordinate2);
        this.data = data;
    }

    public Segment(@Nullable Coordinate p0, @Nullable Coordinate p1) {
        Coordinate coordinate = p0;
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = p1;
        Intrinsics.checkNotNull((Object)coordinate2);
        this.ls = new LineSegment(coordinate, coordinate2);
    }

    @NotNull
    public final Coordinate getStart() {
        return this.ls.getCoordinate(0);
    }

    @NotNull
    public final Coordinate getEnd() {
        return this.ls.getCoordinate(1);
    }

    public final double getStartX() {
        Coordinate p = this.ls.getCoordinate(0);
        return p.x;
    }

    public final double getStartY() {
        Coordinate p = this.ls.getCoordinate(0);
        return p.y;
    }

    public final double getStartZ() {
        Coordinate p = this.ls.getCoordinate(0);
        return p.getZ();
    }

    public final double getEndX() {
        Coordinate p = this.ls.getCoordinate(1);
        return p.x;
    }

    public final double getEndY() {
        Coordinate p = this.ls.getCoordinate(1);
        return p.y;
    }

    public final double getEndZ() {
        Coordinate p = this.ls.getCoordinate(1);
        return p.getZ();
    }

    @NotNull
    public final LineSegment getLineSegment() {
        return this.ls;
    }

    @Nullable
    public final Object getData() {
        return this.data;
    }

    public final void setData(@Nullable Object data) {
        this.data = data;
    }

    public final boolean equalsTopo(@NotNull Segment s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return this.ls.equalsTopo(s.getLineSegment());
    }

    @Nullable
    public final Coordinate intersection(@NotNull Segment s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return this.ls.intersection(s.getLineSegment());
    }

    @NotNull
    public String toString() {
        return this.ls.toString();
    }
}

