/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\b\u0010\u000e\u001a\u0004\u0018\u00010\tJ\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\tJ\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/triangulate/SplitSegment;", "", "seg", "Lorg/locationtech/jts/geom/LineSegment;", "<init>", "(Lorg/locationtech/jts/geom/LineSegment;)V", "segLen", "", "splitPt", "Lorg/locationtech/jts/geom/Coordinate;", "minimumLen", "setMinimumLength", "", "minLen", "getSplitPoint", "splitAt", "length", "endPt", "pt", "getConstrainedLength", "len", "Companion", "kts-core"})
public final class SplitSegment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LineSegment seg;
    private final double segLen;
    @Nullable
    private Coordinate splitPt;
    private double minimumLen;

    public SplitSegment(@NotNull LineSegment seg) {
        Intrinsics.checkNotNullParameter((Object)seg, (String)"seg");
        this.seg = seg;
        this.segLen = this.seg.getLength();
    }

    public final void setMinimumLength(double minLen) {
        this.minimumLen = minLen;
    }

    @Nullable
    public final Coordinate getSplitPoint() {
        return this.splitPt;
    }

    public final void splitAt(double length, @NotNull Coordinate endPt) {
        Intrinsics.checkNotNullParameter((Object)endPt, (String)"endPt");
        double actualLen = this.getConstrainedLength(length);
        double frac = actualLen / this.segLen;
        this.splitPt = endPt.equals2D(this.seg.p0) ? this.seg.pointAlong(frac) : SplitSegment.Companion.pointAlongReverse(this.seg, frac);
    }

    public final void splitAt(@NotNull Coordinate pt) {
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        double minFrac = this.minimumLen / this.segLen;
        if (pt.distance(this.seg.p0) < this.minimumLen) {
            this.splitPt = this.seg.pointAlong(minFrac);
            return;
        }
        if (pt.distance(this.seg.p1) < this.minimumLen) {
            this.splitPt = SplitSegment.Companion.pointAlongReverse(this.seg, minFrac);
            return;
        }
        this.splitPt = pt;
    }

    private final double getConstrainedLength(double len) {
        return len < this.minimumLen ? this.minimumLen : len;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/triangulate/SplitSegment$Companion;", "", "<init>", "()V", "pointAlongReverse", "Lorg/locationtech/jts/geom/Coordinate;", "seg", "Lorg/locationtech/jts/geom/LineSegment;", "segmentLengthFraction", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Coordinate pointAlongReverse(LineSegment seg, double segmentLengthFraction) {
            Coordinate coord = new Coordinate();
            coord.x = seg.p1.x - segmentLengthFraction * (seg.p1.x - seg.p0.x);
            coord.y = seg.p1.y - segmentLengthFraction * (seg.p1.y - seg.p0.y);
            return coord;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

