/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.legacy.map.TreeMap;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ%\u0010\r\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u0011J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\fR\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/triangulate/VertexTaggedGeometryDataMapper;", "", "<init>", "()V", "coordDataMap", "", "Lorg/locationtech/jts/geom/Coordinate;", "loadSourceGeometries", "", "geoms", "", "geomColl", "Lorg/locationtech/jts/geom/Geometry;", "loadVertices", "pts", "", "data", "([Lorg/locationtech/jts/geom/Coordinate;Ljava/lang/Object;)V", "getCoordinates", "", "transferData", "targetGeom", "kts-core"})
public final class VertexTaggedGeometryDataMapper {
    @NotNull
    private final Map<Coordinate, Object> coordDataMap = new TreeMap(null, 1, null);

    public final void loadSourceGeometries(@NotNull Collection<?> geoms) {
        Intrinsics.checkNotNullParameter(geoms, (String)"geoms");
        for (Object obj : geoms) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
            Geometry geom = (Geometry)obj;
            Coordinate[] coordinateArray = geom.getCoordinates();
            Intrinsics.checkNotNull((Object)coordinateArray);
            this.loadVertices(coordinateArray, geom.getUserData());
        }
    }

    public final void loadSourceGeometries(@NotNull Geometry geomColl) {
        Intrinsics.checkNotNullParameter((Object)geomColl, (String)"geomColl");
        int n = geomColl.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geom = geomColl.getGeometryN(i);
            Coordinate[] coordinateArray = geom.getCoordinates();
            Intrinsics.checkNotNull((Object)coordinateArray);
            this.loadVertices(coordinateArray, geom.getUserData());
        }
    }

    private final void loadVertices(Coordinate[] pts, Object data) {
        int n = pts.length;
        for (int i = 0; i < n; ++i) {
            this.coordDataMap.put(pts[i], data);
        }
    }

    @NotNull
    public final List<Coordinate> getCoordinates() {
        return new ArrayList(this.coordDataMap.keySet());
    }

    public final void transferData(@NotNull Geometry targetGeom) {
        Intrinsics.checkNotNullParameter((Object)targetGeom, (String)"targetGeom");
        int n = targetGeom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Coordinate vertexKey;
            Geometry geom = targetGeom.getGeometryN(i);
            if ((Coordinate)geom.getUserData() == null) continue;
            geom.setUserData(this.coordDataMap.get(vertexKey));
        }
    }
}

