/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.IncrementalDelaunayTriangulator;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005J\u0010\u0010\u0012\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aR\u0014\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lorg/locationtech/jts/triangulate/VoronoiDiagramBuilder;", "", "<init>", "()V", "siteCoords", "", "tolerance", "", "subdiv", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision;", "clipEnv", "Lorg/locationtech/jts/geom/Envelope;", "diagramEnv", "setSites", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "coords", "setClipEnvelope", "setTolerance", "create", "subdivision", "getSubdivision", "()Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision;", "getDiagram", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "Companion", "kts-core"})
public final class VoronoiDiagramBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Collection<?> siteCoords;
    private double tolerance;
    @Nullable
    private QuadEdgeSubdivision subdiv;
    @Nullable
    private Envelope clipEnv;
    @Nullable
    private Envelope diagramEnv;

    public final void setSites(@Nullable Geometry geom) {
        this.siteCoords = DelaunayTriangulationBuilder.Companion.extractUniqueCoordinates(geom);
    }

    public final void setSites(@Nullable Collection<?> coords) {
        Collection<?> collection = coords;
        Intrinsics.checkNotNull(collection);
        this.siteCoords = DelaunayTriangulationBuilder.Companion.unique(CoordinateArrays.toCoordinateArray(collection));
    }

    public final void setClipEnvelope(@Nullable Envelope clipEnv) {
        this.clipEnv = clipEnv;
    }

    public final void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    private final void create() {
        if (this.subdiv != null) {
            return;
        }
        this.diagramEnv = this.clipEnv;
        if (this.diagramEnv == null) {
            Envelope envelope = this.diagramEnv = DelaunayTriangulationBuilder.Companion.envelope(this.siteCoords);
            Intrinsics.checkNotNull((Object)envelope);
            double expandBy = envelope.getDiameter();
            Envelope envelope2 = this.diagramEnv;
            Intrinsics.checkNotNull((Object)envelope2);
            envelope2.expandBy(expandBy);
        }
        List<Vertex> vertices = DelaunayTriangulationBuilder.Companion.toVertices(this.siteCoords);
        Envelope envelope = this.diagramEnv;
        Intrinsics.checkNotNull((Object)envelope);
        QuadEdgeSubdivision quadEdgeSubdivision = this.subdiv = new QuadEdgeSubdivision(envelope, this.tolerance);
        Intrinsics.checkNotNull((Object)quadEdgeSubdivision);
        IncrementalDelaunayTriangulator triangulator = new IncrementalDelaunayTriangulator(quadEdgeSubdivision);
        triangulator.insertSites((Collection)vertices);
    }

    @Nullable
    public final QuadEdgeSubdivision getSubdivision() {
        this.create();
        return this.subdiv;
    }

    @NotNull
    public final Geometry getDiagram(@Nullable GeometryFactory geomFact) {
        this.create();
        QuadEdgeSubdivision quadEdgeSubdivision = this.subdiv;
        Intrinsics.checkNotNull((Object)quadEdgeSubdivision);
        GeometryFactory geometryFactory = geomFact;
        Intrinsics.checkNotNull((Object)geometryFactory);
        Geometry polys = quadEdgeSubdivision.getVoronoiDiagram(geometryFactory);
        return VoronoiDiagramBuilder.Companion.clipGeometryCollection(polys, this.diagramEnv);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/triangulate/VoronoiDiagramBuilder$Companion;", "", "<init>", "()V", "clipGeometryCollection", "Lorg/locationtech/jts/geom/Geometry;", "geom", "clipEnv", "Lorg/locationtech/jts/geom/Envelope;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Geometry clipGeometryCollection(Geometry geom, Envelope clipEnv) {
            GeometryFactory geometryFactory = geom.getFactory();
            Envelope envelope = clipEnv;
            Intrinsics.checkNotNull((Object)envelope);
            Geometry clipPoly = geometryFactory.toGeometry(envelope);
            List clipped = new ArrayList();
            int n = geom.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry g = geom.getGeometryN(i);
                Geometry result2 = null;
                if (clipEnv.contains(g.getEnvelopeInternal())) {
                    result2 = g;
                } else if (clipEnv.intersects(g.getEnvelopeInternal())) {
                    result2 = clipPoly.intersection(g);
                    result2.setUserData(g.getUserData());
                }
                if (result2 == null || result2.isEmpty()) continue;
                clipped.add(result2);
            }
            return geom.getFactory().createGeometryCollection(GeometryFactory.Companion.toGeometryArray(clipped));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

