/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.polygon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.triangulate.polygon.PolygonEarClipper;
import org.locationtech.jts.triangulate.polygon.PolygonHoleJoiner;
import org.locationtech.jts.triangulate.polygon.TriDelaunayImprover;
import org.locationtech.jts.triangulate.tri.Tri;
import org.locationtech.jts.triangulate.tri.TriangulationBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/triangulate/polygon/ConstrainedDelaunayTriangulator;", "", "inputGeom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "triList", "", "Lorg/locationtech/jts/triangulate/tri/Tri;", "result", "getResult", "()Lorg/locationtech/jts/geom/Geometry;", "triangles", "", "getTriangles", "()Ljava/util/List;", "compute", "", "triangulatePolygon", "poly", "Lorg/locationtech/jts/geom/Polygon;", "Companion", "kts-core"})
public final class ConstrainedDelaunayTriangulator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeometryFactory geomFact;
    @NotNull
    private final Geometry inputGeom;
    @Nullable
    private List<Tri> triList;

    public ConstrainedDelaunayTriangulator(@NotNull Geometry inputGeom) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        this.geomFact = inputGeom.getFactory();
        this.inputGeom = inputGeom;
    }

    @NotNull
    public final Geometry getResult() {
        this.compute();
        List<Tri> list = this.triList;
        Intrinsics.checkNotNull(list);
        return Tri.Companion.toGeometry((Collection<? extends Tri>)list, this.geomFact);
    }

    @Nullable
    public final List<Tri> getTriangles() {
        this.compute();
        return this.triList;
    }

    private final void compute() {
        if (this.triList != null) {
            return;
        }
        List<Polygon> polys = PolygonExtracter.Companion.getPolygons(this.inputGeom);
        this.triList = new ArrayList();
        for (Polygon poly : polys) {
            List<Tri> polyTriList = this.triangulatePolygon(poly);
            List<Tri> list = this.triList;
            Intrinsics.checkNotNull(list);
            list.addAll((Collection<Tri>)polyTriList);
        }
    }

    @NotNull
    public final List<Tri> triangulatePolygon(@NotNull Polygon poly) {
        Intrinsics.checkNotNullParameter((Object)poly, (String)"poly");
        Geometry geometry = poly.norm();
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
        Polygon polyNorm = (Polygon)geometry;
        Coordinate[] polyShell = PolygonHoleJoiner.Companion.join(polyNorm);
        List<Tri> triList = PolygonEarClipper.Companion.triangulate(polyShell);
        TriangulationBuilder.Companion.build(triList);
        TriDelaunayImprover.Companion.improve(triList);
        return triList;
    }

    @JvmStatic
    @NotNull
    public static final Geometry triangulate(@NotNull Geometry geom) {
        return Companion.triangulate(geom);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/locationtech/jts/triangulate/polygon/ConstrainedDelaunayTriangulator$Companion;", "", "<init>", "()V", "triangulate", "Lorg/locationtech/jts/geom/Geometry;", "geom", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Geometry triangulate(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            ConstrainedDelaunayTriangulator cdt = new ConstrainedDelaunayTriangulator(geom);
            return cdt.getResult();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

