/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.polygon;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.index.VertexSequencePackedRtree;
import org.locationtech.jts.triangulate.tri.Tri;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J%\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\r2\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0019J%\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u001bJ%\u0010\u001c\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\r2\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001d\u001a\u00020\u0013H\u0002J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\b\u0010 \u001a\u00020\u0013H\u0002J\u001d\u0010!\u001a\u00020\u00132\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010#\u001a\u00020\u00132\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rH\u0002J\u0006\u0010&\u001a\u00020'R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/locationtech/jts/triangulate/polygon/PolygonEarClipper;", "", "vertex", "", "Lorg/locationtech/jts/geom/Coordinate;", "<init>", "([Lorg/locationtech/jts/geom/Coordinate;)V", "[Lorg/locationtech/jts/geom/Coordinate;", "isFlatCornersSkipped", "", "vertexNext", "", "vertexSize", "", "vertexFirst", "cornerIndex", "vertexCoordIndex", "Lorg/locationtech/jts/index/VertexSequencePackedRtree;", "setSkipFlatCorners", "", "compute", "", "Lorg/locationtech/jts/triangulate/tri/Tri;", "isValidEar", "corner", "(I[Lorg/locationtech/jts/geom/Coordinate;)Z", "findIntersectingVertex", "(I[Lorg/locationtech/jts/geom/Coordinate;)I", "isValidEarScan", "removeCorner", "isRemoved", "vertexIndex", "initCornerIndex", "fetchCorner", "cornerVertex", "nextCorner", "nextIndex", "index", "toGeometry", "Lorg/locationtech/jts/geom/Polygon;", "Companion", "kts-core"})
public final class PolygonEarClipper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinate[] vertex;
    private boolean isFlatCornersSkipped;
    @NotNull
    private final int[] vertexNext;
    private int vertexSize;
    private int vertexFirst;
    @Nullable
    private int[] cornerIndex;
    @NotNull
    private final VertexSequencePackedRtree vertexCoordIndex;
    private static final int NO_VERTEX_INDEX = -1;

    public PolygonEarClipper(@NotNull Coordinate[] vertex) {
        Intrinsics.checkNotNullParameter((Object)vertex, (String)"vertex");
        this.vertex = vertex;
        this.vertexSize = this.vertex.length - 1;
        this.vertexNext = PolygonEarClipper.Companion.createNextLinks(this.vertexSize);
        this.vertexFirst = 0;
        this.vertexCoordIndex = new VertexSequencePackedRtree(this.vertex);
    }

    public final void setSkipFlatCorners(boolean isFlatCornersSkipped) {
        this.isFlatCornersSkipped = isFlatCornersSkipped;
    }

    @NotNull
    public final List<Tri> compute() {
        List triList = new ArrayList();
        int cornerScanCount = 0;
        this.initCornerIndex();
        Object[] corner = new Coordinate[3];
        this.fetchCorner((Coordinate[])corner);
        while (true) {
            if (!PolygonEarClipper.Companion.isConvex((Coordinate[])corner)) {
                boolean isCornerRemoved;
                boolean bl = isCornerRemoved = PolygonEarClipper.Companion.isCornerInvalid((Coordinate[])corner) || this.isFlatCornersSkipped && PolygonEarClipper.Companion.isFlat((Coordinate[])corner);
                if (isCornerRemoved) {
                    this.removeCorner();
                }
                if (++cornerScanCount > 2 * this.vertexSize) {
                    throw new IllegalStateException("Unable to find a convex corner");
                }
            } else {
                Intrinsics.checkNotNull((Object)this.cornerIndex);
                if (this.isValidEar(this.cornerIndex[1], (Coordinate[])corner)) {
                    triList.add(Tri.Companion.create((Coordinate[])ArraysKt.requireNoNulls((Object[])corner)));
                    this.removeCorner();
                    cornerScanCount = 0;
                }
            }
            if (cornerScanCount > 2 * this.vertexSize) {
                throw new IllegalStateException("Unable to find a valid ear");
            }
            if (this.vertexSize < 3) {
                return triList;
            }
            this.nextCorner((Coordinate[])corner);
        }
    }

    private final boolean isValidEar(int cornerIndex, Coordinate[] corner) {
        int intApexIndex = this.findIntersectingVertex(cornerIndex, corner);
        if (intApexIndex == -1) {
            return true;
        }
        Coordinate coordinate = this.vertex[intApexIndex];
        Coordinate coordinate2 = corner[1];
        Intrinsics.checkNotNull((Object)coordinate2);
        return coordinate.equals2D(coordinate2) ? this.isValidEarScan(cornerIndex, corner) : false;
    }

    private final int findIntersectingVertex(int cornerIndex, Coordinate[] corner) {
        Envelope cornerEnv = PolygonEarClipper.Companion.envelope(corner);
        int[] result2 = this.vertexCoordIndex.query(cornerEnv);
        int dupApexIndex = -1;
        for (int vertIndex : result2) {
            if (vertIndex == cornerIndex || vertIndex == this.vertex.length - 1 || this.isRemoved(vertIndex)) continue;
            Coordinate v = this.vertex[vertIndex];
            Coordinate coordinate = corner[1];
            Intrinsics.checkNotNull((Object)coordinate);
            if (v.equals2D(coordinate)) {
                dupApexIndex = vertIndex;
                continue;
            }
            Coordinate coordinate2 = corner[0];
            Intrinsics.checkNotNull((Object)coordinate2);
            if (v.equals2D(coordinate2)) continue;
            Coordinate coordinate3 = corner[2];
            Intrinsics.checkNotNull((Object)coordinate3);
            if (v.equals2D(coordinate3) || !Triangle.Companion.intersects(corner[0], corner[1], corner[2], v)) continue;
            return vertIndex;
        }
        return dupApexIndex != -1 ? dupApexIndex : -1;
    }

    private final boolean isValidEarScan(int cornerIndex, Coordinate[] corner) {
        Coordinate coordinate = corner[0];
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = corner[1];
        Intrinsics.checkNotNull((Object)coordinate2);
        Coordinate coordinate3 = corner[2];
        Intrinsics.checkNotNull((Object)coordinate3);
        double cornerAngle = Angle.INSTANCE.angleBetweenOriented(coordinate, coordinate2, coordinate3);
        int currIndex = this.nextIndex(this.vertexFirst);
        int prevIndex = this.vertexFirst;
        Coordinate vPrev = this.vertex[prevIndex];
        int n = this.vertexSize;
        for (int i = 0; i < n; ++i) {
            Coordinate v = this.vertex[currIndex];
            if (currIndex != cornerIndex) {
                Coordinate coordinate4 = corner[1];
                Intrinsics.checkNotNull((Object)coordinate4);
                if (v.equals2D(coordinate4)) {
                    Coordinate vNext = this.vertex[this.nextIndex(currIndex)];
                    Coordinate coordinate5 = corner[0];
                    Intrinsics.checkNotNull((Object)coordinate5);
                    Coordinate coordinate6 = corner[1];
                    Intrinsics.checkNotNull((Object)coordinate6);
                    double aOut = Angle.INSTANCE.angleBetweenOriented(coordinate5, coordinate6, vNext);
                    Coordinate coordinate7 = corner[0];
                    Intrinsics.checkNotNull((Object)coordinate7);
                    Coordinate coordinate8 = corner[1];
                    Intrinsics.checkNotNull((Object)coordinate8);
                    Coordinate coordinate9 = vPrev;
                    Intrinsics.checkNotNull((Object)coordinate9);
                    double aIn = Angle.INSTANCE.angleBetweenOriented(coordinate7, coordinate8, coordinate9);
                    if (aOut > 0.0 && aOut < cornerAngle) {
                        return false;
                    }
                    if (aIn > 0.0 && aIn < cornerAngle) {
                        return false;
                    }
                    if (aOut == 0.0 && aIn == cornerAngle) {
                        return false;
                    }
                }
            }
            vPrev = v;
            prevIndex = currIndex;
            currIndex = this.nextIndex(currIndex);
        }
        return true;
    }

    private final void removeCorner() {
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        int cornerApexIndex = this.cornerIndex[1];
        if (this.vertexFirst == cornerApexIndex) {
            this.vertexFirst = this.vertexNext[cornerApexIndex];
        }
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        this.vertexNext[this.cornerIndex[0]] = this.vertexNext[cornerApexIndex];
        this.vertexCoordIndex.remove(cornerApexIndex);
        this.vertexNext[cornerApexIndex] = -1;
        int n = this.vertexSize;
        this.vertexSize = n + -1;
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        this.cornerIndex[1] = this.nextIndex(this.cornerIndex[0]);
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        this.cornerIndex[2] = this.nextIndex(this.cornerIndex[1]);
    }

    private final boolean isRemoved(int vertexIndex) {
        return -1 == this.vertexNext[vertexIndex];
    }

    private final void initCornerIndex() {
        this.cornerIndex = new int[3];
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        this.cornerIndex[0] = 0;
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        this.cornerIndex[1] = 1;
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        this.cornerIndex[2] = 2;
    }

    private final void fetchCorner(Coordinate[] cornerVertex) {
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        cornerVertex[0] = this.vertex[this.cornerIndex[0]];
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        cornerVertex[1] = this.vertex[this.cornerIndex[1]];
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        cornerVertex[2] = this.vertex[this.cornerIndex[2]];
    }

    private final void nextCorner(Coordinate[] cornerVertex) {
        if (this.vertexSize < 3) {
            return;
        }
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        this.cornerIndex[0] = this.nextIndex(this.cornerIndex[0]);
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        this.cornerIndex[1] = this.nextIndex(this.cornerIndex[0]);
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        Intrinsics.checkNotNull((Object)this.cornerIndex);
        this.cornerIndex[2] = this.nextIndex(this.cornerIndex[1]);
        this.fetchCorner(cornerVertex);
    }

    private final int nextIndex(int index) {
        return this.vertexNext[index];
    }

    @NotNull
    public final Polygon toGeometry() {
        GeometryFactory fact = new GeometryFactory();
        CoordinateList coordList = new CoordinateList();
        int index = this.vertexFirst;
        int n = this.vertexSize;
        for (int i = 0; i < n; ++i) {
            Coordinate v = this.vertex[index];
            index = this.nextIndex(index);
            coordList.add(v, true);
        }
        coordList.closeRing();
        return GeometryFactory.createPolygon$default(fact, fact.createLinearRing(coordList.toCoordinateArray()), null, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u001d\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0019\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/locationtech/jts/triangulate/polygon/PolygonEarClipper$Companion;", "", "<init>", "()V", "NO_VERTEX_INDEX", "", "triangulate", "", "Lorg/locationtech/jts/triangulate/tri/Tri;", "polyShell", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;)Ljava/util/List;", "createNextLinks", "", "size", "envelope", "Lorg/locationtech/jts/geom/Envelope;", "corner", "([Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/Envelope;", "isConvex", "", "pts", "([Lorg/locationtech/jts/geom/Coordinate;)Z", "isFlat", "isCornerInvalid", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Tri> triangulate(@NotNull Coordinate[] polyShell) {
            Intrinsics.checkNotNullParameter((Object)polyShell, (String)"polyShell");
            PolygonEarClipper clipper = new PolygonEarClipper(polyShell);
            return clipper.compute();
        }

        private final int[] createNextLinks(int size) {
            int[] next = new int[size];
            for (int i = 0; i < size; ++i) {
                next[i] = i + 1;
            }
            next[size - 1] = 0;
            return next;
        }

        private final Envelope envelope(Coordinate[] corner) {
            Coordinate coordinate = corner[0];
            Intrinsics.checkNotNull((Object)coordinate);
            Coordinate coordinate2 = corner[1];
            Intrinsics.checkNotNull((Object)coordinate2);
            Envelope cornerEnv = new Envelope(coordinate, coordinate2);
            Coordinate coordinate3 = corner[2];
            Intrinsics.checkNotNull((Object)coordinate3);
            cornerEnv.expandToInclude(coordinate3);
            return cornerEnv;
        }

        private final boolean isConvex(Coordinate[] pts) {
            return -1 == Orientation.index(pts[0], pts[1], pts[2]);
        }

        private final boolean isFlat(Coordinate[] pts) {
            return Orientation.index(pts[0], pts[1], pts[2]) == 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isCornerInvalid(Coordinate[] pts) {
            Coordinate coordinate = pts[1];
            Intrinsics.checkNotNull((Object)coordinate);
            Coordinate coordinate2 = pts[0];
            Intrinsics.checkNotNull((Object)coordinate2);
            if (coordinate.equals2D(coordinate2)) return true;
            Coordinate coordinate3 = pts[1];
            Intrinsics.checkNotNull((Object)coordinate3);
            Coordinate coordinate4 = pts[2];
            Intrinsics.checkNotNull((Object)coordinate4);
            if (coordinate3.equals2D(coordinate4)) return true;
            Coordinate coordinate5 = pts[0];
            Intrinsics.checkNotNull((Object)coordinate5);
            Coordinate coordinate6 = pts[2];
            Intrinsics.checkNotNull((Object)coordinate6);
            if (!coordinate5.equals2D(coordinate6)) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

