/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.polygon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.legacy.TreeSet;
import org.locationtech.jts.noding.BasicSegmentString;
import org.locationtech.jts.noding.MCIndexSegmentSetMutualIntersector;
import org.locationtech.jts.noding.SegmentIntersectionDetector;
import org.locationtech.jts.noding.SegmentSetMutualIntersector;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.SegmentStringUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 02\u00020\u0001:\u0002/0B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001bH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"2\u0006\u0010#\u001a\u00020\bH\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010#\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH\u0002J\u0018\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\bH\u0002J+\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010-\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010.R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000RN\u0010\u000b\u001aB\u0012\u0004\u0012\u00020\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b0\rj\b\u0012\u0004\u0012\u00020\b`\u000e\u0018\u00010\fj \u0012\u0004\u0012\u00020\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b0\rj\b\u0012\u0004\u0012\u00020\b`\u000e\u0018\u0001`\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/locationtech/jts/triangulate/polygon/PolygonHoleJoiner;", "", "inputPolygon", "Lorg/locationtech/jts/geom/Polygon;", "<init>", "(Lorg/locationtech/jts/geom/Polygon;)V", "shellCoords", "", "Lorg/locationtech/jts/geom/Coordinate;", "shellCoordsSorted", "Lorg/locationtech/jts/legacy/TreeSet;", "cutMap", "Ljava/util/HashMap;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "Lkotlin/collections/HashMap;", "polygonIntersector", "Lorg/locationtech/jts/noding/SegmentSetMutualIntersector;", "compute", "", "()[Lorg/locationtech/jts/geom/Coordinate;", "joinHoles", "", "joinHole", "hole", "Lorg/locationtech/jts/geom/LinearRing;", "getShellCoordIndex", "", "shellVertex", "holeVertex", "getShellCoordIndexSkip", "coord", "numSkip", "findLeftShellVertices", "", "holeCoord", "isJoinable", "", "shellCoord", "crossesPolygon", "p0", "p1", "addHoleToShell", "shellJoinIndex", "holeCoords", "holeJoinIndex", "(I[Lorg/locationtech/jts/geom/Coordinate;I)V", "EnvelopeComparator", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nPolygonHoleJoiner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolygonHoleJoiner.kt\norg/locationtech/jts/triangulate/polygon/PolygonHoleJoiner\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,330:1\n37#2,2:331\n*S KotlinDebug\n*F\n+ 1 PolygonHoleJoiner.kt\norg/locationtech/jts/triangulate/polygon/PolygonHoleJoiner\n*L\n54#1:331,2\n*E\n"})
public final class PolygonHoleJoiner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Polygon inputPolygon;
    @Nullable
    private List<Coordinate> shellCoords;
    @Nullable
    private TreeSet<Coordinate> shellCoordsSorted;
    @Nullable
    private HashMap<Coordinate, ArrayList<Coordinate>> cutMap;
    @NotNull
    private final SegmentSetMutualIntersector polygonIntersector;
    private static final double EPS = 1.0E-4;

    public PolygonHoleJoiner(@NotNull Polygon inputPolygon) {
        Intrinsics.checkNotNullParameter((Object)inputPolygon, (String)"inputPolygon");
        this.inputPolygon = inputPolygon;
        this.polygonIntersector = PolygonHoleJoiner.Companion.createPolygonIntersector(this.inputPolygon);
    }

    @NotNull
    public final Coordinate[] compute() {
        LinearRing linearRing = this.inputPolygon.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        this.shellCoords = PolygonHoleJoiner.Companion.ringCoordinates(linearRing);
        if (this.inputPolygon.getNumInteriorRing() != 0) {
            this.joinHoles();
        }
        List<Coordinate> list = this.shellCoords;
        Intrinsics.checkNotNull(list);
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Coordinate[0]);
    }

    private final void joinHoles() {
        TreeSet<Coordinate> treeSet = this.shellCoordsSorted = new TreeSet(null, null, 3, null);
        Intrinsics.checkNotNull(treeSet);
        List<Coordinate> list = this.shellCoords;
        Intrinsics.checkNotNull(list);
        treeSet.addAll(list);
        this.cutMap = new HashMap();
        List orderedHoles = PolygonHoleJoiner.Companion.sortHoles(this.inputPolygon);
        int n = ((Collection)orderedHoles).size();
        for (int i = 0; i < n; ++i) {
            this.joinHole((LinearRing)orderedHoles.get(i));
        }
    }

    private final void joinHole(LinearRing hole) {
        Coordinate[] holeCoords = hole.getCoordinates();
        List holeLeftVerticesIndex = PolygonHoleJoiner.Companion.findLeftVertices(hole);
        Coordinate holeCoord = holeCoords[((Number)holeLeftVerticesIndex.get(0)).intValue()];
        List<Coordinate> shellCoordsList = this.findLeftShellVertices(holeCoord);
        Coordinate shellCoord = shellCoordsList.get(0);
        int shortestHoleVertexIndex = 0;
        if (Math.INSTANCE.abs(shellCoord.x - holeCoord.x) < 1.0E-4) {
            double shortest = Double.MAX_VALUE;
            int n = ((Collection)holeLeftVerticesIndex).size();
            for (int i = 0; i < n; ++i) {
                int n2 = ((Collection)shellCoordsList).size();
                for (int j = 0; j < n2; ++j) {
                    double currLength = Math.INSTANCE.abs(shellCoordsList.get((int)j).y - holeCoords[((Number)holeLeftVerticesIndex.get((int)i)).intValue()].y);
                    if (!(currLength < shortest)) continue;
                    shortest = currLength;
                    shortestHoleVertexIndex = i;
                    shellCoord = shellCoordsList.get(j);
                }
            }
        }
        int shellVertexIndex = this.getShellCoordIndex(shellCoord, holeCoords[((Number)holeLeftVerticesIndex.get(shortestHoleVertexIndex)).intValue()]);
        this.addHoleToShell(shellVertexIndex, holeCoords, ((Number)holeLeftVerticesIndex.get(shortestHoleVertexIndex)).intValue());
    }

    private final int getShellCoordIndex(Coordinate shellVertex, Coordinate holeVertex) {
        int numSkip = 0;
        ArrayList<Coordinate> newValueList = new ArrayList<Coordinate>();
        newValueList.add(holeVertex);
        HashMap<Coordinate, ArrayList<Coordinate>> hashMap = this.cutMap;
        Intrinsics.checkNotNull(hashMap);
        if (hashMap.containsKey(shellVertex)) {
            HashMap<Coordinate, ArrayList<Coordinate>> hashMap2 = this.cutMap;
            Intrinsics.checkNotNull(hashMap2);
            ArrayList<Coordinate> arrayList = hashMap2.get(shellVertex);
            Intrinsics.checkNotNull(arrayList);
            Iterator<Coordinate> iterator2 = arrayList.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<Coordinate> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Coordinate coord;
                Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                if (!(coord.y < holeVertex.y)) continue;
                ++numSkip;
            }
            HashMap<Coordinate, ArrayList<Coordinate>> hashMap3 = this.cutMap;
            Intrinsics.checkNotNull(hashMap3);
            ArrayList<Coordinate> arrayList2 = hashMap3.get(shellVertex);
            Intrinsics.checkNotNull(arrayList2);
            arrayList2.add(holeVertex);
        } else {
            HashMap<Coordinate, ArrayList<Coordinate>> hashMap4 = this.cutMap;
            Intrinsics.checkNotNull(hashMap4);
            ((Map)hashMap4).put(shellVertex, newValueList);
        }
        HashMap<Coordinate, ArrayList<Coordinate>> hashMap5 = this.cutMap;
        Intrinsics.checkNotNull(hashMap5);
        if (!hashMap5.containsKey(holeVertex)) {
            HashMap<Coordinate, ArrayList<Coordinate>> hashMap6 = this.cutMap;
            Intrinsics.checkNotNull(hashMap6);
            ((Map)hashMap6).put(holeVertex, new ArrayList(newValueList));
        }
        return this.getShellCoordIndexSkip(shellVertex, numSkip);
    }

    private final int getShellCoordIndexSkip(Coordinate coord, int numSkip) {
        int numSkip2 = numSkip;
        List<Coordinate> list = this.shellCoords;
        Intrinsics.checkNotNull(list);
        int n = ((Collection)list).size();
        for (int i = 0; i < n; ++i) {
            List<Coordinate> list2 = this.shellCoords;
            Intrinsics.checkNotNull(list2);
            if (!list2.get(i).equals2D(coord, 1.0E-4)) continue;
            if (numSkip2 == 0) {
                return i;
            }
            --numSkip2;
        }
        throw new IllegalStateException("Vertex is not in shellcoords");
    }

    private final List<Coordinate> findLeftShellVertices(Coordinate holeCoord) {
        TreeSet<Coordinate> treeSet;
        ArrayList<Coordinate> list = new ArrayList<Coordinate>();
        TreeSet<Coordinate> treeSet2 = this.shellCoordsSorted;
        Intrinsics.checkNotNull(treeSet2);
        Coordinate closest = treeSet2.higher((Coordinate)((Comparable)holeCoord));
        while (closest.x == holeCoord.x) {
            TreeSet<Coordinate> treeSet3 = this.shellCoordsSorted;
            Intrinsics.checkNotNull(treeSet3);
            closest = treeSet3.higher((Coordinate)((Comparable)closest));
        }
        do {
            TreeSet<Coordinate> treeSet4 = this.shellCoordsSorted;
            Intrinsics.checkNotNull(treeSet4);
            closest = treeSet4.lower((Coordinate)((Comparable)closest));
            if (this.isJoinable(holeCoord, closest)) break;
            treeSet = this.shellCoordsSorted;
            Intrinsics.checkNotNull(treeSet);
        } while (!Intrinsics.areEqual((Object)closest, (Object)CollectionsKt.first((Iterable)((Iterable)((Object)treeSet)))));
        list.add(closest);
        if (!(closest.x == holeCoord.x)) {
            return list;
        }
        double chosenX = closest.x;
        list.clear();
        while (chosenX == closest.x) {
            list.add(closest);
            TreeSet<Coordinate> treeSet5 = this.shellCoordsSorted;
            Intrinsics.checkNotNull(treeSet5);
            if ((closest = treeSet5.lower((Coordinate)((Comparable)closest))) != null) continue;
            return list;
        }
        return list;
    }

    private final boolean isJoinable(Coordinate holeCoord, Coordinate shellCoord) {
        return !this.crossesPolygon(holeCoord, shellCoord);
    }

    private final boolean crossesPolygon(Coordinate p0, Coordinate p1) {
        Coordinate[] coordinateArray = new Coordinate[]{p0, p1};
        SegmentString segString = new BasicSegmentString(coordinateArray, null);
        List segStrings = new ArrayList();
        segStrings.add(segString);
        SegmentIntersectionDetector segInt = new SegmentIntersectionDetector(null, 1, null);
        segInt.setFindProper(true);
        this.polygonIntersector.process(segStrings, segInt);
        return segInt.hasProperIntersection();
    }

    private final void addHoleToShell(int shellJoinIndex, Coordinate[] holeCoords, int holeJoinIndex) {
        List<Coordinate> list = this.shellCoords;
        Intrinsics.checkNotNull(list);
        Coordinate shellJoinPt = list.get(shellJoinIndex);
        Coordinate holeJoinPt = holeCoords[holeJoinIndex];
        boolean isJoinTouching = shellJoinPt.equals2D(holeJoinPt);
        List newSection = new ArrayList();
        if (!isJoinTouching) {
            newSection.add(new Coordinate(shellJoinPt));
        }
        int nPts = holeCoords.length - 1;
        int i = holeJoinIndex;
        do {
            newSection.add(new Coordinate(holeCoords[i]));
        } while ((i = (i + 1) % nPts) != holeJoinIndex);
        if (!isJoinTouching) {
            newSection.add(new Coordinate(holeCoords[holeJoinIndex]));
        }
        List<Coordinate> list2 = this.shellCoords;
        Intrinsics.checkNotNull(list2);
        list2.addAll(shellJoinIndex, newSection);
        TreeSet<Coordinate> treeSet = this.shellCoordsSorted;
        Intrinsics.checkNotNull(treeSet);
        treeSet.addAll(newSection);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/locationtech/jts/triangulate/polygon/PolygonHoleJoiner$Companion;", "", "<init>", "()V", "joinAsPolygon", "Lorg/locationtech/jts/geom/Polygon;", "inputPolygon", "join", "", "Lorg/locationtech/jts/geom/Coordinate;", "(Lorg/locationtech/jts/geom/Polygon;)[Lorg/locationtech/jts/geom/Coordinate;", "EPS", "", "ringCoordinates", "", "ring", "Lorg/locationtech/jts/geom/LinearRing;", "sortHoles", "", "poly", "findLeftVertices", "", "createPolygonIntersector", "Lorg/locationtech/jts/noding/SegmentSetMutualIntersector;", "polygon", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Polygon joinAsPolygon(@NotNull Polygon inputPolygon) {
            Intrinsics.checkNotNullParameter((Object)inputPolygon, (String)"inputPolygon");
            return inputPolygon.getFactory().createPolygon(this.join(inputPolygon));
        }

        @NotNull
        public final Coordinate[] join(@NotNull Polygon inputPolygon) {
            Intrinsics.checkNotNullParameter((Object)inputPolygon, (String)"inputPolygon");
            PolygonHoleJoiner joiner = new PolygonHoleJoiner(inputPolygon);
            return joiner.compute();
        }

        private final List<Coordinate> ringCoordinates(LinearRing ring) {
            Coordinate[] coords = ring.getCoordinates();
            List coordList = new ArrayList();
            for (Coordinate p : coords) {
                coordList.add(p);
            }
            return coordList;
        }

        private final List<LinearRing> sortHoles(Polygon poly) {
            List holes = new ArrayList();
            int n = poly.getNumInteriorRing();
            for (int i = 0; i < n; ++i) {
                holes.add(poly.getInteriorRingN(i));
            }
            CollectionsKt.sortWith((List)holes, (Comparator)new EnvelopeComparator());
            return holes;
        }

        private final List<Integer> findLeftVertices(LinearRing ring) {
            Coordinate[] coords = ring.getCoordinates();
            ArrayList<Integer> leftmostIndex = new ArrayList<Integer>();
            double leftX = ring.getEnvelopeInternal().getMinX();
            int n = coords.length - 1;
            for (int i = 0; i < n; ++i) {
                if (!(Math.INSTANCE.abs(coords[i].x - leftX) < 1.0E-4)) continue;
                leftmostIndex.add(i);
            }
            return leftmostIndex;
        }

        private final SegmentSetMutualIntersector createPolygonIntersector(Polygon polygon) {
            List<SegmentString> polySegStrings = SegmentStringUtil.extractSegmentStrings(polygon);
            return new MCIndexSegmentSetMutualIntersector((Collection)polySegStrings);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/triangulate/polygon/PolygonHoleJoiner$EnvelopeComparator;", "Ljava/util/Comparator;", "Lorg/locationtech/jts/geom/Geometry;", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "o1", "o2", "kts-core"})
    private static final class EnvelopeComparator
    implements Comparator<Geometry> {
        @Override
        public int compare(@NotNull Geometry o1, @NotNull Geometry o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            Envelope e1 = o1.getEnvelopeInternal();
            Envelope e2 = o2.getEnvelopeInternal();
            return e1.compareTo(e2);
        }
    }
}

