/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.quadedge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.legacy.LinkedListKt;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeTriangle;
import org.locationtech.jts.triangulate.quadedge.TraversalVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u0014\u0010\b\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/locationtech/jts/triangulate/quadedge/EdgeConnectedTriangleTraversal;", "", "<init>", "()V", "triQueue", "Ljava/util/ArrayList;", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeTriangle;", "Lorg/locationtech/jts/legacy/LinkedList;", "init", "", "tri", "tris", "", "visitAll", "visitor", "Lorg/locationtech/jts/triangulate/quadedge/TraversalVisitor;", "process", "currTri", "kts-core"})
public final class EdgeConnectedTriangleTraversal {
    @NotNull
    private final ArrayList<QuadEdgeTriangle> triQueue = new ArrayList();

    public final void init(@NotNull QuadEdgeTriangle tri) {
        Intrinsics.checkNotNullParameter((Object)tri, (String)"tri");
        LinkedListKt.addLast(this.triQueue, tri);
    }

    public final void init(@NotNull Collection<QuadEdgeTriangle> tris) {
        Intrinsics.checkNotNullParameter(tris, (String)"tris");
        this.triQueue.addAll(tris);
    }

    public final void visitAll(@NotNull TraversalVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        while (!this.triQueue.isEmpty()) {
            this.process((QuadEdgeTriangle)CollectionsKt.removeFirst((List)this.triQueue), visitor);
        }
    }

    private final void process(QuadEdgeTriangle currTri, TraversalVisitor visitor) {
        currTri.getNeighbours();
        for (int i = 0; i < 3; ++i) {
            QuadEdge quadEdge = currTri.getEdge(i).sym();
            Intrinsics.checkNotNull((Object)quadEdge);
            Object object = quadEdge.getData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.triangulate.quadedge.QuadEdgeTriangle");
            QuadEdgeTriangle neighTri = (QuadEdgeTriangle)object;
            if (!visitor.visit(currTri, i, neighTri)) continue;
            LinkedListKt.addLast(this.triQueue, neighTri);
        }
    }
}

