/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.quadedge;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.triangulate.quadedge.Vertex;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 12\u00020\u0001:\u00011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0015\u001a\u00020\u00112\b\u0010\u0007\u001a\u0004\u0018\u00010\u0000J\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0000J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0000J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0000J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0000J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0000J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0000J\b\u0010\u001c\u001a\u0004\u0018\u00010\u0000J\b\u0010\u001d\u001a\u0004\u0018\u00010\u0000J\b\u0010\u001e\u001a\u0004\u0018\u00010\u0000J\b\u0010\u001f\u001a\u0004\u0018\u00010\u0000J\u0010\u0010 \u001a\u00020\u00112\b\u0010!\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\"\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010\u0006J\b\u0010$\u001a\u0004\u0018\u00010\u0006J\b\u0010%\u001a\u0004\u0018\u00010\u0006J\u000e\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0000J\u0010\u0010,\u001a\u00020\u00132\b\u0010+\u001a\u0004\u0018\u00010\u0000J\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u000200H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u00062"}, d2={"Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "", "<init>", "()V", "rot", "vertex", "Lorg/locationtech/jts/triangulate/quadedge/Vertex;", "next", "data", "getData", "()Ljava/lang/Object;", "setData", "(Ljava/lang/Object;)V", "primary", "getPrimary", "()Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "delete", "", "isLive", "", "()Z", "setNext", "invRot", "sym", "oNext", "oPrev", "dNext", "dPrev", "lNext", "lPrev", "rNext", "rPrev", "setOrig", "o", "setDest", "d", "orig", "dest", "length", "", "getLength", "()D", "equalsNonOriented", "qe", "equalsOriented", "toLineSegment", "Lorg/locationtech/jts/geom/LineSegment;", "toString", "", "Companion", "kts-core"})
public final class QuadEdge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private QuadEdge rot;
    @Nullable
    private Vertex vertex;
    @Nullable
    private QuadEdge next;
    @Nullable
    private Object data;

    private QuadEdge() {
    }

    @Nullable
    public final Object getData() {
        return this.data;
    }

    public final void setData(@Nullable Object object) {
        this.data = object;
    }

    @Nullable
    public final QuadEdge getPrimary() {
        Vertex vertex = this.orig();
        Intrinsics.checkNotNull((Object)vertex);
        Coordinate coordinate = vertex.getCoordinate();
        Vertex vertex2 = this.dest();
        Intrinsics.checkNotNull((Object)vertex2);
        return coordinate.compareTo(vertex2.getCoordinate()) <= 0 ? this : this.sym();
    }

    public final void delete() {
        this.rot = null;
    }

    public final boolean isLive() {
        return this.rot != null;
    }

    public final void setNext(@Nullable QuadEdge next) {
        this.next = next;
    }

    @Nullable
    public final QuadEdge rot() {
        return this.rot;
    }

    @Nullable
    public final QuadEdge invRot() {
        QuadEdge quadEdge = this.rot;
        Intrinsics.checkNotNull((Object)quadEdge);
        return quadEdge.sym();
    }

    @Nullable
    public final QuadEdge sym() {
        QuadEdge quadEdge = this.rot;
        Intrinsics.checkNotNull((Object)quadEdge);
        return quadEdge.rot;
    }

    @Nullable
    public final QuadEdge oNext() {
        return this.next;
    }

    @Nullable
    public final QuadEdge oPrev() {
        QuadEdge quadEdge = this.rot;
        Intrinsics.checkNotNull((Object)quadEdge);
        QuadEdge quadEdge2 = quadEdge.next;
        Intrinsics.checkNotNull((Object)quadEdge2);
        return quadEdge2.rot;
    }

    @Nullable
    public final QuadEdge dNext() {
        QuadEdge quadEdge = this.sym();
        Intrinsics.checkNotNull((Object)quadEdge);
        QuadEdge quadEdge2 = quadEdge.oNext();
        Intrinsics.checkNotNull((Object)quadEdge2);
        return quadEdge2.sym();
    }

    @Nullable
    public final QuadEdge dPrev() {
        QuadEdge quadEdge = this.invRot();
        Intrinsics.checkNotNull((Object)quadEdge);
        QuadEdge quadEdge2 = quadEdge.oNext();
        Intrinsics.checkNotNull((Object)quadEdge2);
        return quadEdge2.invRot();
    }

    @Nullable
    public final QuadEdge lNext() {
        QuadEdge quadEdge = this.invRot();
        Intrinsics.checkNotNull((Object)quadEdge);
        QuadEdge quadEdge2 = quadEdge.oNext();
        Intrinsics.checkNotNull((Object)quadEdge2);
        return quadEdge2.rot();
    }

    @Nullable
    public final QuadEdge lPrev() {
        QuadEdge quadEdge = this.next;
        Intrinsics.checkNotNull((Object)quadEdge);
        return quadEdge.sym();
    }

    @Nullable
    public final QuadEdge rNext() {
        QuadEdge quadEdge = this.rot;
        Intrinsics.checkNotNull((Object)quadEdge);
        QuadEdge quadEdge2 = quadEdge.next;
        Intrinsics.checkNotNull((Object)quadEdge2);
        return quadEdge2.invRot();
    }

    @Nullable
    public final QuadEdge rPrev() {
        QuadEdge quadEdge = this.sym();
        Intrinsics.checkNotNull((Object)quadEdge);
        return quadEdge.oNext();
    }

    public final void setOrig(@Nullable Vertex o) {
        this.vertex = o;
    }

    public final void setDest(@Nullable Vertex d) {
        QuadEdge quadEdge = this.sym();
        Intrinsics.checkNotNull((Object)quadEdge);
        quadEdge.setOrig(d);
    }

    @Nullable
    public final Vertex orig() {
        return this.vertex;
    }

    @Nullable
    public final Vertex dest() {
        QuadEdge quadEdge = this.sym();
        Intrinsics.checkNotNull((Object)quadEdge);
        return quadEdge.orig();
    }

    public final double getLength() {
        Vertex vertex = this.orig();
        Intrinsics.checkNotNull((Object)vertex);
        Coordinate coordinate = vertex.getCoordinate();
        Vertex vertex2 = this.dest();
        Intrinsics.checkNotNull((Object)vertex2);
        return coordinate.distance(vertex2.getCoordinate());
    }

    public final boolean equalsNonOriented(@NotNull QuadEdge qe) {
        Intrinsics.checkNotNullParameter((Object)qe, (String)"qe");
        if (this.equalsOriented(qe)) {
            return true;
        }
        return this.equalsOriented(qe.sym());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equalsOriented(@Nullable QuadEdge qe) {
        Vertex vertex = this.orig();
        Intrinsics.checkNotNull((Object)vertex);
        Coordinate coordinate = vertex.getCoordinate();
        QuadEdge quadEdge = qe;
        Intrinsics.checkNotNull((Object)quadEdge);
        Vertex vertex2 = quadEdge.orig();
        Intrinsics.checkNotNull((Object)vertex2);
        if (!coordinate.equals2D(vertex2.getCoordinate())) return false;
        Vertex vertex3 = this.dest();
        Intrinsics.checkNotNull((Object)vertex3);
        Coordinate coordinate2 = vertex3.getCoordinate();
        Vertex vertex4 = qe.dest();
        Intrinsics.checkNotNull((Object)vertex4);
        if (!coordinate2.equals2D(vertex4.getCoordinate())) return false;
        return true;
    }

    @NotNull
    public final LineSegment toLineSegment() {
        Vertex vertex = this.vertex;
        Intrinsics.checkNotNull((Object)vertex);
        Coordinate coordinate = vertex.getCoordinate();
        Vertex vertex2 = this.dest();
        Intrinsics.checkNotNull((Object)vertex2);
        return new LineSegment(coordinate, vertex2.getCoordinate());
    }

    @NotNull
    public String toString() {
        Vertex vertex = this.vertex;
        Intrinsics.checkNotNull((Object)vertex);
        Coordinate p0 = vertex.getCoordinate();
        Vertex vertex2 = this.dest();
        Intrinsics.checkNotNull((Object)vertex2);
        Coordinate p1 = vertex2.getCoordinate();
        return WKTWriter.Companion.toLineString(p0, p1);
    }

    public /* synthetic */ QuadEdge(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u001a\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/triangulate/quadedge/QuadEdge$Companion;", "", "<init>", "()V", "makeEdge", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "o", "Lorg/locationtech/jts/triangulate/quadedge/Vertex;", "d", "connect", "a", "b", "splice", "", "swap", "e", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QuadEdge makeEdge(@Nullable Vertex o, @Nullable Vertex d) {
            QuadEdge q0 = new QuadEdge(null);
            QuadEdge q1 = new QuadEdge(null);
            QuadEdge q2 = new QuadEdge(null);
            QuadEdge q3 = new QuadEdge(null);
            q0.rot = q1;
            q1.rot = q2;
            q2.rot = q3;
            q3.rot = q0;
            q0.setNext(q0);
            q1.setNext(q3);
            q2.setNext(q2);
            q3.setNext(q1);
            q0.setOrig(o);
            q0.setDest(d);
            return q0;
        }

        @NotNull
        public final QuadEdge connect(@NotNull QuadEdge a, @NotNull QuadEdge b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            QuadEdge e = this.makeEdge(a.dest(), b.orig());
            this.splice(e, a.lNext());
            this.splice(e.sym(), b);
            return e;
        }

        public final void splice(@Nullable QuadEdge a, @Nullable QuadEdge b) {
            QuadEdge quadEdge = a;
            Intrinsics.checkNotNull((Object)quadEdge);
            QuadEdge quadEdge2 = quadEdge.oNext();
            Intrinsics.checkNotNull((Object)quadEdge2);
            QuadEdge alpha = quadEdge2.rot();
            QuadEdge quadEdge3 = b;
            Intrinsics.checkNotNull((Object)quadEdge3);
            QuadEdge quadEdge4 = quadEdge3.oNext();
            Intrinsics.checkNotNull((Object)quadEdge4);
            QuadEdge beta = quadEdge4.rot();
            QuadEdge t1 = b.oNext();
            QuadEdge t2 = a.oNext();
            QuadEdge quadEdge5 = beta;
            Intrinsics.checkNotNull((Object)quadEdge5);
            QuadEdge t3 = quadEdge5.oNext();
            QuadEdge quadEdge6 = alpha;
            Intrinsics.checkNotNull((Object)quadEdge6);
            QuadEdge t4 = quadEdge6.oNext();
            a.setNext(t1);
            b.setNext(t2);
            alpha.setNext(t3);
            beta.setNext(t4);
        }

        public final void swap(@NotNull QuadEdge e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            QuadEdge a = e.oPrev();
            QuadEdge quadEdge = e.sym();
            Intrinsics.checkNotNull((Object)quadEdge);
            QuadEdge b = quadEdge.oPrev();
            this.splice(e, a);
            this.splice(e.sym(), b);
            QuadEdge quadEdge2 = a;
            Intrinsics.checkNotNull((Object)quadEdge2);
            this.splice(e, quadEdge2.lNext());
            QuadEdge quadEdge3 = e.sym();
            QuadEdge quadEdge4 = b;
            Intrinsics.checkNotNull((Object)quadEdge4);
            this.splice(quadEdge3, quadEdge4.lNext());
            e.setOrig(a.dest());
            e.setDest(b.dest());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

