/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.quadedge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.legacy.StackKt;
import org.locationtech.jts.triangulate.quadedge.LastFoundQuadEdgeLocator;
import org.locationtech.jts.triangulate.quadedge.LocateFailureException;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeLocator;
import org.locationtech.jts.triangulate.quadedge.TriangleVisitor;
import org.locationtech.jts.triangulate.quadedge.Vertex;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \\2\u00020\u0001:\u0005XYZ[\\B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\"\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u001a\u0010#\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010\u00132\b\u0010%\u001a\u0004\u0018\u00010\u0013J\u0016\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u000eJ\u000e\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u000eJ\u0016\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u000eJ\u0010\u0010.\u001a\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010\u0013J\u0010\u0010.\u001a\u00020\u000e2\b\u0010/\u001a\u0004\u0018\u000100J\u001c\u0010.\u001a\u0004\u0018\u00010\u000e2\b\u00101\u001a\u0004\u0018\u0001002\b\u00102\u001a\u0004\u0018\u000100J\u000e\u00103\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u0013J\u000e\u00104\u001a\u0002052\u0006\u0010*\u001a\u00020\u000eJ\u000e\u00106\u001a\u0002052\u0006\u0010*\u001a\u00020\u000eJ\u000e\u00107\u001a\u0002052\u0006\u0010,\u001a\u00020\u0013J\u0018\u0010:\u001a\u0002052\u0006\u0010*\u001a\u00020\u000e2\b\u0010/\u001a\u0004\u0018\u000100J\u0016\u0010;\u001a\u0002052\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u0013J\u0012\u0010<\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010=\u001a\u000205J\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010=\u001a\u000205J\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010=\u001a\u000205J\u0016\u0010@\u001a\u00020\u00192\u0006\u0010A\u001a\u00020B2\u0006\u0010=\u001a\u000205JK\u0010E\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00122\u0006\u0010F\u001a\u00020\u000e2\u0016\u0010G\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`H2\u0006\u0010=\u001a\u0002052\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u000e0JH\u0002\u00a2\u0006\u0002\u0010KJ\u001a\u0010L\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00120\r2\u0006\u0010=\u001a\u000205J\u001a\u0010M\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\r2\u0006\u0010=\u001a\u000205J\u001a\u0010N\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002000\u00120\r2\u0006\u0010=\u001a\u000205J\u000e\u0010 \u001a\u00020O2\u0006\u0010P\u001a\u00020QJ\u000e\u0010R\u001a\u00020O2\u0006\u0010P\u001a\u00020QJ\u000e\u0010S\u001a\u00020O2\u0006\u0010P\u001a\u00020QJ\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00020U0\r2\u0006\u0010P\u001a\u00020QJ\u0016\u0010V\u001a\u00020U2\u0006\u0010W\u001a\u00020\u000e2\u0006\u0010P\u001a\u00020QR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0015\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010C\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010D\u00a8\u0006]"}, d2={"Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision;", "", "env", "Lorg/locationtech/jts/geom/Envelope;", "tolerance", "", "<init>", "(Lorg/locationtech/jts/geom/Envelope;D)V", "getTolerance", "()D", "visitedKey", "", "quadEdges", "", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "startingEdge", "edgeCoincidenceTolerance", "frameVertex", "", "Lorg/locationtech/jts/triangulate/quadedge/Vertex;", "[Lorg/locationtech/jts/triangulate/quadedge/Vertex;", "frameEnv", "locator", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeLocator;", "createFrame", "", "initSubdiv", "envelope", "getEnvelope", "()Lorg/locationtech/jts/geom/Envelope;", "edges", "", "getEdges", "()Ljava/util/Collection;", "setLocator", "makeEdge", "o", "d", "connect", "a", "b", "delete", "e", "locateFromEdge", "v", "startEdge", "locate", "p", "Lorg/locationtech/jts/geom/Coordinate;", "p0", "p1", "insertSite", "isFrameEdge", "", "isFrameBorderEdge", "isFrameVertex", "seg", "Lorg/locationtech/jts/geom/LineSegment;", "isOnEdge", "isVertexOfEdge", "getVertices", "includeFrame", "getVertexUniqueEdges", "getPrimaryEdges", "visitTriangles", "triVisitor", "Lorg/locationtech/jts/triangulate/quadedge/TriangleVisitor;", "triEdges", "[Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "fetchTriangleToVisit", "edge", "edgeStack", "Lorg/locationtech/jts/legacy/Stack;", "visitedEdges", "", "(Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;Ljava/util/List;ZLjava/util/Set;)[Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "getTriangleEdges", "getTriangleVertices", "getTriangleCoordinates", "Lorg/locationtech/jts/geom/Geometry;", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "getTriangles", "getVoronoiDiagram", "getVoronoiCellPolygons", "Lorg/locationtech/jts/geom/Polygon;", "getVoronoiCellPolygon", "qe", "TriangleCircumcentreVisitor", "TriangleEdgesListVisitor", "TriangleVertexListVisitor", "TriangleCoordinatesVisitor", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nQuadEdgeSubdivision.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuadEdgeSubdivision.kt\norg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision\n+ 2 Stack.kt\norg/locationtech/jts/legacy/StackKt\n*L\n1#1,869:1\n21#2:870\n21#2:871\n21#2:872\n21#2:873\n21#2:874\n*S KotlinDebug\n*F\n+ 1 QuadEdgeSubdivision.kt\norg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision\n*L\n499#1:870\n506#1:871\n507#1:872\n551#1:873\n613#1:874\n*E\n"})
public final class QuadEdgeSubdivision {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double tolerance;
    private int visitedKey;
    @NotNull
    private final List<QuadEdge> quadEdges;
    @NotNull
    private final QuadEdge startingEdge;
    private final double edgeCoincidenceTolerance;
    @NotNull
    private final Vertex[] frameVertex;
    @Nullable
    private Envelope frameEnv;
    @Nullable
    private QuadEdgeLocator locator;
    @NotNull
    private final LineSegment seg;
    @NotNull
    private final QuadEdge[] triEdges;
    private static final double EDGE_COINCIDENCE_TOL_FACTOR = 1000.0;

    public QuadEdgeSubdivision(@NotNull Envelope env, double tolerance) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.tolerance = tolerance;
        this.quadEdges = new ArrayList();
        this.edgeCoincidenceTolerance = this.tolerance / 1000.0;
        this.frameVertex = new Vertex[3];
        this.seg = new LineSegment(null, null, 3, null);
        this.triEdges = new QuadEdge[3];
        this.createFrame(env);
        this.startingEdge = this.initSubdiv();
        this.locator = new LastFoundQuadEdgeLocator(this);
    }

    public final double getTolerance() {
        return this.tolerance;
    }

    private final void createFrame(Envelope env) {
        double deltaX = env.getWidth();
        double deltaY = env.getHeight();
        double offset = 0.0;
        offset = deltaX > deltaY ? deltaX * 10.0 : deltaY * 10.0;
        this.frameVertex[0] = new Vertex((env.getMaxX() + env.getMinX()) / 2.0, env.getMaxY() + offset);
        this.frameVertex[1] = new Vertex(env.getMinX() - offset, env.getMinY() - offset);
        this.frameVertex[2] = new Vertex(env.getMaxX() + offset, env.getMinY() - offset);
        Vertex vertex = this.frameVertex[0];
        Intrinsics.checkNotNull((Object)vertex);
        Coordinate coordinate = vertex.getCoordinate();
        Vertex vertex2 = this.frameVertex[1];
        Intrinsics.checkNotNull((Object)vertex2);
        Envelope envelope = this.frameEnv = new Envelope(coordinate, vertex2.getCoordinate());
        Intrinsics.checkNotNull((Object)envelope);
        Vertex vertex3 = this.frameVertex[2];
        Intrinsics.checkNotNull((Object)vertex3);
        envelope.expandToInclude(vertex3.getCoordinate());
    }

    private final QuadEdge initSubdiv() {
        QuadEdge ea = this.makeEdge(this.frameVertex[0], this.frameVertex[1]);
        QuadEdge eb = this.makeEdge(this.frameVertex[1], this.frameVertex[2]);
        QuadEdge.Companion.splice(ea.sym(), eb);
        QuadEdge ec = this.makeEdge(this.frameVertex[2], this.frameVertex[0]);
        QuadEdge.Companion.splice(eb.sym(), ec);
        QuadEdge.Companion.splice(ec.sym(), ea);
        return ea;
    }

    @NotNull
    public final Envelope getEnvelope() {
        Envelope envelope = this.frameEnv;
        Intrinsics.checkNotNull((Object)envelope);
        return new Envelope(envelope);
    }

    @NotNull
    public final Collection<?> getEdges() {
        return this.quadEdges;
    }

    public final void setLocator(@Nullable QuadEdgeLocator locator) {
        this.locator = locator;
    }

    @NotNull
    public final QuadEdge makeEdge(@Nullable Vertex o, @Nullable Vertex d) {
        QuadEdge q = QuadEdge.Companion.makeEdge(o, d);
        this.quadEdges.add(q);
        return q;
    }

    @NotNull
    public final QuadEdge connect(@NotNull QuadEdge a, @NotNull QuadEdge b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        QuadEdge q = QuadEdge.Companion.connect(a, b);
        this.quadEdges.add(q);
        return q;
    }

    public final void delete(@NotNull QuadEdge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        QuadEdge.Companion.splice(e, e.oPrev());
        QuadEdge quadEdge = e.sym();
        QuadEdge quadEdge2 = e.sym();
        Intrinsics.checkNotNull((Object)quadEdge2);
        QuadEdge.Companion.splice(quadEdge, quadEdge2.oPrev());
        QuadEdge quadEdge3 = e.sym();
        Intrinsics.checkNotNull((Object)quadEdge3);
        QuadEdge eSym = quadEdge3;
        QuadEdge quadEdge4 = e.rot();
        Intrinsics.checkNotNull((Object)quadEdge4);
        QuadEdge eRot = quadEdge4;
        QuadEdge quadEdge5 = e.rot();
        Intrinsics.checkNotNull((Object)quadEdge5);
        QuadEdge quadEdge6 = quadEdge5.sym();
        Intrinsics.checkNotNull((Object)quadEdge6);
        QuadEdge eRotSym = quadEdge6;
        this.quadEdges.remove(e);
        this.quadEdges.remove(eSym);
        this.quadEdges.remove(eRot);
        this.quadEdges.remove(eRotSym);
        e.delete();
        eSym.delete();
        eRot.delete();
        eRotSym.delete();
    }

    @NotNull
    public final QuadEdge locateFromEdge(@NotNull Vertex v, @NotNull QuadEdge startEdge) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)startEdge, (String)"startEdge");
        int iter = 0;
        int maxIter = this.quadEdges.size();
        QuadEdge e = startEdge;
        while (true) {
            QuadEdge quadEdge;
            if (++iter > maxIter) {
                throw new LocateFailureException(e.toLineSegment());
            }
            if (v.equals(e.orig()) || v.equals(e.dest())) break;
            if (v.rightOf(e)) {
                QuadEdge quadEdge2 = e.sym();
                quadEdge = quadEdge2;
                Intrinsics.checkNotNull((Object)quadEdge2);
            } else {
                QuadEdge quadEdge3 = e.oNext();
                Intrinsics.checkNotNull((Object)quadEdge3);
                if (!v.rightOf(quadEdge3)) {
                    QuadEdge quadEdge4 = e.oNext();
                    quadEdge = quadEdge4;
                    Intrinsics.checkNotNull((Object)quadEdge4);
                } else {
                    QuadEdge quadEdge5 = e.dPrev();
                    Intrinsics.checkNotNull((Object)quadEdge5);
                    if (v.rightOf(quadEdge5)) break;
                    QuadEdge quadEdge6 = e.dPrev();
                    quadEdge = quadEdge6;
                    Intrinsics.checkNotNull((Object)quadEdge6);
                }
            }
            e = quadEdge;
        }
        return e;
    }

    @NotNull
    public final QuadEdge locate(@Nullable Vertex v) {
        QuadEdgeLocator quadEdgeLocator = this.locator;
        Intrinsics.checkNotNull((Object)quadEdgeLocator);
        QuadEdge quadEdge = quadEdgeLocator.locate(v);
        Intrinsics.checkNotNull((Object)quadEdge);
        return quadEdge;
    }

    @NotNull
    public final QuadEdge locate(@Nullable Coordinate p) {
        QuadEdgeLocator quadEdgeLocator = this.locator;
        Intrinsics.checkNotNull((Object)quadEdgeLocator);
        QuadEdge quadEdge = quadEdgeLocator.locate(new Vertex(p));
        Intrinsics.checkNotNull((Object)quadEdge);
        return quadEdge;
    }

    @Nullable
    public final QuadEdge locate(@Nullable Coordinate p0, @Nullable Coordinate p1) {
        QuadEdge e;
        QuadEdgeLocator quadEdgeLocator = this.locator;
        Intrinsics.checkNotNull((Object)quadEdgeLocator);
        QuadEdge quadEdge = quadEdgeLocator.locate(new Vertex(p0));
        if (quadEdge == null) {
            return null;
        }
        QuadEdge base = e = quadEdge;
        Vertex vertex = e.dest();
        Intrinsics.checkNotNull((Object)vertex);
        Coordinate coordinate = vertex.getCoordinate();
        Coordinate coordinate2 = p0;
        Intrinsics.checkNotNull((Object)coordinate2);
        if (coordinate.equals2D(coordinate2)) {
            QuadEdge quadEdge2 = e.sym();
            Intrinsics.checkNotNull((Object)quadEdge2);
            base = quadEdge2;
        }
        QuadEdge locEdge = base;
        do {
            Vertex vertex2 = locEdge.dest();
            Intrinsics.checkNotNull((Object)vertex2);
            Coordinate coordinate3 = vertex2.getCoordinate();
            Coordinate coordinate4 = p1;
            Intrinsics.checkNotNull((Object)coordinate4);
            if (coordinate3.equals2D(coordinate4)) {
                return locEdge;
            }
            Intrinsics.checkNotNull((Object)locEdge.oNext());
        } while (locEdge != base);
        return null;
    }

    @NotNull
    public final QuadEdge insertSite(@NotNull Vertex v) {
        QuadEdge e;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                e = this.locate(v);
                Vertex vertex = e.orig();
                Intrinsics.checkNotNull((Object)vertex);
                if (v.equals(vertex, this.tolerance)) break block3;
                Vertex vertex2 = e.dest();
                Intrinsics.checkNotNull((Object)vertex2);
                if (!v.equals(vertex2, this.tolerance)) break block4;
            }
            return e;
        }
        QuadEdge base = this.makeEdge(e.orig(), v);
        QuadEdge.Companion.splice(base, e);
        QuadEdge startEdge = base;
        do {
            QuadEdge quadEdge = base.sym();
            Intrinsics.checkNotNull((Object)quadEdge);
            base = this.connect(e, quadEdge);
            Intrinsics.checkNotNull((Object)base.oPrev());
        } while (e.lNext() != startEdge);
        return startEdge;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFrameEdge(@NotNull QuadEdge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Vertex vertex = e.orig();
        Intrinsics.checkNotNull((Object)vertex);
        if (this.isFrameVertex(vertex)) return true;
        Vertex vertex2 = e.dest();
        Intrinsics.checkNotNull((Object)vertex2);
        if (!this.isFrameVertex(vertex2)) return false;
        return true;
    }

    public final boolean isFrameBorderEdge(@NotNull QuadEdge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        QuadEdge[] leftTri = new QuadEdge[3];
        Companion.getTriangleEdges(e, leftTri);
        QuadEdge[] rightTri = new QuadEdge[3];
        Companion.getTriangleEdges(e.sym(), rightTri);
        QuadEdge quadEdge = e.lNext();
        Intrinsics.checkNotNull((Object)quadEdge);
        Vertex vertex = quadEdge.dest();
        Intrinsics.checkNotNull((Object)vertex);
        Vertex vLeftTriOther = vertex;
        if (this.isFrameVertex(vLeftTriOther)) {
            return true;
        }
        QuadEdge quadEdge2 = e.sym();
        Intrinsics.checkNotNull((Object)quadEdge2);
        QuadEdge quadEdge3 = quadEdge2.lNext();
        Intrinsics.checkNotNull((Object)quadEdge3);
        Vertex vertex2 = quadEdge3.dest();
        Intrinsics.checkNotNull((Object)vertex2);
        Vertex vRightTriOther = vertex2;
        return this.isFrameVertex(vRightTriOther);
    }

    public final boolean isFrameVertex(@NotNull Vertex v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (v.equals(this.frameVertex[0])) {
            return true;
        }
        if (v.equals(this.frameVertex[1])) {
            return true;
        }
        return v.equals(this.frameVertex[2]);
    }

    public final boolean isOnEdge(@NotNull QuadEdge e, @Nullable Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Vertex vertex = e.orig();
        Intrinsics.checkNotNull((Object)vertex);
        Coordinate coordinate = vertex.getCoordinate();
        Vertex vertex2 = e.dest();
        Intrinsics.checkNotNull((Object)vertex2);
        this.seg.setCoordinates(coordinate, vertex2.getCoordinate());
        double dist = this.seg.distance(p);
        return dist < this.edgeCoincidenceTolerance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isVertexOfEdge(@NotNull QuadEdge e, @NotNull Vertex v) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Vertex vertex = e.orig();
        Intrinsics.checkNotNull((Object)vertex);
        if (v.equals(vertex, this.tolerance)) return true;
        Vertex vertex2 = e.dest();
        Intrinsics.checkNotNull((Object)vertex2);
        if (!v.equals(vertex2, this.tolerance)) return false;
        return true;
    }

    @NotNull
    public final Collection<?> getVertices(boolean includeFrame) {
        Set vertices = new HashSet();
        for (QuadEdge qe : this.quadEdges) {
            Vertex vd;
            Vertex v;
            Intrinsics.checkNotNull((Object)qe.orig());
            if (includeFrame || !this.isFrameVertex(v)) {
                vertices.add(v);
            }
            Intrinsics.checkNotNull((Object)qe.dest());
            if (!includeFrame && this.isFrameVertex(vd)) continue;
            vertices.add(vd);
        }
        return vertices;
    }

    @NotNull
    public final List<QuadEdge> getVertexUniqueEdges(boolean includeFrame) {
        List edges = new ArrayList();
        Set visitedVertices = new HashSet();
        Iterator<QuadEdge> i = this.quadEdges.iterator();
        while (i.hasNext()) {
            Vertex vd;
            QuadEdge qd;
            Vertex v;
            QuadEdge qe;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.triangulate.quadedge.QuadEdge");
            Intrinsics.checkNotNull((Object)qe.orig());
            if (!visitedVertices.contains(v)) {
                visitedVertices.add(v);
                if (includeFrame || !this.isFrameVertex(v)) {
                    edges.add(qe);
                }
            }
            Intrinsics.checkNotNull((Object)qe.sym());
            Intrinsics.checkNotNull((Object)qd.orig());
            if (visitedVertices.contains(vd)) continue;
            visitedVertices.add(vd);
            if (!includeFrame && this.isFrameVertex(vd)) continue;
            edges.add(qd);
        }
        return edges;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<QuadEdge> getPrimaryEdges(boolean includeFrame) {
        void $this$push$iv;
        List edgeStack;
        int n = this.visitedKey;
        this.visitedKey = n + 1;
        List edges = new ArrayList();
        List list = edgeStack = (List)new ArrayList();
        QuadEdge item$iv = this.startingEdge;
        boolean $i$f$push = false;
        $this$push$iv.add(item$iv);
        Set visitedEdges = new HashSet();
        while (!StackKt.empty(edgeStack)) {
            List $this$push$iv2;
            QuadEdge priQE;
            Object t = StackKt.pop(edgeStack);
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.locationtech.jts.triangulate.quadedge.QuadEdge");
            QuadEdge edge = (QuadEdge)t;
            if (visitedEdges.contains(edge)) continue;
            Intrinsics.checkNotNull((Object)edge.getPrimary());
            if (includeFrame || !this.isFrameEdge(priQE)) {
                edges.add(priQE);
            }
            List list2 = edgeStack;
            QuadEdge quadEdge = edge.oNext();
            Intrinsics.checkNotNull((Object)quadEdge);
            QuadEdge item$iv2 = quadEdge;
            boolean $i$f$push2 = false;
            $this$push$iv2.add(item$iv2);
            $this$push$iv2 = edgeStack;
            QuadEdge quadEdge2 = edge.sym();
            Intrinsics.checkNotNull((Object)quadEdge2);
            QuadEdge quadEdge3 = quadEdge2.oNext();
            Intrinsics.checkNotNull((Object)quadEdge3);
            item$iv2 = quadEdge3;
            $i$f$push2 = false;
            $this$push$iv2.add(item$iv2);
            visitedEdges.add(edge);
            QuadEdge quadEdge4 = edge.sym();
            Intrinsics.checkNotNull((Object)quadEdge4);
            visitedEdges.add(quadEdge4);
        }
        return edges;
    }

    /*
     * WARNING - void declaration
     */
    public final void visitTriangles(@NotNull TriangleVisitor triVisitor, boolean includeFrame) {
        void $this$push$iv;
        List edgeStack;
        Intrinsics.checkNotNullParameter((Object)triVisitor, (String)"triVisitor");
        int n = this.visitedKey;
        this.visitedKey = n + 1;
        List list = edgeStack = (List)new ArrayList();
        QuadEdge item$iv = this.startingEdge;
        boolean $i$f$push = false;
        $this$push$iv.add(item$iv);
        Set visitedEdges = new HashSet();
        while (!StackKt.empty(edgeStack)) {
            QuadEdge[] triEdges;
            Object t = StackKt.pop(edgeStack);
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.locationtech.jts.triangulate.quadedge.QuadEdge");
            QuadEdge edge = (QuadEdge)t;
            if (visitedEdges.contains(edge) || (triEdges = this.fetchTriangleToVisit(edge, edgeStack, includeFrame, visitedEdges)) == null) continue;
            triVisitor.visit(triEdges);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final QuadEdge[] fetchTriangleToVisit(QuadEdge edge, List<QuadEdge> edgeStack, boolean includeFrame, Set<QuadEdge> visitedEdges) {
        QuadEdge curr = edge;
        int edgeCount = 0;
        boolean isFrame = false;
        do {
            QuadEdge sym;
            this.triEdges[edgeCount] = curr;
            if (this.isFrameEdge(curr)) {
                isFrame = true;
            }
            Intrinsics.checkNotNull((Object)curr.sym());
            if (!visitedEdges.contains(sym)) {
                void $this$push$iv;
                List<QuadEdge> list = edgeStack;
                QuadEdge item$iv = sym;
                boolean $i$f$push = false;
                $this$push$iv.add(item$iv);
            }
            visitedEdges.add(curr);
            ++edgeCount;
            Intrinsics.checkNotNull((Object)curr.lNext());
        } while (curr != edge);
        return isFrame && !includeFrame ? null : (QuadEdge[])ArraysKt.requireNoNulls((Object[])this.triEdges);
    }

    @NotNull
    public final List<QuadEdge[]> getTriangleEdges(boolean includeFrame) {
        TriangleEdgesListVisitor visitor = new TriangleEdgesListVisitor();
        this.visitTriangles(visitor, includeFrame);
        return visitor.getTriangleEdges();
    }

    @NotNull
    public final List<Vertex[]> getTriangleVertices(boolean includeFrame) {
        TriangleVertexListVisitor visitor = new TriangleVertexListVisitor();
        this.visitTriangles(visitor, includeFrame);
        return visitor.getTriangleVertices();
    }

    @NotNull
    public final List<Coordinate[]> getTriangleCoordinates(boolean includeFrame) {
        TriangleCoordinatesVisitor visitor = new TriangleCoordinatesVisitor();
        this.visitTriangles(visitor, includeFrame);
        return visitor.getTriangles();
    }

    @NotNull
    public final Geometry getEdges(@NotNull GeometryFactory geomFact) {
        Intrinsics.checkNotNullParameter((Object)geomFact, (String)"geomFact");
        List<QuadEdge> quadEdges = this.getPrimaryEdges(false);
        Object[] edges = new LineString[quadEdges.size()];
        int i = 0;
        Iterator<QuadEdge> it = quadEdges.iterator();
        while (it.hasNext()) {
            QuadEdge qe;
            Intrinsics.checkNotNull((Object)it.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.triangulate.quadedge.QuadEdge");
            int n = i++;
            Coordinate[] coordinateArray = new Coordinate[2];
            Vertex vertex = qe.orig();
            Intrinsics.checkNotNull((Object)vertex);
            coordinateArray[0] = vertex.getCoordinate();
            Vertex vertex2 = qe.dest();
            Intrinsics.checkNotNull((Object)vertex2);
            coordinateArray[1] = vertex2.getCoordinate();
            edges[n] = geomFact.createLineString(coordinateArray);
        }
        return geomFact.createMultiLineString((LineString[])ArraysKt.requireNoNulls((Object[])edges));
    }

    @NotNull
    public final Geometry getTriangles(@NotNull GeometryFactory geomFact) {
        Intrinsics.checkNotNullParameter((Object)geomFact, (String)"geomFact");
        List<Coordinate[]> triPtsList = this.getTriangleCoordinates(false);
        Object[] tris = new Polygon[triPtsList.size()];
        int i = 0;
        Iterator<Coordinate[]> it = triPtsList.iterator();
        while (it.hasNext()) {
            Coordinate[] triPt;
            Intrinsics.checkNotNull((Object)it.next(), (String)"null cannot be cast to non-null type kotlin.Array<org.locationtech.jts.geom.Coordinate>");
            tris[i++] = GeometryFactory.createPolygon$default(geomFact, geomFact.createLinearRing(triPt), null, 2, null);
        }
        return geomFact.createGeometryCollection((Geometry[])ArraysKt.requireNoNulls((Object[])tris));
    }

    @NotNull
    public final Geometry getVoronoiDiagram(@NotNull GeometryFactory geomFact) {
        Intrinsics.checkNotNullParameter((Object)geomFact, (String)"geomFact");
        List<Polygon> vorCells = this.getVoronoiCellPolygons(geomFact);
        return geomFact.createGeometryCollection(GeometryFactory.Companion.toGeometryArray((Collection<? extends Geometry>)vorCells));
    }

    @NotNull
    public final List<Polygon> getVoronoiCellPolygons(@NotNull GeometryFactory geomFact) {
        Intrinsics.checkNotNullParameter((Object)geomFact, (String)"geomFact");
        this.visitTriangles(new TriangleCircumcentreVisitor(), true);
        List cells = new ArrayList();
        Collection edges = this.getVertexUniqueEdges(false);
        for (Object e : edges) {
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.locationtech.jts.triangulate.quadedge.QuadEdge");
            QuadEdge qe = (QuadEdge)e;
            cells.add(this.getVoronoiCellPolygon(qe, geomFact));
        }
        return cells;
    }

    @NotNull
    public final Polygon getVoronoiCellPolygon(@NotNull QuadEdge qe, @NotNull GeometryFactory geomFact) {
        Intrinsics.checkNotNullParameter((Object)qe, (String)"qe");
        Intrinsics.checkNotNullParameter((Object)geomFact, (String)"geomFact");
        QuadEdge qe2 = qe;
        List cellPts = new ArrayList();
        QuadEdge startQE = qe2;
        do {
            QuadEdge quadEdge = qe2.rot();
            Intrinsics.checkNotNull((Object)quadEdge);
            Vertex vertex = quadEdge.orig();
            Intrinsics.checkNotNull((Object)vertex);
            Coordinate cc = vertex.getCoordinate();
            cellPts.add(cc);
            Intrinsics.checkNotNull((Object)qe2.oPrev());
        } while (qe2 != startQE);
        CoordinateList coordList = new CoordinateList();
        coordList.addAll(cellPts, false);
        coordList.closeRing();
        if (coordList.size() < 4) {
            coordList.add(coordList.get(coordList.size() - 1), true);
        }
        Coordinate[] pts = coordList.toCoordinateArray();
        Polygon cellPoly = GeometryFactory.createPolygon$default(geomFact, geomFact.createLinearRing(pts), null, 2, null);
        Vertex vertex = startQE.orig();
        Intrinsics.checkNotNull((Object)vertex);
        Vertex v = vertex;
        cellPoly.setUserData(v.getCoordinate());
        return cellPoly;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\t\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision$Companion;", "", "<init>", "()V", "getTriangleEdges", "", "startQE", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "triEdge", "", "(Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;[Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;)V", "EDGE_COINCIDENCE_TOL_FACTOR", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void getTriangleEdges(@Nullable QuadEdge startQE, @NotNull QuadEdge[] triEdge) {
            Intrinsics.checkNotNullParameter((Object)triEdge, (String)"triEdge");
            triEdge[0] = startQE;
            QuadEdge quadEdge = triEdge[0];
            Intrinsics.checkNotNull((Object)quadEdge);
            triEdge[1] = quadEdge.lNext();
            QuadEdge quadEdge2 = triEdge[1];
            Intrinsics.checkNotNull((Object)quadEdge2);
            triEdge[2] = quadEdge2.lNext();
            QuadEdge quadEdge3 = triEdge[2];
            Intrinsics.checkNotNull((Object)quadEdge3);
            if (quadEdge3.lNext() != triEdge[0]) {
                throw new IllegalArgumentException("Edges do not form a triangle");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision$TriangleCircumcentreVisitor;", "Lorg/locationtech/jts/triangulate/quadedge/TriangleVisitor;", "<init>", "()V", "visit", "", "triEdges", "", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "([Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;)V", "kts-core"})
    private static final class TriangleCircumcentreVisitor
    implements TriangleVisitor {
        @Override
        public void visit(@NotNull QuadEdge[] triEdges) {
            Intrinsics.checkNotNullParameter((Object)triEdges, (String)"triEdges");
            Vertex vertex = triEdges[0].orig();
            Intrinsics.checkNotNull((Object)vertex);
            Coordinate a = vertex.getCoordinate();
            Vertex vertex2 = triEdges[1].orig();
            Intrinsics.checkNotNull((Object)vertex2);
            Coordinate b = vertex2.getCoordinate();
            Vertex vertex3 = triEdges[2].orig();
            Intrinsics.checkNotNull((Object)vertex3);
            Coordinate c = vertex3.getCoordinate();
            Coordinate cc = Triangle.Companion.circumcentreDD(a, b, c);
            Vertex ccVertex = new Vertex(cc);
            for (int i = 0; i < 3; ++i) {
                QuadEdge quadEdge = triEdges[i].rot();
                Intrinsics.checkNotNull((Object)quadEdge);
                quadEdge.setOrig(ccVertex);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision$TriangleCoordinatesVisitor;", "Lorg/locationtech/jts/triangulate/quadedge/TriangleVisitor;", "<init>", "()V", "coordList", "Lorg/locationtech/jts/geom/CoordinateList;", "triCoords", "", "", "Lorg/locationtech/jts/geom/Coordinate;", "visit", "", "triEdges", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "([Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;)V", "checkTriangleSize", "pts", "([Lorg/locationtech/jts/geom/Coordinate;)V", "triangles", "getTriangles", "()Ljava/util/List;", "kts-core"})
    private static final class TriangleCoordinatesVisitor
    implements TriangleVisitor {
        @NotNull
        private final CoordinateList coordList = new CoordinateList();
        @NotNull
        private final List<Coordinate[]> triCoords = new ArrayList();

        @Override
        public void visit(@NotNull QuadEdge[] triEdges) {
            Intrinsics.checkNotNullParameter((Object)triEdges, (String)"triEdges");
            this.coordList.clear();
            for (int i = 0; i < 3; ++i) {
                Vertex v;
                Intrinsics.checkNotNull((Object)triEdges[i].orig());
                this.coordList.add(v.getCoordinate());
            }
            if (this.coordList.size() > 0) {
                this.coordList.closeRing();
                Coordinate[] pts = this.coordList.toCoordinateArray();
                if (pts.length != 4) {
                    return;
                }
                this.triCoords.add(pts);
            }
        }

        private final void checkTriangleSize(Coordinate[] pts) {
            String loc = "";
            if (pts.length >= 2) {
                loc = WKTWriter.Companion.toLineString(pts[0], pts[1]);
            } else if (!(pts.length == 0)) {
                loc = WKTWriter.Companion.toPoint(pts[0]);
            }
        }

        @NotNull
        public final List<Coordinate[]> getTriangles() {
            return this.triCoords;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0002\u0010\u000bR\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision$TriangleEdgesListVisitor;", "Lorg/locationtech/jts/triangulate/quadedge/TriangleVisitor;", "<init>", "()V", "triList", "", "", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "visit", "", "triEdges", "([Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;)V", "triangleEdges", "getTriangleEdges", "()Ljava/util/List;", "kts-core"})
    private static final class TriangleEdgesListVisitor
    implements TriangleVisitor {
        @NotNull
        private final List<QuadEdge[]> triList = new ArrayList();

        @Override
        public void visit(@NotNull QuadEdge[] triEdges) {
            Intrinsics.checkNotNullParameter((Object)triEdges, (String)"triEdges");
            this.triList.add(triEdges);
        }

        @NotNull
        public final List<QuadEdge[]> getTriangleEdges() {
            return this.triList;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0016\u00a2\u0006\u0002\u0010\fR\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision$TriangleVertexListVisitor;", "Lorg/locationtech/jts/triangulate/quadedge/TriangleVisitor;", "<init>", "()V", "triList", "", "", "Lorg/locationtech/jts/triangulate/quadedge/Vertex;", "visit", "", "triEdges", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "([Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;)V", "triangleVertices", "getTriangleVertices", "()Ljava/util/List;", "kts-core"})
    private static final class TriangleVertexListVisitor
    implements TriangleVisitor {
        @NotNull
        private final List<Vertex[]> triList = new ArrayList();

        @Override
        public void visit(@NotNull QuadEdge[] triEdges) {
            Intrinsics.checkNotNullParameter((Object)triEdges, (String)"triEdges");
            Vertex[] vertexArray = new Vertex[3];
            Intrinsics.checkNotNull((Object)triEdges[0].orig());
            Intrinsics.checkNotNull((Object)triEdges[1].orig());
            Intrinsics.checkNotNull((Object)triEdges[2].orig());
            this.triList.add(vertexArray);
        }

        @NotNull
        public final List<Vertex[]> getTriangleVertices() {
            return this.triList;
        }
    }
}

