/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.tri;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 T2\u00020\u0001:\u0001TB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u0000J\u001a\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u0000J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0000J\u001e\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003J\u000e\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020!J@\u0010%\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00002\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003J\u0018\u0010-\u001a\u00020\u001c2\b\u0010.\u001a\u0004\u0018\u00010\u00002\u0006\u0010/\u001a\u00020\u0000J\u001c\u00100\u001a\u00020!2\u0006\u0010&\u001a\u00020!2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000002J\u0014\u00103\u001a\u00020\u001c2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000004J\u0006\u00103\u001a\u00020\u001cJ\u000e\u00103\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020!J-\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0000062\b\u00107\u001a\u0004\u0018\u00010\u00002\u0006\u0010&\u001a\u00020!2\u0006\u00108\u001a\u00020!\u00a2\u0006\u0002\u00109J\u0006\u0010:\u001a\u00020\u001cJ\u000e\u0010;\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020!J\u000e\u0010<\u001a\u00020\u00032\u0006\u0010&\u001a\u00020!J\u0010\u0010=\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010\u0003J\u000e\u0010=\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u0000J\u0010\u0010>\u001a\u0004\u0018\u00010\u00002\u0006\u0010&\u001a\u00020!J\u0006\u0010?\u001a\u00020@J\u000e\u0010?\u001a\u00020@2\u0006\u0010&\u001a\u00020!J\u000e\u0010A\u001a\u00020@2\u0006\u0010\u001e\u001a\u00020\u0000J\u0006\u0010B\u001a\u00020!J\u000e\u0010C\u001a\u00020@2\u0006\u0010&\u001a\u00020!J\u000e\u0010F\u001a\u00020@2\u0006\u0010&\u001a\u00020!J\u000e\u0010G\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!J\u000e\u0010M\u001a\u00020I2\u0006\u0010 \u001a\u00020!J\u000e\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QJ\b\u0010R\u001a\u00020SH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u0011\u0010D\u001a\u00020@8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0011\u0010H\u001a\u00020I8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR\u0011\u0010L\u001a\u00020I8F\u00a2\u0006\u0006\u001a\u0004\bM\u0010K\u00a8\u0006U"}, d2={"Lorg/locationtech/jts/triangulate/tri/Tri;", "", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "p2", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)V", "getP0", "()Lorg/locationtech/jts/geom/Coordinate;", "setP0", "(Lorg/locationtech/jts/geom/Coordinate;)V", "getP1", "setP1", "getP2", "setP2", "tri0", "getTri0", "()Lorg/locationtech/jts/triangulate/tri/Tri;", "setTri0", "(Lorg/locationtech/jts/triangulate/tri/Tri;)V", "tri1", "getTri1", "setTri1", "tri2", "getTri2", "setTri2", "setAdjacent", "", "pt", "tri", "setTri", "edgeIndex", "", "setCoordinates", "split", "p", "flip", "index", "index0", "index1", "adj0", "adj1", "opp0", "opp1", "replace", "triOld", "triNew", "degree", "triList", "", "remove", "", "getAdjacentTris", "", "triAdj", "indexAdj", "(Lorg/locationtech/jts/triangulate/tri/Tri;II)[Lorg/locationtech/jts/triangulate/tri/Tri;", "validate", "validateAdjacent", "getCoordinate", "getIndex", "getAdjacent", "hasAdjacent", "", "isAdjacent", "numAdjacent", "isInteriorVertex", "isBorder", "()Z", "isBoundary", "midpoint", "area", "", "getArea", "()D", "length", "getLength", "toPolygon", "Lorg/locationtech/jts/geom/Polygon;", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "toString", "", "Companion", "kts-core"})
public class Tri {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Coordinate p0;
    @NotNull
    private Coordinate p1;
    @NotNull
    private Coordinate p2;
    @Nullable
    private Tri tri0;
    @Nullable
    private Tri tri1;
    @Nullable
    private Tri tri2;

    public Tri(@NotNull Coordinate p0, @NotNull Coordinate p1, @NotNull Coordinate p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
    }

    @NotNull
    public final Coordinate getP0() {
        return this.p0;
    }

    public final void setP0(@NotNull Coordinate coordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"<set-?>");
        this.p0 = coordinate;
    }

    @NotNull
    protected final Coordinate getP1() {
        return this.p1;
    }

    protected final void setP1(@NotNull Coordinate coordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"<set-?>");
        this.p1 = coordinate;
    }

    @NotNull
    protected final Coordinate getP2() {
        return this.p2;
    }

    protected final void setP2(@NotNull Coordinate coordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"<set-?>");
        this.p2 = coordinate;
    }

    @Nullable
    public final Tri getTri0() {
        return this.tri0;
    }

    public final void setTri0(@Nullable Tri tri) {
        this.tri0 = tri;
    }

    @Nullable
    public final Tri getTri1() {
        return this.tri1;
    }

    public final void setTri1(@Nullable Tri tri) {
        this.tri1 = tri;
    }

    @Nullable
    public final Tri getTri2() {
        return this.tri2;
    }

    public final void setTri2(@Nullable Tri tri) {
        this.tri2 = tri;
    }

    public final void setAdjacent(@Nullable Tri tri0, @Nullable Tri tri1, @Nullable Tri tri2) {
        this.tri0 = tri0;
        this.tri1 = tri1;
        this.tri2 = tri2;
    }

    public final void setAdjacent(@Nullable Coordinate pt, @Nullable Tri tri) {
        int index = this.getIndex(pt);
        this.setTri(index, tri);
    }

    public final void setTri(int edgeIndex, @Nullable Tri tri) {
        switch (edgeIndex) {
            case 0: {
                this.tri0 = tri;
                return;
            }
            case 1: {
                this.tri1 = tri;
                return;
            }
            case 2: {
                this.tri2 = tri;
                return;
            }
        }
        Assert.shouldNeverReachHere$default(null, 1, null);
    }

    public final void setCoordinates(@NotNull Coordinate p0, @NotNull Coordinate p1, @NotNull Coordinate p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
    }

    @NotNull
    public final Tri split(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Tri tt0 = new Tri(p, this.p0, this.p1);
        Tri tt1 = new Tri(p, this.p1, this.p2);
        Tri tt2 = new Tri(p, this.p2, this.p0);
        tt0.setAdjacent(tt2, this.tri0, tt1);
        tt1.setAdjacent(tt0, this.tri1, tt2);
        tt2.setAdjacent(tt1, this.tri2, tt0);
        return tt0;
    }

    public final void flip(int index) {
        Tri tri = this.getAdjacent(index);
        Intrinsics.checkNotNull((Object)tri);
        Tri tri2 = tri;
        int index1 = tri2.getIndex(this);
        Coordinate adj0 = this.getCoordinate(index);
        Coordinate adj1 = this.getCoordinate(Companion.next(index));
        Coordinate opp0 = this.getCoordinate(Companion.oppVertex(index));
        Coordinate opp1 = tri2.getCoordinate(Companion.oppVertex(index1));
        this.flip(tri2, index, index1, adj0, adj1, opp0, opp1);
    }

    public final void flip(@Nullable Tri tri, int index0, int index1, @NotNull Coordinate adj0, @NotNull Coordinate adj1, @NotNull Coordinate opp0, @NotNull Coordinate opp1) {
        Intrinsics.checkNotNullParameter((Object)adj0, (String)"adj0");
        Intrinsics.checkNotNullParameter((Object)adj1, (String)"adj1");
        Intrinsics.checkNotNullParameter((Object)opp0, (String)"opp0");
        Intrinsics.checkNotNullParameter((Object)opp1, (String)"opp1");
        this.setCoordinates(opp1, opp0, adj0);
        Tri tri2 = tri;
        Intrinsics.checkNotNull((Object)tri2);
        tri2.setCoordinates(opp0, opp1, adj1);
        Tri[] adjacent = this.getAdjacentTris(tri, index0, index1);
        this.setAdjacent(tri, adjacent[0], adjacent[2]);
        if (adjacent[2] != null) {
            Tri tri3 = adjacent[2];
            Intrinsics.checkNotNull((Object)tri3);
            tri3.replace(tri, this);
        }
        tri.setAdjacent(this, adjacent[3], adjacent[1]);
        if (adjacent[1] != null) {
            Tri tri4 = adjacent[1];
            Intrinsics.checkNotNull((Object)tri4);
            tri4.replace(this, tri);
        }
    }

    public final void replace(@Nullable Tri triOld, @NotNull Tri triNew) {
        Intrinsics.checkNotNullParameter((Object)triNew, (String)"triNew");
        if (this.tri0 != null && this.tri0 == triOld) {
            this.tri0 = triNew;
        } else if (this.tri1 != null && this.tri1 == triOld) {
            this.tri1 = triNew;
        } else if (this.tri2 != null && this.tri2 == triOld) {
            this.tri2 = triNew;
        }
    }

    public final int degree(int index, @NotNull List<? extends Tri> triList) {
        Intrinsics.checkNotNullParameter(triList, (String)"triList");
        Coordinate v = this.getCoordinate(index);
        int degree = 0;
        for (Tri tri : triList) {
            for (int i = 0; i < 3; ++i) {
                if (!v.equals2D(tri.getCoordinate(i))) continue;
                ++degree;
            }
        }
        return degree;
    }

    public final void remove(@NotNull List<Tri> triList) {
        Intrinsics.checkNotNullParameter(triList, (String)"triList");
        this.remove();
        triList.remove(this);
    }

    public final void remove() {
        this.remove(0);
        this.remove(1);
        this.remove(2);
    }

    public final void remove(int index) {
        Tri tri = this.getAdjacent(index);
        if (tri == null) {
            return;
        }
        Tri adj = tri;
        adj.setTri(adj.getIndex(this), null);
        this.setTri(index, null);
    }

    @NotNull
    public final Tri[] getAdjacentTris(@Nullable Tri triAdj, int index, int indexAdj) {
        Tri[] adj = new Tri[4];
        adj[0] = this.getAdjacent(Companion.prev(index));
        adj[1] = this.getAdjacent(Companion.next(index));
        Tri tri = triAdj;
        Intrinsics.checkNotNull((Object)tri);
        adj[2] = tri.getAdjacent(Companion.next(indexAdj));
        adj[3] = triAdj.getAdjacent(Companion.prev(indexAdj));
        return adj;
    }

    public final void validate() {
        if (-1 != Orientation.index(this.p0, this.p1, this.p2)) {
            throw new IllegalArgumentException("Tri is not oriented correctly");
        }
        this.validateAdjacent(0);
        this.validateAdjacent(1);
        this.validateAdjacent(2);
    }

    public final void validateAdjacent(int index) {
        Tri tri = this.getAdjacent(index);
        if (tri == null) {
            return;
        }
        Tri tri2 = tri;
        Coordinate e0 = this.getCoordinate(index);
        Coordinate e1 = this.getCoordinate(Companion.next(index));
        int indexNeighbor = tri2.getIndex(this);
        Coordinate n0 = tri2.getCoordinate(indexNeighbor);
        Coordinate n1 = tri2.getCoordinate(Companion.next(indexNeighbor));
        Assert.INSTANCE.isTrue(e0.equals2D(n1), "Edge coord not equal");
        Assert.INSTANCE.isTrue(e1.equals2D(n0), "Edge coord not equal");
        RobustLineIntersector li = new RobustLineIntersector();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Coordinate p00 = this.getCoordinate(i);
                Coordinate p01 = this.getCoordinate(Companion.next(i));
                Coordinate p10 = tri2.getCoordinate(j);
                Coordinate p11 = tri2.getCoordinate(Companion.next(j));
                li.computeIntersection(p00, p01, p10, p11);
            }
        }
    }

    @NotNull
    public final Coordinate getCoordinate(int index) {
        if (index == 0) {
            return this.p0;
        }
        return index == 1 ? this.p1 : this.p2;
    }

    public final int getIndex(@Nullable Coordinate p) {
        Coordinate coordinate = p;
        Intrinsics.checkNotNull((Object)coordinate);
        if (this.p0.equals2D(coordinate)) {
            return 0;
        }
        if (this.p1.equals2D(p)) {
            return 1;
        }
        return this.p2.equals2D(p) ? 2 : -1;
    }

    public final int getIndex(@NotNull Tri tri) {
        Intrinsics.checkNotNullParameter((Object)tri, (String)"tri");
        if (this.tri0 == tri) {
            return 0;
        }
        if (this.tri1 == tri) {
            return 1;
        }
        return this.tri2 == tri ? 2 : -1;
    }

    @Nullable
    public final Tri getAdjacent(int index) {
        switch (index) {
            case 0: {
                return this.tri0;
            }
            case 1: {
                return this.tri1;
            }
            case 2: {
                return this.tri2;
            }
        }
        Assert.shouldNeverReachHere$default(null, 1, null);
        return null;
    }

    public final boolean hasAdjacent() {
        return this.hasAdjacent(0) || this.hasAdjacent(1) || this.hasAdjacent(2);
    }

    public final boolean hasAdjacent(int index) {
        return this.getAdjacent(index) != null;
    }

    public final boolean isAdjacent(@NotNull Tri tri) {
        Intrinsics.checkNotNullParameter((Object)tri, (String)"tri");
        return this.getIndex(tri) >= 0;
    }

    public final int numAdjacent() {
        int num = 0;
        if (this.tri0 != null) {
            ++num;
        }
        if (this.tri1 != null) {
            ++num;
        }
        if (this.tri2 != null) {
            ++num;
        }
        return num;
    }

    public final boolean isInteriorVertex(int index) {
        Tri curr = this;
        int currIndex = index;
        do {
            Tri adj;
            if (curr.getAdjacent(currIndex) == null) {
                return false;
            }
            int adjIndex = adj.getIndex(curr);
            curr = adj;
            currIndex = Companion.next(adjIndex);
        } while (curr != this);
        return true;
    }

    public final boolean isBorder() {
        return this.isBoundary(0) || this.isBoundary(1) || this.isBoundary(2);
    }

    public final boolean isBoundary(int index) {
        return !this.hasAdjacent(index);
    }

    @NotNull
    public final Coordinate midpoint(int edgeIndex) {
        Coordinate p0 = this.getCoordinate(edgeIndex);
        Coordinate p1 = this.getCoordinate(Companion.next(edgeIndex));
        double midX = (p0.x + p1.x) / (double)2;
        double midY = (p0.y + p1.y) / (double)2;
        return new Coordinate(midX, midY);
    }

    public final double getArea() {
        return Triangle.Companion.area(this.p0, this.p1, this.p2);
    }

    public final double getLength() {
        return Triangle.Companion.length(this.p0, this.p1, this.p2);
    }

    public final double getLength(int edgeIndex) {
        return this.getCoordinate(edgeIndex).distance(this.getCoordinate(Companion.next(edgeIndex)));
    }

    @NotNull
    public final Polygon toPolygon(@NotNull GeometryFactory geomFact) {
        Intrinsics.checkNotNullParameter((Object)geomFact, (String)"geomFact");
        Coordinate[] coordinateArray = new Coordinate[]{this.p0.copy(), this.p1.copy(), this.p2.copy(), this.p0.copy()};
        return geomFact.createPolygon(geomFact.createLinearRing(coordinateArray), null);
    }

    @NotNull
    public String toString() {
        return "POLYGON ((" + WKTWriter.Companion.format(this.p0) + ", " + WKTWriter.Companion.format(this.p1) + ", " + WKTWriter.Companion.format(this.p2) + ", " + WKTWriter.Companion.format(this.p0) + "))";
    }

    @JvmStatic
    @NotNull
    public static final Tri create(@NotNull Coordinate p0, @NotNull Coordinate p1, @NotNull Coordinate p2) {
        return Companion.create(p0, p1, p2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eJ\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eJ \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0007J\u0019\u0010\u0011\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aJ\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001a\u00a8\u0006!"}, d2={"Lorg/locationtech/jts/triangulate/tri/Tri$Companion;", "", "<init>", "()V", "toGeometry", "Lorg/locationtech/jts/geom/Geometry;", "tris", "", "Lorg/locationtech/jts/triangulate/tri/Tri;", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "area", "", "triList", "", "validate", "", "create", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "p2", "pts", "", "([Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/triangulate/tri/Tri;", "next", "", "index", "prev", "oppVertex", "edgeIndex", "oppEdge", "vertexIndex", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public Geometry toGeometry(@NotNull Collection<? extends Tri> tris, @NotNull GeometryFactory geomFact) {
            Intrinsics.checkNotNullParameter(tris, (String)"tris");
            Intrinsics.checkNotNullParameter((Object)geomFact, (String)"geomFact");
            Object[] geoms = new Geometry[tris.size()];
            int i = 0;
            for (Tri tri : tris) {
                geoms[i++] = tri.toPolygon(geomFact);
            }
            return geomFact.createGeometryCollection((Geometry[])ArraysKt.requireNoNulls((Object[])geoms));
        }

        public final double area(@NotNull List<? extends Tri> triList) {
            Intrinsics.checkNotNullParameter(triList, (String)"triList");
            double area = 0.0;
            for (Tri tri : triList) {
                area += tri.getArea();
            }
            return area;
        }

        public final void validate(@NotNull List<? extends Tri> triList) {
            Intrinsics.checkNotNullParameter(triList, (String)"triList");
            for (Tri tri : triList) {
                tri.validate();
            }
        }

        @JvmStatic
        @NotNull
        public final Tri create(@NotNull Coordinate p0, @NotNull Coordinate p1, @NotNull Coordinate p2) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            return new Tri(p0, p1, p2);
        }

        @NotNull
        public final Tri create(@NotNull Coordinate[] pts) {
            Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
            return new Tri(pts[0], pts[1], pts[2]);
        }

        public final int next(int index) {
            switch (index) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 0;
                }
            }
            return -1;
        }

        public final int prev(int index) {
            switch (index) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
            }
            return -1;
        }

        public final int oppVertex(int edgeIndex) {
            return this.prev(edgeIndex);
        }

        public final int oppEdge(int vertexIndex) {
            return this.next(vertexIndex);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

