/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.util;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001:\u0001HB\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020#2\b\u0010'\u001a\u0004\u0018\u00010(J\u0010\u0010)\u001a\u00020#2\b\u0010*\u001a\u0004\u0018\u00010(J\u000e\u0010+\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\u001dJ\u000e\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u00020\u001dJ\u000e\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020\u001dJ\u000e\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020\u001dJ\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0004J\u0006\u00107\u001a\u000208J\u0006\u00109\u001a\u000208J\u0006\u0010:\u001a\u000208J\u0006\u0010;\u001a\u000208J\u000e\u0010<\u001a\u0002082\u0006\u0010=\u001a\u00020\u001dJ\u0016\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001d2\u0006\u0010A\u001a\u00020\u001dJ\u0016\u0010B\u001a\u0002082\u0006\u0010@\u001a\u00020\u001d2\u0006\u0010A\u001a\u00020\u001dJ\u0018\u0010C\u001a\u00020(2\u0006\u0010D\u001a\u00020\u001d2\u0006\u0010E\u001a\u00020\u001dH\u0004J \u0010F\u001a\u00020(2\u0006\u0010D\u001a\u00020\u001d2\u0006\u0010E\u001a\u00020\u001d2\u0006\u0010G\u001a\u00020(H\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006I"}, d2={"Lorg/locationtech/jts/util/GeometricShapeFactory;", "", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "()V", "getGeomFact", "()Lorg/locationtech/jts/geom/GeometryFactory;", "setGeomFact", "precModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "getPrecModel", "()Lorg/locationtech/jts/geom/PrecisionModel;", "setPrecModel", "(Lorg/locationtech/jts/geom/PrecisionModel;)V", "dim", "Lorg/locationtech/jts/util/GeometricShapeFactory$Dimensions;", "getDim", "()Lorg/locationtech/jts/util/GeometricShapeFactory$Dimensions;", "setDim", "(Lorg/locationtech/jts/util/GeometricShapeFactory$Dimensions;)V", "nPts", "", "getNPts", "()I", "setNPts", "(I)V", "rotationAngle", "", "getRotationAngle", "()D", "setRotationAngle", "(D)V", "setEnvelope", "", "env", "Lorg/locationtech/jts/geom/Envelope;", "setBase", "base", "Lorg/locationtech/jts/geom/Coordinate;", "setCentre", "centre", "setNumPoints", "setSize", "size", "setWidth", "width", "setHeight", "height", "setRotation", "radians", "rotate", "Lorg/locationtech/jts/geom/Geometry;", "geom", "createRectangle", "Lorg/locationtech/jts/geom/Polygon;", "createCircle", "createEllipse", "createSquircle", "createSupercircle", "power", "createArc", "Lorg/locationtech/jts/geom/LineString;", "startAng", "angExtent", "createArcPolygon", "coord", "x", "y", "coordTrans", "trans", "Dimensions", "kts-core"})
public class GeometricShapeFactory {
    @NotNull
    private GeometryFactory geomFact;
    @Nullable
    private PrecisionModel precModel;
    @NotNull
    private Dimensions dim;
    private int nPts;
    private double rotationAngle;

    @JvmOverloads
    public GeometricShapeFactory(@NotNull GeometryFactory geomFact) {
        Intrinsics.checkNotNullParameter((Object)geomFact, (String)"geomFact");
        this.geomFact = geomFact;
        this.dim = new Dimensions();
        this.nPts = 100;
        this.precModel = this.geomFact.getPrecisionModel();
    }

    @NotNull
    protected final GeometryFactory getGeomFact() {
        return this.geomFact;
    }

    protected final void setGeomFact(@NotNull GeometryFactory geometryFactory) {
        Intrinsics.checkNotNullParameter((Object)geometryFactory, (String)"<set-?>");
        this.geomFact = geometryFactory;
    }

    public GeometricShapeFactory() {
        this(new GeometryFactory());
    }

    @Nullable
    protected final PrecisionModel getPrecModel() {
        return this.precModel;
    }

    protected final void setPrecModel(@Nullable PrecisionModel precisionModel) {
        this.precModel = precisionModel;
    }

    @NotNull
    protected final Dimensions getDim() {
        return this.dim;
    }

    protected final void setDim(@NotNull Dimensions dimensions) {
        Intrinsics.checkNotNullParameter((Object)dimensions, (String)"<set-?>");
        this.dim = dimensions;
    }

    protected final int getNPts() {
        return this.nPts;
    }

    protected final void setNPts(int n) {
        this.nPts = n;
    }

    protected final double getRotationAngle() {
        return this.rotationAngle;
    }

    protected final void setRotationAngle(double d) {
        this.rotationAngle = d;
    }

    public final void setEnvelope(@NotNull Envelope env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.dim.setEnvelope(env);
    }

    public final void setBase(@Nullable Coordinate base) {
        this.dim.setBase(base);
    }

    public final void setCentre(@Nullable Coordinate centre) {
        this.dim.set_centre(centre);
    }

    public final void setNumPoints(int nPts) {
        this.nPts = nPts;
    }

    public final void setSize(double size) {
        this.dim.setSize(size);
    }

    public final void setWidth(double width) {
        this.dim.setWidth(width);
    }

    public final void setHeight(double height) {
        this.dim.setHeight(height);
    }

    public final void setRotation(double radians) {
        this.rotationAngle = radians;
    }

    @NotNull
    protected final Geometry rotate(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        if (!(this.rotationAngle == 0.0)) {
            Coordinate coordinate = this.dim.getCentre();
            Intrinsics.checkNotNull((Object)coordinate);
            double d = coordinate.x;
            Coordinate coordinate2 = this.dim.getCentre();
            Intrinsics.checkNotNull((Object)coordinate2);
            AffineTransformation trans = AffineTransformation.Companion.rotationInstance(this.rotationAngle, d, coordinate2.y);
            geom.apply(trans);
        }
        return geom;
    }

    @NotNull
    public final Polygon createRectangle() {
        double y;
        double x;
        int i;
        int ipt = 0;
        int nSide = this.nPts / 4;
        if (nSide < 1) {
            nSide = 1;
        }
        double XsegLen = this.dim.getEnvelope().getWidth() / (double)nSide;
        double YsegLen = this.dim.getEnvelope().getHeight() / (double)nSide;
        Object[] pts = new Coordinate[4 * nSide + 1];
        Envelope env = this.dim.getEnvelope();
        for (i = 0; i < nSide; ++i) {
            x = env.getMinX() + (double)i * XsegLen;
            y = env.getMinY();
            pts[ipt++] = this.coord(x, y);
        }
        for (i = 0; i < nSide; ++i) {
            x = env.getMaxX();
            y = env.getMinY() + (double)i * YsegLen;
            pts[ipt++] = this.coord(x, y);
        }
        for (i = 0; i < nSide; ++i) {
            x = env.getMaxX() - (double)i * XsegLen;
            y = env.getMaxY();
            pts[ipt++] = this.coord(x, y);
        }
        for (i = 0; i < nSide; ++i) {
            x = env.getMinX();
            y = env.getMaxY() - (double)i * YsegLen;
            pts[ipt++] = this.coord(x, y);
        }
        int n = ipt++;
        Coordinate coordinate = pts[0];
        Intrinsics.checkNotNull((Object)coordinate);
        pts[n] = new Coordinate(coordinate);
        LinearRing ring = this.geomFact.createLinearRing((Coordinate[])ArraysKt.requireNoNulls((Object[])pts));
        Polygon poly = GeometryFactory.createPolygon$default(this.geomFact, ring, null, 2, null);
        Geometry geometry = this.rotate(poly);
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
        return (Polygon)geometry;
    }

    @NotNull
    public final Polygon createCircle() {
        return this.createEllipse();
    }

    @NotNull
    public final Polygon createEllipse() {
        Envelope env = this.dim.getEnvelope();
        double xRadius = env.getWidth() / 2.0;
        double yRadius = env.getHeight() / 2.0;
        double centreX = env.getMinX() + xRadius;
        double centreY = env.getMinY() + yRadius;
        Object[] pts = new Coordinate[this.nPts + 1];
        int iPt = 0;
        int n = this.nPts;
        for (int i = 0; i < n; ++i) {
            double ang = (double)i * (java.lang.Math.PI * 2 / (double)this.nPts);
            double x = xRadius * Math.INSTANCE.cos(ang) + centreX;
            double y = yRadius * Math.INSTANCE.sin(ang) + centreY;
            pts[iPt++] = this.coord(x, y);
        }
        Coordinate coordinate = pts[0];
        Intrinsics.checkNotNull((Object)coordinate);
        pts[iPt] = new Coordinate(coordinate);
        LinearRing ring = this.geomFact.createLinearRing((Coordinate[])ArraysKt.requireNoNulls((Object[])pts));
        Polygon poly = GeometryFactory.createPolygon$default(this.geomFact, ring, null, 2, null);
        Geometry geometry = this.rotate(poly);
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
        return (Polygon)geometry;
    }

    @NotNull
    public final Polygon createSquircle() {
        return this.createSupercircle(4.0);
    }

    @NotNull
    public final Polygon createSupercircle(double power) {
        double recipPow = 1.0 / power;
        double radius = this.dim.getMinSize() / (double)2;
        Coordinate coordinate = this.dim.getCentre();
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate centre = coordinate;
        double r4 = Math.INSTANCE.pow(radius, power);
        double xyInt = Math.INSTANCE.pow(r4 / (double)2, recipPow);
        int nSegsInOct = this.nPts / 8;
        int totPts = nSegsInOct * 8 + 1;
        Object[] pts = new Coordinate[totPts];
        double xInc = xyInt / (double)nSegsInOct;
        int i = 0;
        if (i <= nSegsInOct) {
            while (true) {
                double x = 0.0;
                double y = radius;
                if (i != 0) {
                    x = xInc * (double)i;
                    double x4 = Math.INSTANCE.pow(x, power);
                    y = Math.INSTANCE.pow(r4 - x4, recipPow);
                }
                pts[i] = this.coordTrans(x, y, centre);
                pts[2 * nSegsInOct - i] = this.coordTrans(y, x, centre);
                pts[2 * nSegsInOct + i] = this.coordTrans(y, -x, centre);
                pts[4 * nSegsInOct - i] = this.coordTrans(x, -y, centre);
                pts[4 * nSegsInOct + i] = this.coordTrans(-x, -y, centre);
                pts[6 * nSegsInOct - i] = this.coordTrans(-y, -x, centre);
                pts[6 * nSegsInOct + i] = this.coordTrans(-y, x, centre);
                pts[8 * nSegsInOct - i] = this.coordTrans(-x, y, centre);
                if (i == nSegsInOct) break;
                ++i;
            }
        }
        int n = pts.length - 1;
        Coordinate coordinate2 = pts[0];
        Intrinsics.checkNotNull((Object)coordinate2);
        pts[n] = new Coordinate(coordinate2);
        LinearRing ring = this.geomFact.createLinearRing((Coordinate[])ArraysKt.requireNoNulls((Object[])pts));
        Polygon poly = GeometryFactory.createPolygon$default(this.geomFact, ring, null, 2, null);
        Geometry geometry = this.rotate(poly);
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
        return (Polygon)geometry;
    }

    @NotNull
    public final LineString createArc(double startAng, double angExtent) {
        Envelope env = this.dim.getEnvelope();
        double xRadius = env.getWidth() / 2.0;
        double yRadius = env.getHeight() / 2.0;
        double centreX = env.getMinX() + xRadius;
        double centreY = env.getMinY() + yRadius;
        double angSize = angExtent;
        if (angSize <= 0.0 || angSize > java.lang.Math.PI * 2) {
            angSize = java.lang.Math.PI * 2;
        }
        double angInc = angSize / (double)(this.nPts - 1);
        Object[] pts = new Coordinate[this.nPts];
        int iPt = 0;
        int n = this.nPts;
        for (int i = 0; i < n; ++i) {
            double ang = startAng + (double)i * angInc;
            double x = xRadius * Math.INSTANCE.cos(ang) + centreX;
            double y = yRadius * Math.INSTANCE.sin(ang) + centreY;
            pts[iPt++] = this.coord(x, y);
        }
        LineString line = this.geomFact.createLineString((Coordinate[])ArraysKt.requireNoNulls((Object[])pts));
        Geometry geometry = this.rotate(line);
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
        return (LineString)geometry;
    }

    @NotNull
    public final Polygon createArcPolygon(double startAng, double angExtent) {
        Envelope env = this.dim.getEnvelope();
        double xRadius = env.getWidth() / 2.0;
        double yRadius = env.getHeight() / 2.0;
        double centreX = env.getMinX() + xRadius;
        double centreY = env.getMinY() + yRadius;
        double angSize = angExtent;
        if (angSize <= 0.0 || angSize > java.lang.Math.PI * 2) {
            angSize = java.lang.Math.PI * 2;
        }
        double angInc = angSize / (double)(this.nPts - 1);
        Object[] pts = new Coordinate[this.nPts + 2];
        int iPt = 0;
        pts[iPt++] = this.coord(centreX, centreY);
        int n = this.nPts;
        for (int i = 0; i < n; ++i) {
            double ang = startAng + angInc * (double)i;
            double x = xRadius * Math.INSTANCE.cos(ang) + centreX;
            double y = yRadius * Math.INSTANCE.sin(ang) + centreY;
            pts[iPt++] = this.coord(x, y);
        }
        pts[iPt++] = this.coord(centreX, centreY);
        LinearRing ring = this.geomFact.createLinearRing((Coordinate[])ArraysKt.requireNoNulls((Object[])pts));
        Polygon poly = GeometryFactory.createPolygon$default(this.geomFact, ring, null, 2, null);
        Geometry geometry = this.rotate(poly);
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
        return (Polygon)geometry;
    }

    @NotNull
    protected final Coordinate coord(double x, double y) {
        Coordinate pt = new Coordinate(x, y);
        PrecisionModel precisionModel = this.precModel;
        Intrinsics.checkNotNull((Object)precisionModel);
        precisionModel.makePrecise(pt);
        return pt;
    }

    @NotNull
    protected final Coordinate coordTrans(double x, double y, @NotNull Coordinate trans) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        return this.coord(x + trans.x, y + trans.y);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u0013\u0010\r\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u0011\u0010\u001b\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012R$\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lorg/locationtech/jts/util/GeometricShapeFactory$Dimensions;", "", "<init>", "()V", "base", "Lorg/locationtech/jts/geom/Coordinate;", "getBase", "()Lorg/locationtech/jts/geom/Coordinate;", "setBase", "(Lorg/locationtech/jts/geom/Coordinate;)V", "_centre", "get_centre", "set_centre", "centre", "getCentre", "width", "", "getWidth", "()D", "setWidth", "(D)V", "height", "getHeight", "setHeight", "setSize", "", "size", "minSize", "getMinSize", "env", "Lorg/locationtech/jts/geom/Envelope;", "envelope", "getEnvelope", "()Lorg/locationtech/jts/geom/Envelope;", "setEnvelope", "(Lorg/locationtech/jts/geom/Envelope;)V", "kts-core"})
    protected static final class Dimensions {
        @Nullable
        private Coordinate base;
        @Nullable
        private Coordinate _centre;
        private double width;
        private double height;

        @Nullable
        public final Coordinate getBase() {
            return this.base;
        }

        public final void setBase(@Nullable Coordinate coordinate) {
            this.base = coordinate;
        }

        @Nullable
        public final Coordinate get_centre() {
            return this._centre;
        }

        public final void set_centre(@Nullable Coordinate coordinate) {
            this._centre = coordinate;
        }

        @Nullable
        public final Coordinate getCentre() {
            if (this._centre == null) {
                Coordinate coordinate = this.base;
                Intrinsics.checkNotNull((Object)coordinate);
                double d = coordinate.x + this.width / (double)2;
                Coordinate coordinate2 = this.base;
                Intrinsics.checkNotNull((Object)coordinate2);
                this._centre = new Coordinate(d, coordinate2.y + this.height / (double)2);
            }
            Coordinate coordinate = this._centre;
            Intrinsics.checkNotNull((Object)coordinate);
            return coordinate;
        }

        public final double getWidth() {
            return this.width;
        }

        public final void setWidth(double d) {
            this.width = d;
        }

        public final double getHeight() {
            return this.height;
        }

        public final void setHeight(double d) {
            this.height = d;
        }

        public final void setSize(double size) {
            this.height = size;
            this.width = size;
        }

        public final double getMinSize() {
            return Math.INSTANCE.min(this.width, this.height);
        }

        @NotNull
        public final Envelope getEnvelope() {
            Envelope envelope;
            if (this.base != null) {
                Coordinate coordinate = this.base;
                Intrinsics.checkNotNull((Object)coordinate);
                double d = coordinate.x;
                Coordinate coordinate2 = this.base;
                Intrinsics.checkNotNull((Object)coordinate2);
                double d2 = coordinate2.x + this.width;
                Coordinate coordinate3 = this.base;
                Intrinsics.checkNotNull((Object)coordinate3);
                double d3 = coordinate3.y;
                Coordinate coordinate4 = this.base;
                Intrinsics.checkNotNull((Object)coordinate4);
                return new Envelope(d, d2, d3, coordinate4.y + this.height);
            }
            if (this._centre != null) {
                Coordinate coordinate = this._centre;
                Intrinsics.checkNotNull((Object)coordinate);
                double d = coordinate.x - this.width / (double)2;
                Coordinate coordinate5 = this._centre;
                Intrinsics.checkNotNull((Object)coordinate5);
                double d4 = coordinate5.x + this.width / (double)2;
                Coordinate coordinate6 = this._centre;
                Intrinsics.checkNotNull((Object)coordinate6);
                double d5 = coordinate6.y - this.height / (double)2;
                Coordinate coordinate7 = this._centre;
                Intrinsics.checkNotNull((Object)coordinate7);
                envelope = new Envelope(d, d4, d5, coordinate7.y + this.height / (double)2);
            } else {
                envelope = new Envelope(0.0, this.width, 0.0, this.height);
            }
            return envelope;
        }

        public final void setEnvelope(@NotNull Envelope env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            this.width = env.getWidth();
            this.height = env.getHeight();
            this.base = new Coordinate(env.getMinX(), env.getMinY());
            Coordinate coordinate = env.centre();
            Intrinsics.checkNotNull((Object)coordinate);
            this._centre = new Coordinate(coordinate);
        }
    }
}

