/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.util;

import java.awt.Color;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u001a\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/util/TestBuilderProxy;", "", "<init>", "()V", "CLASS_FUNCTIONS_UTIL", "", "tbClass", "Ljava/lang/Class;", "methodShowIndicator", "Ljava/lang/reflect/Method;", "methodShowIndicatorLine", "init", "", "isActive", "", "()Z", "showIndicator", "geom", "Lorg/locationtech/jts/geom/Geometry;", "lineClr", "Ljava/awt/Color;", "kts-core"})
public final class TestBuilderProxy {
    @NotNull
    public static final TestBuilderProxy INSTANCE = new TestBuilderProxy();
    @NotNull
    private static final String CLASS_FUNCTIONS_UTIL = "org.locationtech.jtstest.function.FunctionsUtil";
    @Nullable
    private static Class<?> tbClass;
    @Nullable
    private static Method methodShowIndicator;
    @Nullable
    private static Method methodShowIndicatorLine;

    private TestBuilderProxy() {
    }

    private final void init() {
        if (tbClass != null) {
            return;
        }
        try {
            tbClass = TestBuilderProxy.class.getClassLoader().loadClass(CLASS_FUNCTIONS_UTIL);
            Class<?> clazz = tbClass;
            Intrinsics.checkNotNull(clazz);
            Class[] classArray = new Class[]{Geometry.class};
            methodShowIndicator = clazz.getMethod("showIndicator", classArray);
            Class<?> clazz2 = tbClass;
            Intrinsics.checkNotNull(clazz2);
            classArray = new Class[]{Geometry.class, Color.class};
            methodShowIndicatorLine = clazz2.getMethod("showIndicator", classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean isActive() {
        this.init();
        return tbClass != null;
    }

    public final void showIndicator(@Nullable Geometry geom) {
        this.init();
        if (methodShowIndicator == null) {
            return;
        }
        try {
            Method method = methodShowIndicator;
            Intrinsics.checkNotNull((Object)method);
            Object[] objectArray = new Object[]{geom};
            method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void showIndicator(@Nullable Geometry geom, @Nullable Color lineClr) {
        this.init();
        if (methodShowIndicatorLine == null) {
            return;
        }
        try {
            Method method = methodShowIndicatorLine;
            Intrinsics.checkNotNull((Object)method);
            Object[] objectArray = new Object[]{geom, lineClr};
            method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

