/*
 * Copyright (c) 2016 Vivid Solutions.
 * Copyright (c) 2022 Macrofocus GmbH and Luc Girardin.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * and Eclipse Distribution License v. 1.0 which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v20.html
 * and the Eclipse Distribution License is available at http://www.eclipse.org/org/documents/edl-v10.php.
 */
package org.locationtech.jts.dissolve

import org.locationtech.jts.edgegraph.EdgeGraph
import org.locationtech.jts.edgegraph.HalfEdge
import org.locationtech.jts.geom.Coordinate

/**
 * A graph containing [DissolveHalfEdge]s.
 *
 * @author Martin Davis
 */
internal class DissolveEdgeGraph : EdgeGraph() {
    override fun createEdge(p0: Coordinate): HalfEdge {
        return DissolveHalfEdge(p0)
    }
}