/*
 * Copyright (c) 2016 Vivid Solutions.
 * Copyright (c) 2022 Macrofocus GmbH and Luc Girardin.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * and Eclipse Distribution License v. 1.0 which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v20.html
 * and the Eclipse Distribution License is available at http://www.eclipse.org/org/documents/edl-v10.php.
 */
package org.locationtech.jts.operation.overlay

import org.locationtech.jts.algorithm.LineIntersector
import org.locationtech.jts.geomgraph.Edge
import org.locationtech.jts.geomgraph.index.EdgeSetIntersector
import org.locationtech.jts.geomgraph.index.SegmentIntersector
import org.locationtech.jts.geomgraph.index.SimpleMCSweepLineIntersector

/**
 * Nodes a set of edges.
 * Takes one or more sets of edges and constructs a
 * new set of edges consisting of all the split edges created by
 * noding the input edges together
 * @version 1.7
 */
class EdgeSetNoder(private val li: LineIntersector) {
    private val inputEdges: MutableList<Edge> = ArrayList()
    fun addEdges(edges: MutableList<Edge>) {
        inputEdges.addAll(edges)
    }

    //Debug.println("has proper int = " + si.hasProperIntersection());
    val nodedEdges: MutableList<Edge>
        get() {
            val esi: EdgeSetIntersector = SimpleMCSweepLineIntersector()
            val si = SegmentIntersector(
                li, true, false
            )
            esi.computeIntersections(inputEdges, si, true)
            //Debug.println("has proper int = " + si.hasProperIntersection());
            val splitEdges: MutableList<Edge> = ArrayList()
            val i: Iterator<*> = inputEdges.iterator()
            while (i.hasNext()) {
                val e = i.next() as Edge
                e.getEdgeIntersectionList().addSplitEdges(splitEdges)
            }
            return splitEdges
        }
}