/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.file;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010\u001e\n\u0002\b\u0010\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010\u00062\b\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010\"\u001a\u00020\u0006J\u001c\u0010#\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u00062\u0006\u0010%\u001a\u00020\u001eH\u0002J\u001c\u0010&\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u00062\u0006\u0010'\u001a\u00020\u0004H\u0002J$\u0010(\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u00062\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u001eH\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0006H\u0002J\u0010\u0010.\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u0012\u00100\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u0012\u00101\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u0012\u00102\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u0012\u00103\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u0012\u00104\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u0012\u00105\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u0012\u00106\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u0010\u00107\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u0010\u00108\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u0010\u00109\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010\u0006J)\u0010:\u001a\u00020\u001e2\b\u0010$\u001a\u0004\u0018\u00010\u00062\u0012\u0010;\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\b\"\u00020\u0006\u00a2\u0006\u0002\u0010<J\u001c\u0010:\u001a\u00020\u001e2\b\u0010$\u001a\u0004\u0018\u00010\u00062\b\u0010=\u001a\u0004\u0018\u00010\u0006H\u0007J \u0010:\u001a\u00020\u001e2\b\u0010$\u001a\u0004\u0018\u00010\u00062\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010>J\u0010\u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u0006H\u0002J\u0010\u0010A\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u0006H\u0002J\u0010\u0010B\u001a\u00020\u001e2\u0006\u0010C\u001a\u00020\u000bH\u0002J\u0012\u0010D\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u001a\u0010D\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u00062\u0006\u0010E\u001a\u00020\u001eJ\u0012\u0010F\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u001a\u0010F\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u00062\u0006\u0010E\u001a\u00020\u001eJ\u0012\u0010G\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u0012\u0010H\u001a\u0004\u0018\u00010\u00062\b\u0010-\u001a\u0004\u0018\u00010\u0006J\u0012\u0010I\u001a\u0004\u0018\u00010\u00062\b\u0010-\u001a\u0004\u0018\u00010\u0006J\u0012\u0010J\u001a\u0004\u0018\u00010\u00062\b\u0010-\u001a\u0004\u0018\u00010\u0006J\u001b\u0010K\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b2\u0006\u0010L\u001a\u00020\u0006\u00a2\u0006\u0002\u0010MR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001f\u00a8\u0006N"}, d2={"Lcom/macrofocus/application/file/FilenameUtils;", "", "()V", "BASE_16", "", "EMPTY_STRING", "", "EMPTY_STRING_ARRAY", "", "[Ljava/lang/String;", "EXTENSION_SEPARATOR", "", "getEXTENSION_SEPARATOR", "()C", "EXTENSION_SEPARATOR_STR", "getEXTENSION_SEPARATOR_STR", "()Ljava/lang/String;", "IPV4_MAX_OCTET_VALUE", "IPV4_PATTERN", "Ljava/util/regex/Pattern;", "IPV6_MAX_HEX_DIGITS_PER_GROUP", "IPV6_MAX_HEX_GROUPS", "MAX_UNSIGNED_SHORT", "NOT_FOUND", "OTHER_SEPARATOR", "REG_NAME_PART_PATTERN", "SYSTEM_SEPARATOR", "UNIX_SEPARATOR", "WINDOWS_SEPARATOR", "isSystemWindows", "", "()Z", "concat", "basePath", "fullFileNameToAdd", "doGetFullPath", "fileName", "includeSeparator", "doGetPath", "separatorAdd", "doNormalize", "separator", "keepSeparator", "failIfNullBytePresent", "", "path", "getAdsCriticalOffset", "getBaseName", "getExtension", "getFullPath", "getFullPathNoEndSeparator", "getName", "getPath", "getPathNoEndSeparator", "getPrefix", "getPrefixLength", "indexOfExtension", "indexOfLastSeparator", "isExtension", "extensions", "(Ljava/lang/String;[Ljava/lang/String;)Z", "extension", "", "isIPv4Address", "name", "isRFC3986HostName", "isSeparator", "ch", "normalize", "unixSeparator", "normalizeNoEndSeparator", "removeExtension", "separatorsToSystem", "separatorsToUnix", "separatorsToWindows", "splitOnTokens", "text", "(Ljava/lang/String;)[Ljava/lang/String;", "macrofocus-application"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFilenameUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilenameUtils.kt\ncom/macrofocus/application/file/FilenameUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1661:1\n731#2,9:1662\n37#3,2:1671\n*S KotlinDebug\n*F\n+ 1 FilenameUtils.kt\ncom/macrofocus/application/file/FilenameUtils\n*L\n1640#1:1662,9\n1640#1:1671,2\n*E\n"})
public final class FilenameUtils {
    @NotNull
    public static final FilenameUtils INSTANCE = new FilenameUtils();
    @NotNull
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    @NotNull
    private static final String EMPTY_STRING = "";
    private static final int NOT_FOUND = -1;
    private static final char EXTENSION_SEPARATOR = (char)46;
    @NotNull
    private static final String EXTENSION_SEPARATOR_STR;
    private static final char UNIX_SEPARATOR;
    private static final char WINDOWS_SEPARATOR;
    private static final char SYSTEM_SEPARATOR;
    private static char OTHER_SEPARATOR;
    @NotNull
    private static final Pattern IPV4_PATTERN;
    private static final int IPV4_MAX_OCTET_VALUE;
    private static final int IPV6_MAX_HEX_GROUPS;
    private static final int IPV6_MAX_HEX_DIGITS_PER_GROUP;
    private static final int MAX_UNSIGNED_SHORT;
    private static final int BASE_16;
    @NotNull
    private static final Pattern REG_NAME_PART_PATTERN;
    public static final int $stable;

    private FilenameUtils() {
    }

    public final char getEXTENSION_SEPARATOR() {
        return EXTENSION_SEPARATOR;
    }

    @NotNull
    public final String getEXTENSION_SEPARATOR_STR() {
        return EXTENSION_SEPARATOR_STR;
    }

    public final boolean isSystemWindows() {
        return SYSTEM_SEPARATOR == WINDOWS_SEPARATOR;
    }

    private final boolean isSeparator(char ch) {
        return ch == UNIX_SEPARATOR || ch == WINDOWS_SEPARATOR;
    }

    @Nullable
    public final String normalize(@Nullable String fileName) {
        return this.doNormalize(fileName, SYSTEM_SEPARATOR, true);
    }

    @Nullable
    public final String normalize(@Nullable String fileName, boolean unixSeparator) {
        char separator = unixSeparator ? UNIX_SEPARATOR : WINDOWS_SEPARATOR;
        return this.doNormalize(fileName, separator, true);
    }

    @Nullable
    public final String normalizeNoEndSeparator(@Nullable String fileName) {
        return this.doNormalize(fileName, SYSTEM_SEPARATOR, false);
    }

    @Nullable
    public final String normalizeNoEndSeparator(@Nullable String fileName, boolean unixSeparator) {
        char separator = unixSeparator ? UNIX_SEPARATOR : WINDOWS_SEPARATOR;
        return this.doNormalize(fileName, separator, false);
    }

    private final String doNormalize(String fileName, char separator, boolean keepSeparator) {
        int i;
        if (fileName == null) {
            return null;
        }
        this.failIfNullBytePresent(fileName);
        int size = 0;
        size = fileName.length();
        if (size == 0) {
            return fileName;
        }
        int prefix = this.getPrefixLength(fileName);
        if (prefix < 0) {
            return null;
        }
        char[] array = new char[size + 2];
        String string = fileName;
        int n = 0;
        int n2 = 0;
        int n3 = fileName.length();
        string.getChars(n2, n3, array, n);
        char otherSeparator = separator == SYSTEM_SEPARATOR ? OTHER_SEPARATOR : SYSTEM_SEPARATOR;
        n2 = array.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (array[i2] != otherSeparator) continue;
            array[i2] = separator;
        }
        boolean lastIsDirectory = true;
        if (array[size - 1] != separator) {
            n2 = size;
            size = n2 + 1;
            array[n2] = separator;
            lastIsDirectory = false;
        }
        FilenameUtils $this$doNormalize_u24lambda_u240 = this;
        boolean bl = false;
        for (int i3 = prefix + 1; i3 < size; ++i3) {
            if (array[i3] != separator || array[i3 - 1] != separator) continue;
            System.arraycopy(array, i3, array, i3 - 1, size - i3);
            size += -1;
            --i3;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (array[i] != separator || array[i - 1] != '.' || i != prefix + 1 && array[i - 2] != separator) continue;
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            System.arraycopy(array, i + 1, array, i - 1, size - i);
            size -= 2;
            --i;
        }
        i = prefix + 2;
        block3: while (i < size) {
            if (array[i] == separator && array[i - 1] == '.' && array[i - 2] == '.' && (i == prefix + 2 || array[i - 3] == separator)) {
                if (i == prefix + 2) {
                    return null;
                }
                if (i == size - 1) {
                    lastIsDirectory = true;
                }
                int j = 0;
                for (j = i - 4; j >= prefix; --j) {
                    if (array[j] != separator) continue;
                    System.arraycopy(array, i + 1, array, j + 1, size - i);
                    size -= i - j;
                    i = j + 1;
                    ++i;
                    continue block3;
                }
                System.arraycopy(array, i + 1, array, prefix, size - i);
                size -= i + 1 - prefix;
                i = prefix + 1;
            }
            ++i;
        }
        if (size <= 0) {
            return EMPTY_STRING;
        }
        if (size <= prefix) {
            return new String(array, 0, size);
        }
        if (lastIsDirectory && keepSeparator) {
            return new String(array, 0, size);
        }
        return new String(array, 0, size - 1);
    }

    @Nullable
    public final String concat(@Nullable String basePath, @NotNull String fullFileNameToAdd) {
        Intrinsics.checkNotNullParameter((Object)fullFileNameToAdd, (String)"fullFileNameToAdd");
        int prefix = this.getPrefixLength(fullFileNameToAdd);
        if (prefix < 0) {
            return null;
        }
        if (prefix > 0) {
            return this.normalize(fullFileNameToAdd);
        }
        if (basePath == null) {
            return null;
        }
        int len = basePath.length();
        if (len == 0) {
            return this.normalize(fullFileNameToAdd);
        }
        char ch = basePath.charAt(len - 1);
        if (this.isSeparator(ch)) {
            return this.normalize(basePath + fullFileNameToAdd);
        }
        return this.normalize(basePath + "/" + fullFileNameToAdd);
    }

    @Nullable
    public final String separatorsToUnix(@Nullable String path) {
        if (path == null || StringsKt.indexOf$default((CharSequence)path, (char)WINDOWS_SEPARATOR, (int)0, (boolean)false, (int)6, null) == NOT_FOUND) {
            return path;
        }
        return StringsKt.replace$default((String)path, (char)WINDOWS_SEPARATOR, (char)UNIX_SEPARATOR, (boolean)false, (int)4, null);
    }

    @Nullable
    public final String separatorsToWindows(@Nullable String path) {
        if (path == null || StringsKt.indexOf$default((CharSequence)path, (char)UNIX_SEPARATOR, (int)0, (boolean)false, (int)6, null) == NOT_FOUND) {
            return path;
        }
        return StringsKt.replace$default((String)path, (char)UNIX_SEPARATOR, (char)WINDOWS_SEPARATOR, (boolean)false, (int)4, null);
    }

    @Nullable
    public final String separatorsToSystem(@Nullable String path) {
        if (path == null) {
            return null;
        }
        return this.isSystemWindows() ? this.separatorsToWindows(path) : this.separatorsToUnix(path);
    }

    public final int getPrefixLength(@Nullable String fileName) {
        if (fileName == null) {
            return NOT_FOUND;
        }
        int len = fileName.length();
        if (len == 0) {
            return 0;
        }
        char ch0 = fileName.charAt(0);
        if (ch0 == ':') {
            return NOT_FOUND;
        }
        if (len == 1) {
            if (ch0 == '~') {
                return 2;
            }
            return this.isSeparator(ch0) ? 1 : 0;
        }
        if (ch0 == '~') {
            int posUnix = StringsKt.indexOf$default((CharSequence)fileName, (char)UNIX_SEPARATOR, (int)1, (boolean)false, (int)4, null);
            int posWin = StringsKt.indexOf$default((CharSequence)fileName, (char)WINDOWS_SEPARATOR, (int)1, (boolean)false, (int)4, null);
            if (posUnix == NOT_FOUND && posWin == NOT_FOUND) {
                return len + 1;
            }
            posUnix = posUnix == NOT_FOUND ? posWin : posUnix;
            posWin = posWin == NOT_FOUND ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        char ch1 = fileName.charAt(1);
        if (ch1 == ':') {
            if (Intrinsics.compare((int)(ch0 = Character.toUpperCase(ch0)), (int)65) >= 0 && Intrinsics.compare((int)ch0, (int)90) <= 0) {
                if (len == 2 || !this.isSeparator(fileName.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            if (ch0 == UNIX_SEPARATOR) {
                return 1;
            }
            return NOT_FOUND;
        }
        return this.isSeparator(ch0) ? 1 : 0;
    }

    public final int indexOfLastSeparator(@Nullable String fileName) {
        if (fileName == null) {
            return NOT_FOUND;
        }
        int lastUnixPos = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)UNIX_SEPARATOR, (int)0, (boolean)false, (int)6, null);
        int lastWindowsPos = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)WINDOWS_SEPARATOR, (int)0, (boolean)false, (int)6, null);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public final int indexOfExtension(@Nullable String fileName) throws IllegalArgumentException {
        int offset;
        if (fileName == null) {
            return NOT_FOUND;
        }
        if (this.isSystemWindows() && (offset = StringsKt.indexOf$default((CharSequence)fileName, (char)':', (int)this.getAdsCriticalOffset(fileName), (boolean)false, (int)4, null)) != -1) {
            throw new IllegalArgumentException("NTFS ADS separator (':') in file name is forbidden.");
        }
        int extensionPos = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)EXTENSION_SEPARATOR, (int)0, (boolean)false, (int)6, null);
        int lastSeparator = this.indexOfLastSeparator(fileName);
        return lastSeparator > extensionPos ? NOT_FOUND : extensionPos;
    }

    @Nullable
    public final String getPrefix(@Nullable String fileName) {
        if (fileName == null) {
            return null;
        }
        int len = this.getPrefixLength(fileName);
        if (len < 0) {
            return null;
        }
        if (len > fileName.length()) {
            this.failIfNullBytePresent(fileName + UNIX_SEPARATOR);
            return fileName + UNIX_SEPARATOR;
        }
        String string = fileName.substring(0, len);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String path = string;
        this.failIfNullBytePresent(path);
        return path;
    }

    @Nullable
    public final String getPath(@Nullable String fileName) {
        return this.doGetPath(fileName, 1);
    }

    @Nullable
    public final String getPathNoEndSeparator(@Nullable String fileName) {
        return this.doGetPath(fileName, 0);
    }

    private final String doGetPath(String fileName, int separatorAdd) {
        if (fileName == null) {
            return null;
        }
        int prefix = this.getPrefixLength(fileName);
        if (prefix < 0) {
            return null;
        }
        int index = this.indexOfLastSeparator(fileName);
        int endIndex = index + separatorAdd;
        if (prefix >= fileName.length() || index < 0 || prefix >= endIndex) {
            return EMPTY_STRING;
        }
        String string = fileName.substring(prefix, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String path = string;
        this.failIfNullBytePresent(path);
        return path;
    }

    @Nullable
    public final String getFullPath(@Nullable String fileName) {
        return this.doGetFullPath(fileName, true);
    }

    @Nullable
    public final String getFullPathNoEndSeparator(@Nullable String fileName) {
        return this.doGetFullPath(fileName, false);
    }

    private final String doGetFullPath(String fileName, boolean includeSeparator) {
        if (fileName == null) {
            return null;
        }
        int prefix = this.getPrefixLength(fileName);
        if (prefix < 0) {
            return null;
        }
        if (prefix >= fileName.length()) {
            if (includeSeparator) {
                return this.getPrefix(fileName);
            }
            return fileName;
        }
        int index = this.indexOfLastSeparator(fileName);
        if (index < 0) {
            String string = fileName.substring(0, prefix);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        int end = index + (includeSeparator ? 1 : 0);
        if (end == 0) {
            ++end;
        }
        String string = fileName.substring(0, end);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @Nullable
    public final String getName(@Nullable String fileName) {
        if (fileName == null) {
            return null;
        }
        this.failIfNullBytePresent(fileName);
        int index = this.indexOfLastSeparator(fileName);
        String string = fileName.substring(index + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private final void failIfNullBytePresent(String path) {
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            if (path.charAt(i) != '\u0000') continue;
            throw new IllegalArgumentException("Null byte present in file/path name. There are no known legitimate use cases for such data, but several injection attacks may use it");
        }
    }

    @Nullable
    public final String getBaseName(@Nullable String fileName) {
        return this.removeExtension(this.getName(fileName));
    }

    @Nullable
    public final String getExtension(@Nullable String fileName) throws IllegalArgumentException {
        if (fileName == null) {
            return null;
        }
        int index = this.indexOfExtension(fileName);
        if (index == NOT_FOUND) {
            return EMPTY_STRING;
        }
        String string = fileName.substring(index + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private final int getAdsCriticalOffset(String fileName) {
        int offset1 = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)SYSTEM_SEPARATOR, (int)0, (boolean)false, (int)6, null);
        int offset2 = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)OTHER_SEPARATOR, (int)0, (boolean)false, (int)6, null);
        if (offset1 == -1) {
            if (offset2 == -1) {
                return 0;
            }
            return offset2 + 1;
        }
        if (offset2 == -1) {
            return offset1 + 1;
        }
        return Math.max(offset1, offset2) + 1;
    }

    @Nullable
    public final String removeExtension(@Nullable String fileName) {
        if (fileName == null) {
            return null;
        }
        this.failIfNullBytePresent(fileName);
        int index = this.indexOfExtension(fileName);
        if (index == NOT_FOUND) {
            return fileName;
        }
        String string = fileName.substring(0, index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @JvmOverloads
    public final boolean isExtension(@Nullable String fileName, @Nullable String extension) {
        if (fileName == null) {
            return false;
        }
        this.failIfNullBytePresent(fileName);
        if (extension == null || ((CharSequence)extension).length() == 0) {
            return this.indexOfExtension(fileName) == NOT_FOUND;
        }
        String fileExt = this.getExtension(fileName);
        return Intrinsics.areEqual((Object)fileExt, (Object)extension);
    }

    public final boolean isExtension(@Nullable String fileName, String ... extensions) {
        Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
        if (fileName == null) {
            return false;
        }
        this.failIfNullBytePresent(fileName);
        if (extensions.length == 0) {
            return this.indexOfExtension(fileName) == NOT_FOUND;
        }
        String fileExt = this.getExtension(fileName);
        for (String extension : extensions) {
            if (!Intrinsics.areEqual((Object)fileExt, (Object)extension)) continue;
            return true;
        }
        return false;
    }

    public final boolean isExtension(@Nullable String fileName, @Nullable Collection<String> extensions) {
        if (fileName == null) {
            return false;
        }
        this.failIfNullBytePresent(fileName);
        if (extensions == null || extensions.isEmpty()) {
            return this.indexOfExtension(fileName) == NOT_FOUND;
        }
        String fileExt = this.getExtension(fileName);
        for (String extension : extensions) {
            if (!Intrinsics.areEqual((Object)fileExt, (Object)extension)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final String[] splitOnTokens(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (StringsKt.indexOf$default((CharSequence)text, (char)'?', (int)0, (boolean)false, (int)6, null) == NOT_FOUND && StringsKt.indexOf$default((CharSequence)text, (char)'*', (int)0, (boolean)false, (int)6, null) == NOT_FOUND) {
            String[] stringArray = new String[]{text};
            return stringArray;
        }
        char[] cArray = text.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] array = cArray;
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        char prevChar = '\u0000';
        for (char ch : array) {
            if (ch == '?' || ch == '*') {
                if (buffer.length() != 0) {
                    list.add(buffer.toString());
                    buffer.setLength(0);
                }
                if (ch == '?') {
                    list.add("?");
                } else if (prevChar != '*') {
                    list.add("*");
                }
            } else {
                buffer.append(ch);
            }
            prevChar = ch;
        }
        if (buffer.length() != 0) {
            list.add(buffer.toString());
        }
        String[] stringArray = list.toArray(EMPTY_STRING_ARRAY);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toArray(...)");
        return stringArray;
    }

    private final boolean isIPv4Address(String name) {
        Matcher matcher = IPV4_PATTERN.matcher(name);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher m = matcher;
        if (!m.matches() || m.groupCount() != 4) {
            return false;
        }
        for (int i = 1; i < 5; ++i) {
            String ipSegment;
            Intrinsics.checkNotNullExpressionValue((Object)m.group(i), (String)"group(...)");
            int iIpSegment = Integer.parseInt(ipSegment);
            if (iIpSegment > IPV4_MAX_OCTET_VALUE) {
                return false;
            }
            if (ipSegment.length() <= 1 || !StringsKt.startsWith$default((String)ipSegment, (String)"0", (boolean)false, (int)2, null)) continue;
            return false;
        }
        return true;
    }

    private final boolean isRFC3986HostName(String name) {
        List list;
        CharSequence charSequence = name;
        Regex regex = new Regex("\\.");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        int n2 = parts.length;
        for (int i = 0; i < n2; ++i) {
            if (parts[i].length() == 0) {
                return i == parts.length - 1;
            }
            if (REG_NAME_PART_PATTERN.matcher(parts[i]).matches()) continue;
            return false;
        }
        return true;
    }

    static {
        String string = Character.toString(EXTENSION_SEPARATOR);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        EXTENSION_SEPARATOR_STR = string;
        UNIX_SEPARATOR = (char)47;
        WINDOWS_SEPARATOR = (char)92;
        SYSTEM_SEPARATOR = File.separatorChar;
        Pattern pattern = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        IPV4_PATTERN = pattern;
        IPV4_MAX_OCTET_VALUE = 255;
        IPV6_MAX_HEX_GROUPS = 8;
        IPV6_MAX_HEX_DIGITS_PER_GROUP = 4;
        MAX_UNSIGNED_SHORT = 65535;
        BASE_16 = 16;
        Pattern pattern2 = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9-]*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        REG_NAME_PART_PATTERN = pattern2;
        OTHER_SEPARATOR = INSTANCE.isSystemWindows() ? UNIX_SEPARATOR : WINDOWS_SEPARATOR;
        $stable = 8;
    }
}

