/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.document

import com.macrofocus.application.properties.DocumentBasedApplicationProperties
import com.macrofocus.application.properties.GlobalDocumentBasedApplicationProperties
import com.macrofocus.application.properties.LocalDocumentBasedApplicationProperties
import com.macrofocus.common.command.Command
import com.macrofocus.common.command.UICommand


/**
 * Created by luc on 02/12/15.
 */
abstract class AbstractDocumentBasedApplication<D : Document, V : View<D>> : DocumentBasedApplication<D, V> {
    private var globalProperties: DocumentBasedApplicationProperties? = null
        private get() {
            if (field == null) {
                field = createGlobalProperties()
            }
            return field
        }

    override fun init() {
    }

    protected fun createGlobalProperties(): DocumentBasedApplicationProperties? {
        return GlobalDocumentBasedApplicationProperties()
    }

    override fun createLocalProperties(): DocumentBasedApplicationProperties? {
        return LocalDocumentBasedApplicationProperties(globalProperties!!)
    }

    override fun closeView(view: V?) {
        view!!.close()
    }

    override fun getReloadCommand(view: V?): UICommand? {
        return null
    }

    override fun runAsyncUIThread(command: Command) {
        command.execute()
    }

    override fun runAsyncBackground(command: Command) {
        command.execute()
    }
}