/*
 * Copyright (c) 2018 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.document

import com.macrofocus.application.properties.DocumentBasedApplicationProperties
import com.macrofocus.common.command.AbstractUICommand
import com.macrofocus.common.properties.MutableProperty


class CloseUICommand<D : Document>(application: DocumentBasedApplication<D,View<D>>, view: View<D>) :
    AbstractUICommand(view.properties.getProperty(DocumentBasedApplicationProperties.ACTION_CLOSE_LABEL) as MutableProperty<String?>) {
    private val application: DocumentBasedApplication<D,View<D>>
    private val view: View<D>?

    init {
        this.application = application
        this.view = view
    }

    override fun execute(source: Any?) {
        application.closeView(view)
    }
}