/*
 * Copyright (c) 2018 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.document

import com.macrofocus.application.properties.DocumentBasedApplicationProperties
import com.macrofocus.common.command.AbstractUICommand
import com.macrofocus.common.logging.Logging
import com.macrofocus.common.properties.MutableProperty
import org.mkui.window.CPWindow


class OpenRecentUICommand<D : Document>(
    application: DocumentBasedApplication<D, View<D>>,
    view: View<D>,
    val url: DocumentState
) :
    AbstractUICommand(view.properties.getProperty(DocumentBasedApplicationProperties.ACTION_OPENURL_LABEL) as MutableProperty<String?>) {
    private val application: DocumentBasedApplication<D,View<D>>

    init {
        this.application = application
    }
    override fun execute(source: Any?) {
        if (url != null) {
            val window: CPWindow = application.createWindow()
            val document: D?
            try {
                document = application.openRemoteDocument(url.name, url.url, null)
                application.setup(window, application.createView(window, document))
            } catch (e: OpenDocumentException) {
                Logging.instance.process(e)
            }
//            try {
//                val file: java.io.File = Paths.get(java.net.URL(url.url).toURI()).toFile()
//                application.fileManager.setFile(window.getNativeWindow(), file)
//            } catch (e: FileSystemNotFoundException) {
//                // This is most likely a remote file, noop
//            } catch (e: URISyntaxException) {
//                Logging.getInstance().process(e)
//            } catch (e: MalformedURLException) {
//                Logging.getInstance().process(e)
//            }
        }
    }
}