/*
 * Copyright (c) 2019 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.document.compose


import java.awt.Desktop

interface CPDesktop {
    fun isSupported(action: Desktop.Action): Boolean

    companion object {
        val instance: CPDesktop?
            get() {
                var desktop: CPDesktop? = null
                if (desktop == null) {
                    desktop = if (Desktop.isDesktopSupported()) {
                        DesktopDesktop()
                    } else {
                        DummyDesktop()
                    }
                }
                return desktop
            }
    }
}