/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.file;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.application.file.FileHelper;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b'\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\fJ\u0010\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\fJ\b\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\fJ\u0013\u0010\u001a\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/macrofocus/application/file/AbstractFileFilter;", "Ljavax/swing/filechooser/FileFilter;", "Ljava/io/FileFilter;", "<init>", "()V", "allowDirectories", "", "(Z)V", "accept", "f", "Ljava/io/File;", "Ljava/net/URL;", "", "acceptContentType", "contentType", "defaultExtension", "getDefaultExtension", "()Ljava/lang/String;", "extensions", "", "getExtensions", "()[Ljava/lang/String;", "name", "getName", "getDescription", "buildDescription", "equals", "o", "", "hashCode", "", "macrofocus-application"})
@StabilityInferred(parameters=0)
public abstract class AbstractFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private boolean allowDirectories = true;
    public static final int $stable = 8;

    public AbstractFileFilter() {
    }

    public AbstractFileFilter(boolean allowDirectories) {
        this.allowDirectories = allowDirectories;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean accept(@NotNull File f) {
        void var2_2;
        boolean accept;
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        boolean bl = accept = f.isDirectory() && this.allowDirectories;
        if (!accept) {
            String suffix = FileHelper.INSTANCE.getSuffix(f);
            for (String ext : this.getExtensions()) {
                if (suffix == null || ext == null) continue;
                boolean bl2 = accept = StringsKt.compareTo((String)suffix, (String)ext, (boolean)true) == 0;
                if (!accept) continue;
                return true;
            }
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean accept(@Nullable URL f) {
        boolean bl;
        if (f != null) {
            void var3_3;
            String string = f.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String suffix = FileHelper.INSTANCE.getSuffix(string);
            boolean accept = false;
            for (String ext : this.getExtensions()) {
                if (suffix == null || ext == null) continue;
                boolean bl2 = accept = StringsKt.compareTo((String)suffix, (String)ext, (boolean)true) == 0;
                if (!accept) continue;
                return true;
            }
            bl = var3_3;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean accept(@Nullable String f) {
        boolean bl;
        if (f != null) {
            void var3_3;
            String suffix = FileHelper.INSTANCE.getSuffix(f);
            boolean accept = false;
            for (String ext : this.getExtensions()) {
                if (suffix == null || ext == null) continue;
                boolean bl2 = accept = StringsKt.compareTo((String)suffix, (String)ext, (boolean)true) == 0;
                if (!accept) continue;
                return true;
            }
            bl = var3_3;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean acceptContentType(@Nullable String contentType) {
        return false;
    }

    @NotNull
    public abstract String getDefaultExtension();

    @NotNull
    public String[] getExtensions() {
        String[] stringArray = new String[]{this.getDefaultExtension()};
        return stringArray;
    }

    @NotNull
    public abstract String getName();

    @Override
    @NotNull
    public String getDescription() {
        return this.buildDescription(this.getName());
    }

    @NotNull
    public final String buildDescription(@Nullable String name) {
        StringBuffer buffer = new StringBuffer(name);
        buffer.append(" (");
        boolean first = true;
        for (String s : this.getExtensions()) {
            if (!first) {
                buffer.append(";");
            }
            buffer.append("*.");
            buffer.append(s);
            first = false;
        }
        buffer.append(")");
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractFileFilter)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getName(), (Object)((AbstractFileFilter)o).getName());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getName()};
        return Objects.hash(objectArray);
    }
}

