/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.document

import com.macrofocus.application.properties.DocumentBasedApplicationProperties
import com.macrofocus.application.status.CPStatusBar
import org.mkui.component.CPComponent
import org.mkui.component.menu.CPMenu
import org.mkui.component.menu.CPMenuBar
import org.mkui.component.menu.CPMenuBuilder
import org.mkui.window.CPWindow

/**
 * Created by luc on 03/12/15.
 */
interface View<D : Document> {
    fun init()
    val properties: DocumentBasedApplicationProperties
    var document: D?
    fun close()
    fun customizeWindow(rootPanel: CPWindow?)
    fun customizeFileOpen(fileMenu: CPMenu?)
    fun customizeFileSave(fileMenu: CPMenu?)
    fun customizeFileOpen(fileMenu: CPMenuBuilder?)
    fun customizeFileSave(fileMenu: CPMenuBuilder?)
    fun customizeMenuBar(menuBar: CPMenuBar)
    fun customizeStatusBar(statusBar: CPStatusBar)
    fun setStyleClass(vararg styleClasses: String?)
    val nativeComponent: CPComponent?
}