/*
 * Copyright (c) 2018 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.properties

import com.macrofocus.common.properties.MutableProperties
import com.macrofocus.common.properties.MutableProperty


interface DocumentBasedApplicationProperties : MutableProperties<String?> {
    fun languageProperty(): MutableProperty<String?>
    fun dispose()

    companion object {
        val MENU_FILE_LABEL: String = "menu.file.label"
        val ACTION_NEW_LABEL: String = "action.new.label"
        val ACTION_OPEN_LABEL: String = "action.open.label"
        val ACTION_OPENURL_LABEL: String = "action.openurl.label"
        val MENU_OPENRECENT_LABEL: String = "menu.openrecent.label"
        val ACTION_RELOAD_LABEL: String = "action.reload.label"
        val ACTION_PRINT_LABEL: String = "action.print.label"
        val ACTION_PAGESETUP_LABEL: String = "action.pagesetup.label"
        val ACTION_CLOSE_LABEL: String = "action.close.label"
        val ACTION_EXIT_LABEL: String = "action.exit.label"
    }
}