/*
 * Copyright (c) 2018 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.properties

import com.macrofocus.application.properties.DocumentBasedApplicationProperties.Companion.ACTION_CLOSE_LABEL
import com.macrofocus.application.properties.DocumentBasedApplicationProperties.Companion.ACTION_EXIT_LABEL
import com.macrofocus.application.properties.DocumentBasedApplicationProperties.Companion.ACTION_NEW_LABEL
import com.macrofocus.application.properties.DocumentBasedApplicationProperties.Companion.ACTION_OPENURL_LABEL
import com.macrofocus.application.properties.DocumentBasedApplicationProperties.Companion.ACTION_OPEN_LABEL
import com.macrofocus.application.properties.DocumentBasedApplicationProperties.Companion.ACTION_PAGESETUP_LABEL
import com.macrofocus.application.properties.DocumentBasedApplicationProperties.Companion.ACTION_PRINT_LABEL
import com.macrofocus.application.properties.DocumentBasedApplicationProperties.Companion.ACTION_RELOAD_LABEL
import com.macrofocus.application.properties.DocumentBasedApplicationProperties.Companion.MENU_FILE_LABEL
import com.macrofocus.application.properties.DocumentBasedApplicationProperties.Companion.MENU_OPENRECENT_LABEL
import com.macrofocus.common.properties.*


class GlobalDocumentBasedApplicationProperties : SimpleProperties(), DocumentBasedApplicationProperties {
    private val language: MutableProperty<String?>
    override fun languageProperty(): MutableProperty<String?> {
        return language
    }

    fun init(language: String?) {
        if (language == "de") {
            getProperty(MENU_FILE_LABEL).value = "Daten"
            getProperty(ACTION_NEW_LABEL).value = "Neu"
            getProperty(ACTION_OPEN_LABEL).value = "Öffnen"
            getProperty(ACTION_OPENURL_LABEL).value = "Öffnen URL"
            getProperty(MENU_OPENRECENT_LABEL).value = "Zuletzt geöffnet"
            getProperty(ACTION_RELOAD_LABEL).value = "Neu laden"
            getProperty(ACTION_PRINT_LABEL).value = "Print"
            getProperty(ACTION_PAGESETUP_LABEL).value = "Page Setup"
            getProperty(ACTION_CLOSE_LABEL).value = "Schliessen"
            getProperty(ACTION_EXIT_LABEL).value = "Beenden"
        } else if (language == "fr") {
            getProperty(MENU_FILE_LABEL).value = "Fichier"
            getProperty(ACTION_NEW_LABEL).value = "Nouveau"
            getProperty(ACTION_OPEN_LABEL).value = "Charger"
            getProperty(ACTION_OPENURL_LABEL).value = "Charger URL"
            getProperty(MENU_OPENRECENT_LABEL).value = "Ouvrir récent"
            getProperty(ACTION_RELOAD_LABEL).value = "Recharger"
            getProperty(ACTION_PRINT_LABEL).value = "Print"
            getProperty(ACTION_PAGESETUP_LABEL).value = "Page Setup"
            getProperty(ACTION_CLOSE_LABEL).value = "Fermer"
            getProperty(ACTION_EXIT_LABEL).value = "Sortir"
        } else {
            getProperty(MENU_FILE_LABEL).value = "File"
            getProperty(ACTION_NEW_LABEL).value = "New"
            getProperty(ACTION_OPEN_LABEL).value = "Open"
            getProperty(ACTION_OPENURL_LABEL).value = "Open URL"
            getProperty(MENU_OPENRECENT_LABEL).value = "Open Recent"
            getProperty(ACTION_RELOAD_LABEL).value = "Reload"
            getProperty(ACTION_PRINT_LABEL).value = "Print"
            getProperty(ACTION_PAGESETUP_LABEL).value = "Page Setup"
            getProperty(ACTION_CLOSE_LABEL).value = "Close"
            getProperty(ACTION_EXIT_LABEL).value = "Exit"
        }
    }

    override fun dispose() {
        throw IllegalStateException()
    }

    init {
        language = SimpleProperty("en")
        addProperty(MENU_FILE_LABEL, SimpleProperty("File"))
        addProperty(ACTION_NEW_LABEL, SimpleProperty("New"))
        addProperty(ACTION_OPEN_LABEL, SimpleProperty("Open"))
        addProperty(ACTION_OPENURL_LABEL, SimpleProperty("Open URL"))
        addProperty(MENU_OPENRECENT_LABEL, SimpleProperty("Open Recent"))
        addProperty(ACTION_RELOAD_LABEL, SimpleProperty("Reload"))
        addProperty(ACTION_PRINT_LABEL, SimpleProperty("Print"))
        addProperty(ACTION_PAGESETUP_LABEL, SimpleProperty("Page Setup"))
        addProperty(ACTION_CLOSE_LABEL, SimpleProperty("Close"))
        addProperty(ACTION_EXIT_LABEL, SimpleProperty("Exit"))
        language.addPropertyListener(object : PropertyListener<String?> {
            override fun propertyChanged(event: PropertyEvent<String?>) {
                init(event.newValue)
            }
        })
    }
}