/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.properties

import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.Property
import com.macrofocus.common.properties.PropertyEvent
import com.macrofocus.common.properties.PropertyListener


class WrappedMutableProperty<T>(property: MutableProperty<T>) : MutableProperty<T> {
    private var property: MutableProperty<T>?
    private var listeners: MutableSet<PropertyListener<T>>? = null
    private val listener: PropertyListener<T> = object : PropertyListener<T> {
        override fun propertyChanged(event: PropertyEvent<T>) {}
    }

    override var value: T
        get() = property!!.value
        set(value) {
            property!!.value = value
        }

    override fun addPropertyListener(listener: PropertyListener<T>) {
        getListeners()!!.add(listener)
        property!!.addPropertyListener(listener)
    }

    override fun addWeakPropertyListener(listener: PropertyListener<T>) {
        getListeners()!!.add(listener)
        property!!.addWeakPropertyListener(listener)
    }

    override fun removePropertyListener(listener: PropertyListener<T>) {
        getListeners()!!.remove(listener)
        property!!.removePropertyListener(listener)
    }

    fun bind(source: Property<T?>?) {
        throw UnsupportedOperationException()
    }

    fun bindBidirectional(source: MutableProperty<T?>?) {
        throw UnsupportedOperationException()
    }

    private fun getListeners(): MutableSet<PropertyListener<T>>? {
        if (listeners == null) {
            listeners = HashSet<PropertyListener<T>>()
        }
        return listeners
    }

    fun dispose() {
        if (listeners != null) {
            for (listener in listeners!!) {
                property!!.removePropertyListener(listener)
            }
        }
        listeners = null
        property = null
    }

    init {
        this.property = property
    }
}