package com.macrofocus.application.file

import java.beans.PropertyChangeListener
import java.io.File
import javax.swing.JFileChooser
import javax.swing.filechooser.FileSystemView
import javax.swing.plaf.basic.BasicFileChooserUI


/**
 * Created by IntelliJ IDEA.
 * User: luc
 * Date: Oct 17, 2006
 * Time: 12:09:14 AM
 */
class MFileChooser : JFileChooser {
    constructor() : super() {
        init()
    }

    constructor(currentDirectoryPath: String?) : super(currentDirectoryPath) {
        init()
    }

    constructor(currentDirectory: File?) : super(currentDirectory) {
        init()
    }

    constructor(fsv: FileSystemView?) : super(fsv) {
        init()
    }

    constructor(currentDirectory: File?, fsv: FileSystemView?) : super(currentDirectory, fsv) {
        init()
    }

    constructor(currentDirectoryPath: String?, fsv: FileSystemView?) : super(currentDirectoryPath, fsv) {
        init()
    }

    private fun init() {
        addPropertyChangeListener(FILE_FILTER_CHANGED_PROPERTY, PropertyChangeListener { evt ->
            if (getUI() is BasicFileChooserUI) {
                val fileChooserUI = getUI() as BasicFileChooserUI
                val oldFileName = fileChooserUI.fileName
                if (oldFileName != null && oldFileName.trim { it <= ' ' }.length > 0) {
                    // ToDo: reimplement
//                    if (evt.newValue == null || evt.newValue !is AbstractFileFilter) return@PropertyChangeListener
//                    val newValue: AbstractFileFilter = evt.newValue as AbstractFileFilter
//                    val newExtension: String = newValue.getDefaultExtension()
//                    fileChooserUI.fileName = FileHelper.replaceSuffix(oldFileName, newExtension)
                }
            }
        })
    }

    override fun updateUI() {
//        putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
        super.updateUI()
    }
}
