/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.document;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.application.document.Document;
import com.macrofocus.application.document.DocumentState;
import com.macrofocus.application.document.View;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.window.CPWindow;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005:\u00012B\u001b\u0012\u0012\b\u0002\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u0018\u001a\u0004\u0018\u00018\u00012\b\u0010\u0019\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u001aJ\u0017\u0010\u001b\u001a\u0004\u0018\u00010\r2\b\u0010\u001c\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u001dJ\u001f\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0019\u001a\u0004\u0018\u00010\r2\b\u0010\u001c\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u001f2\b\u0010\u0019\u001a\u0004\u0018\u00010\rJ\u0015\u0010!\u001a\u00020\u001f2\b\u0010\u001c\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\"J\u0013\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0007\u00a2\u0006\u0002\u0010'J\u0006\u0010.\u001a\u00020\u001fJ\u0006\u0010/\u001a\u00020\u001fJ\u0010\u00100\u001a\u00020\u001f2\b\u00101\u001a\u0004\u0018\u00010-R \u0010\u000b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010%R\u001b\u0010(\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0018\u0010+\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010-\u0018\u00010,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/macrofocus/application/document/DocumentBasedApplicationState;", "D", "Lcom/macrofocus/application/document/Document;", "V", "Lcom/macrofocus/application/document/View;", "", "urls", "", "", "<init>", "([Ljava/lang/String;)V", "viewWindow", "", "Lorg/mkui/window/CPWindow;", "windowView", "recent", "Lkotlin/collections/ArrayDeque;", "Lcom/macrofocus/application/document/DocumentState;", "windows", "", "getWindows", "()Ljava/lang/Iterable;", "views", "getViews", "getView", "window", "(Lorg/mkui/window/CPWindow;)Lcom/macrofocus/application/document/View;", "getWindow", "view", "(Lcom/macrofocus/application/document/View;)Lorg/mkui/window/CPWindow;", "add", "", "(Lorg/mkui/window/CPWindow;Lcom/macrofocus/application/document/View;)V", "remove", "(Lcom/macrofocus/application/document/View;)V", "isEmpty", "", "()Z", "getRecent", "()[Lcom/macrofocus/application/document/DocumentState;", "recentURLs", "getRecentURLs", "()[Ljava/lang/String;", "listeners", "", "Lcom/macrofocus/application/document/DocumentBasedApplicationState$Listener;", "triggerRecentChanged", "triggerClossing", "addListener", "listener", "Listener", "macrofocus-application"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDocumentBasedApplicationState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentBasedApplicationState.kt\ncom/macrofocus/application/document/DocumentBasedApplicationState\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,125:1\n37#2,2:126\n*S KotlinDebug\n*F\n+ 1 DocumentBasedApplicationState.kt\ncom/macrofocus/application/document/DocumentBasedApplicationState\n*L\n71#1:126,2\n*E\n"})
public final class DocumentBasedApplicationState<D extends Document, V extends View<D>> {
    @Nullable
    private final Map<V, CPWindow> viewWindow;
    @Nullable
    private final Map<CPWindow, V> windowView;
    @NotNull
    private final ArrayDeque<DocumentState> recent;
    @Nullable
    private final List<Listener> listeners;
    public static final int $stable = 8;

    public DocumentBasedApplicationState(@Nullable String[] urls) {
        this.listeners = new ArrayList();
        this.viewWindow = new HashMap();
        this.windowView = new HashMap();
        this.recent = new ArrayDeque(10);
        if (urls != null) {
            Set set = new HashSet(urls.length);
            for (String url : urls) {
                if (set.contains(url)) continue;
                set.add(url);
                DocumentState state = new DocumentState(url);
                this.recent.addLast((Object)state);
            }
        }
    }

    public /* synthetic */ DocumentBasedApplicationState(String[] stringArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            stringArray = null;
        }
        this(stringArray);
    }

    @NotNull
    public final Iterable<Object> getWindows() {
        Map<CPWindow, V> map = this.windowView;
        Intrinsics.checkNotNull(map);
        return map.keySet();
    }

    @NotNull
    public final Iterable<V> getViews() {
        Map<V, CPWindow> map = this.viewWindow;
        Intrinsics.checkNotNull(map);
        return map.keySet();
    }

    @Nullable
    public final V getView(@Nullable CPWindow window) {
        Map<CPWindow, V> map = this.windowView;
        Intrinsics.checkNotNull(map);
        return (V)((View)map.get(window));
    }

    @Nullable
    public final CPWindow getWindow(@Nullable V view) {
        Map<V, CPWindow> map = this.viewWindow;
        Intrinsics.checkNotNull(map);
        return map.get(view);
    }

    public final void add(@Nullable CPWindow window, @Nullable V view) {
        CPWindow w = this.getWindow(view);
        V v = this.getView(window);
        this.remove(v);
        this.remove(w);
        this.remove(view);
        this.remove(window);
        Map<CPWindow, CPWindow> map = this.viewWindow;
        Intrinsics.checkNotNull(map);
        map.put((CPWindow)view, window);
        Map<CPWindow, V> map2 = this.windowView;
        Intrinsics.checkNotNull(map2);
        map2.put(window, view);
        V v2 = view;
        Intrinsics.checkNotNull(v2);
        Object d = v2.getDocument();
        if (d != null) {
            CollectionsKt.removeAll((List)((List)this.recent), arg_0 -> DocumentBasedApplicationState.add$lambda$0(d, arg_0));
            DocumentState documentState = d.getDocumentState();
            Intrinsics.checkNotNull((Object)documentState);
            this.recent.addFirst((Object)documentState);
            this.triggerRecentChanged();
        }
    }

    public final void remove(@Nullable CPWindow window) {
        Map<CPWindow, V> map = this.windowView;
        Intrinsics.checkNotNull(map);
        View view = (View)map.get(window);
        this.windowView.remove(window);
        Map<V, CPWindow> map2 = this.viewWindow;
        Intrinsics.checkNotNull(map2);
        map2.remove(view);
    }

    public final void remove(@Nullable V view) {
        Map<V, CPWindow> map = this.viewWindow;
        Intrinsics.checkNotNull(map);
        CPWindow window = map.get(view);
        Map<CPWindow, V> map2 = this.windowView;
        Intrinsics.checkNotNull(map2);
        map2.remove(window);
        this.viewWindow.remove(view);
    }

    public final boolean isEmpty() {
        Map<CPWindow, V> map = this.windowView;
        Intrinsics.checkNotNull(map);
        return map.size() == 0;
    }

    @NotNull
    public final DocumentState[] getRecent() {
        Collection $this$toTypedArray$iv = (Collection)this.recent;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new DocumentState[0]);
    }

    @Nullable
    public final String[] getRecentURLs() {
        String[] recent = new String[this.recent.size()];
        int i = 0;
        for (DocumentState documentState : this.recent) {
            recent[i] = documentState.getUrl();
            ++i;
        }
        return recent;
    }

    public final void triggerRecentChanged() {
        List<Listener> list = this.listeners;
        Intrinsics.checkNotNull(list);
        Iterator<Listener> iterator = list.iterator();
        while (iterator.hasNext()) {
            Listener listener2;
            Listener listener3 = listener2 = iterator.next();
            Intrinsics.checkNotNull((Object)listener3);
            listener3.recentChanged();
        }
    }

    public final void triggerClossing() {
        List<Listener> list = this.listeners;
        Intrinsics.checkNotNull(list);
        Iterator<Listener> iterator = list.iterator();
        while (iterator.hasNext()) {
            Listener listener2;
            Listener listener3 = listener2 = iterator.next();
            Intrinsics.checkNotNull((Object)listener3);
            listener3.recentChanged();
        }
    }

    public final void addListener(@Nullable Listener listener2) {
        List<Listener> list = this.listeners;
        Intrinsics.checkNotNull(list);
        list.add(listener2);
    }

    private static final boolean add$lambda$0(Document $d, DocumentState documentState) {
        Intrinsics.checkNotNullParameter((Object)documentState, (String)"documentState");
        String string = documentState.getUrl();
        DocumentState documentState2 = $d.getDocumentState();
        Intrinsics.checkNotNull((Object)documentState2);
        return Intrinsics.areEqual((Object)string, (Object)documentState2.getUrl());
    }

    public DocumentBasedApplicationState() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005\u00c0\u0006\u0003"}, d2={"Lcom/macrofocus/application/document/DocumentBasedApplicationState$Listener;", "", "recentChanged", "", "closing", "macrofocus-application"})
    public static interface Listener {
        public void recentChanged();

        public void closing();
    }
}

