/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.document.compose;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.application.document.AbstractDocumentBasedApplication;
import com.macrofocus.application.document.Document;
import com.macrofocus.application.document.DocumentBasedApplication;
import com.macrofocus.application.document.DocumentBasedApplicationState;
import com.macrofocus.application.document.DocumentOpener;
import com.macrofocus.application.document.DocumentState;
import com.macrofocus.application.document.OpenDocumentException;
import com.macrofocus.application.document.View;
import com.macrofocus.application.document.compose.CPDesktop;
import com.macrofocus.application.document.compose.ComposeSDIDocumentBasedApplication;
import com.macrofocus.application.document.compose.LocalDocumentOpener;
import com.macrofocus.application.file.CPFileChooser;
import com.macrofocus.application.file.CPFileManager;
import com.macrofocus.application.file.DefaultFileManager;
import com.macrofocus.application.root.CPDragDropHere;
import com.macrofocus.application.status.CPStatusBar;
import com.macrofocus.application.window.CPWindowManager;
import com.macrofocus.application.window.SwingMFIWindowManager;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.command.Future;
import com.macrofocus.common.command.FutureCommand;
import com.macrofocus.common.file.CPFile;
import com.macrofocus.common.file.FileType;
import com.macrofocus.common.logging.Logging;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.Taskbar;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import kotlin.ExperimentalStdlibApi;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.component.menu.CPMenu;
import org.mkui.component.menu.CPMenuBar;
import org.mkui.window.CPWindow;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u0000 u*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005:\u0001uB\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u00107\u001a\u000208H\u0016J\u0012\u00109\u001a\u0002082\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\u0010\u0010<\u001a\u0002082\b\u0010=\u001a\u0004\u0018\u000100J\u0010\u0010<\u001a\u0002082\u0006\u0010C\u001a\u00020;H\u0004J\b\u0010D\u001a\u000208H\u0016J\b\u0010E\u001a\u00020;H\u0016J!\u0010F\u001a\u0002082\b\u0010:\u001a\u0004\u0018\u00010;2\b\u0010G\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010HJ*\u0010I\u001a\u0002082\b\u0010:\u001a\u0004\u0018\u00010;2\f\u0010J\u001a\b\u0012\u0004\u0012\u00028\u00000'2\b\u0010K\u001a\u0004\u0018\u00010LH\u0016J\u000e\u0010M\u001a\u0002082\u0006\u0010:\u001a\u00020NJ\u0012\u0010O\u001a\u0002082\b\u0010:\u001a\u0004\u0018\u00010;H\u0007J!\u0010T\u001a\u0002082\b\u0010:\u001a\u0004\u0018\u00010;2\b\u0010U\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010VJ\u001c\u0010W\u001a\u0002082\b\u0010X\u001a\u0004\u0018\u00010Y2\b\u0010:\u001a\u0004\u0018\u00010;H\u0014J\u001f\u0010Z\u001a\u0004\u0018\u00010[2\u0006\u0010:\u001a\u00020;2\u0006\u0010U\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\\J\u001d\u0010]\u001a\u0002082\u0006\u0010^\u001a\u00020_2\u0006\u0010U\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010`J\u001d\u0010a\u001a\u0002082\u0006\u0010^\u001a\u00020_2\u0006\u0010U\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010`J\u0010\u0010b\u001a\u0002082\u0006\u0010^\u001a\u00020_H\u0002J\u001f\u0010c\u001a\u00020d2\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010U\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010eJ\u0010\u0010f\u001a\u0002082\u0006\u0010g\u001a\u00020hH\u0016J\u0010\u0010i\u001a\u0002082\u0006\u0010g\u001a\u00020hH\u0016JC\u0010i\u001a\u000208\"\n\b\u0002\u0010j*\u0004\u0018\u00010h\"\u0004\b\u0003\u0010k2\b\u0010g\u001a\u0004\u0018\u0001Hj2\u0018\u0010l\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u0001Hj\u0012\u0006\u0012\u0004\u0018\u0001Hk\u0018\u00010mH\u0016\u00a2\u0006\u0002\u0010nJ>\u0010o\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001Hk\u0018\u00010p\"\u0012\b\u0002\u0010j*\f\u0012\u0006\u0012\u0004\u0018\u0001Hk\u0018\u00010q\"\u0004\b\u0003\u0010k2\u0010\u0010g\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001Hk\u0018\u00010qH\u0016J\u0017\u0010r\u001a\u0002082\b\u0010U\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010sJ\u000e\u0010t\u001a\u0002082\u0006\u0010:\u001a\u00020;R&\u0010\b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0007R.\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\f2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u001a\u0010 \u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0017\"\u0004\b\"\u0010\u0019R\u000e\u0010#\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010)\u001a\u0004\u0018\u00010(2\b\u0010\u000b\u001a\u0004\u0018\u00010(8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010.\u001a\f\u0012\u0006\u0012\u0004\u0018\u000100\u0018\u00010/8F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R(\u00103\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\t8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b4\u0010\u0007\u001a\u0004\b5\u00106R\u001a\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u0016\u0010P\u001a\u0004\u0018\u00010Q8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010S\u00a8\u0006v"}, d2={"Lcom/macrofocus/application/document/compose/ComposeSDIDocumentBasedApplication;", "D", "Lcom/macrofocus/application/document/Document;", "V", "Lcom/macrofocus/application/document/View;", "Lcom/macrofocus/application/document/AbstractDocumentBasedApplication;", "<init>", "()V", "state", "Lcom/macrofocus/application/document/DocumentBasedApplicationState;", "getState$annotations", "value", "Lcom/macrofocus/application/window/CPWindowManager;", "windowManager", "getWindowManager", "()Lcom/macrofocus/application/window/CPWindowManager;", "Lcom/macrofocus/application/file/CPFileManager;", "fileManager", "getFileManager", "()Lcom/macrofocus/application/file/CPFileManager;", "allowNewDocument", "", "getAllowNewDocument", "()Z", "setAllowNewDocument", "(Z)V", "startWithNewDocument", "getStartWithNewDocument", "setStartWithNewDocument", "exitOnClose", "getExitOnClose", "setExitOnClose", "openFileAutomatic", "getOpenFileAutomatic", "setOpenFileAutomatic", "initialized", "started", "startDocuments", "", "Lcom/macrofocus/application/document/DocumentOpener;", "Lcom/macrofocus/application/file/CPFileChooser;", "fileChooser", "getFileChooser", "()Lcom/macrofocus/application/file/CPFileChooser;", "listener", "Lcom/macrofocus/application/root/CPDragDropHere$Listener;", "recent", "", "", "getRecent", "()[Ljava/lang/String;", "applicationState", "getApplicationState$annotations", "getApplicationState", "()Lcom/macrofocus/application/document/DocumentBasedApplicationState;", "init", "", "showAbout", "window", "Lorg/mkui/window/CPWindow;", "start", "fileUrl", "installLocations", "", "Ljava/io/File;", "getInstallLocations", "()Ljava/lang/Iterable;", "firstWindow", "stop", "createWindow", "showDocument", "document", "(Lorg/mkui/window/CPWindow;Lcom/macrofocus/application/document/Document;)V", "openAndShowDocument", "documentOpener", "file", "Lcom/macrofocus/common/file/CPFile;", "configureWindow", "Ljavax/swing/JFrame;", "closeWindow", "applicationIcon", "Ljava/awt/Image;", "getApplicationIcon", "()Ljava/awt/Image;", "setup", "view", "(Lorg/mkui/window/CPWindow;Lcom/macrofocus/application/document/View;)V", "customizeEmptyView", "dragDropHere", "Lcom/macrofocus/application/root/CPDragDropHere;", "createMenuBar", "Ljavax/swing/JMenuBar;", "(Lorg/mkui/window/CPWindow;Lcom/macrofocus/application/document/View;)Ljavax/swing/JMenuBar;", "restoreReopen", "reopenMenu", "Lorg/mkui/component/menu/CPMenu;", "(Lorg/mkui/component/menu/CPMenu;Lcom/macrofocus/application/document/View;)V", "populateReopen", "saveReopen", "createStatusBar", "Lcom/macrofocus/application/status/CPStatusBar;", "(Lorg/mkui/window/CPWindow;Lcom/macrofocus/application/document/View;)Lcom/macrofocus/application/status/CPStatusBar;", "runAsyncUIThread", "command", "Lcom/macrofocus/common/command/Command;", "runAsyncBackground", "C", "R", "callback", "Lcom/macrofocus/application/document/DocumentBasedApplication$Callback;", "(Lcom/macrofocus/common/command/Command;Lcom/macrofocus/application/document/DocumentBasedApplication$Callback;)V", "runAsyncFuture", "Lcom/macrofocus/common/command/Future;", "Lcom/macrofocus/common/command/FutureCommand;", "closeView", "(Lcom/macrofocus/application/document/View;)V", "openFileChooser", "Companion", "macrofocus-application"})
@ExperimentalStdlibApi
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nComposeSDIDocumentBasedApplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeSDIDocumentBasedApplication.kt\ncom/macrofocus/application/document/compose/ComposeSDIDocumentBasedApplication\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,738:1\n1#2:739\n*E\n"})
public abstract class ComposeSDIDocumentBasedApplication<D extends Document, V extends View<D>>
extends AbstractDocumentBasedApplication<D, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private DocumentBasedApplicationState<D, V> state;
    @Nullable
    private CPWindowManager<V> windowManager;
    @Nullable
    private CPFileManager fileManager;
    private boolean allowNewDocument = true;
    private boolean startWithNewDocument = true;
    private boolean exitOnClose;
    private boolean openFileAutomatic = true;
    private boolean initialized;
    private boolean started;
    @NotNull
    private final List<DocumentOpener<D>> startDocuments = new ArrayList();
    @Nullable
    private CPFileChooser fileChooser;
    @NotNull
    private final CPDragDropHere.Listener listener = new CPDragDropHere.Listener(this){
        final /* synthetic */ ComposeSDIDocumentBasedApplication<D, V> this$0;
        {
            this.this$0 = $receiver;
        }

        public void filesDropped(Iterable<? extends File> files) {
            Iterable<? extends File> iterable = files;
            Intrinsics.checkNotNull(iterable);
            Iterator<? extends File> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                File file;
                File file2 = file = iterator.next();
                Intrinsics.checkNotNull((Object)file2);
                CPFile cpFile = new CPFile(file2);
                DocumentOpener documentOpener2 = new DocumentOpener<D>(this.this$0, cpFile){
                    final /* synthetic */ ComposeSDIDocumentBasedApplication<D, V> this$0;
                    final /* synthetic */ CPFile $cpFile;
                    {
                        this.this$0 = $receiver;
                        this.$cpFile = $cpFile;
                    }

                    public D openDocument(CPWindow window) throws OpenDocumentException {
                        return this.this$0.openLocalDocument(this.$cpFile, null, window);
                    }
                };
                CPWindow newWindow = this.this$0.createWindow();
                this.this$0.openAndShowDocument(newWindow, documentOpener2, cpFile);
            }
        }
    };
    public static final int $stable = 8;
    private static final boolean BACKGROUND_LOADING = true;

    @ExperimentalStdlibApi
    private static /* synthetic */ void getState$annotations() {
    }

    @Nullable
    public final CPWindowManager<V> getWindowManager() {
        return this.windowManager;
    }

    @Nullable
    public final CPFileManager getFileManager() {
        return this.fileManager;
    }

    protected final boolean getAllowNewDocument() {
        return this.allowNewDocument;
    }

    protected final void setAllowNewDocument(boolean bl) {
        this.allowNewDocument = bl;
    }

    protected final boolean getStartWithNewDocument() {
        return this.startWithNewDocument;
    }

    protected final void setStartWithNewDocument(boolean bl) {
        this.startWithNewDocument = bl;
    }

    protected final boolean getExitOnClose() {
        return this.exitOnClose;
    }

    protected final void setExitOnClose(boolean bl) {
        this.exitOnClose = bl;
    }

    protected final boolean getOpenFileAutomatic() {
        return this.openFileAutomatic;
    }

    protected final void setOpenFileAutomatic(boolean bl) {
        this.openFileAutomatic = bl;
    }

    @Nullable
    public final CPFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new CPFileChooser();
        }
        return this.fileChooser;
    }

    @Nullable
    public final String[] getRecent() {
        return null;
    }

    @Override
    @Nullable
    public DocumentBasedApplicationState<D, V> getApplicationState() {
        return this.state;
    }

    @ExperimentalStdlibApi
    public static /* synthetic */ void getApplicationState$annotations() {
    }

    @Override
    public void init() {
        block14: {
            boolean bl;
            boolean bl2 = bl = !this.initialized;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.windowManager = new SwingMFIWindowManager(this);
            this.fileManager = new DefaultFileManager();
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.application.name", this.getName());
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", this.getName());
            System.setProperty("http.agent", this.getName());
            this.state = new DocumentBasedApplicationState(this.getRecent());
            CPDesktop desktop = CPDesktop.Companion.getInstance();
            if (desktop != null) {
                try {
                    if (desktop.isSupported(Desktop.Action.APP_OPEN_FILE)) {
                        // empty if block
                    }
                    if (desktop.isSupported(Desktop.Action.APP_OPEN_URI)) {
                        // empty if block
                    }
                    if (desktop.isSupported(Desktop.Action.APP_ABOUT)) {
                        // empty if block
                    }
                    if (desktop.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
                        // empty if block
                    }
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
            }
            try {
                if (!Taskbar.isTaskbarSupported()) break block14;
                try {
                    if (this.getApplicationIcon() != null) {
                        Taskbar.getTaskbar().setIconImage(this.getApplicationIcon());
                    }
                }
                catch (SecurityException e) {
                    Logging.Companion.getInstance().process((Throwable)e);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
            }
        }
        this.initialized = true;
    }

    public void showAbout(@Nullable CPWindow window) {
    }

    public final void start(@Nullable String fileUrl) {
        CPWindow window;
        block11: {
            boolean bl = this.initialized;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl2 = bl = !this.started;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            CPWindowManager<V> cPWindowManager = this.windowManager;
            Intrinsics.checkNotNull(cPWindowManager);
            boolean windowExist = cPWindowManager.getWindowCount() == 0;
            CPWindowManager<V> cPWindowManager2 = this.windowManager;
            Intrinsics.checkNotNull(cPWindowManager2);
            CPWindow firstWindow = window = cPWindowManager2.createWindow();
            if (fileUrl != null) {
                try {
                    if (StringsKt.startsWith$default((String)fileUrl, (String)"http", (boolean)false, (int)2, null)) {
                        v3 = this.startDocuments.add(new DocumentOpener<D>(this, fileUrl){
                            final /* synthetic */ ComposeSDIDocumentBasedApplication<D, V> this$0;
                            final /* synthetic */ String $fileUrl;
                            {
                                this.this$0 = $receiver;
                                this.$fileUrl = $fileUrl;
                            }

                            public D openDocument(CPWindow window) throws OpenDocumentException {
                                return this.this$0.openRemoteDocument(this.$fileUrl, this.$fileUrl, null);
                            }
                        });
                    } else {
                        CPFile file = new CPFile(new File(fileUrl));
                        v3 = this.startDocuments.add(new LocalDocumentOpener<D>(file, this){
                            final /* synthetic */ CPFile $file;
                            final /* synthetic */ ComposeSDIDocumentBasedApplication<D, V> this$0;
                            {
                                this.$file = $file;
                                this.this$0 = $receiver;
                            }

                            public CPFile getFile() {
                                return this.$file;
                            }

                            public D openDocument(CPWindow window) throws OpenDocumentException {
                                return this.this$0.openLocalDocument(this.$file, null, window);
                            }
                        });
                    }
                }
                catch (Throwable e) {
                    Logging.Companion.getInstance().process(e);
                }
            }
            if (this.startDocuments.isEmpty() && this.openFileAutomatic) {
                try {
                    if (!windowExist) break block11;
                    for (File directory : this.getInstallLocations()) {
                        File[] files = directory.listFiles((arg_0, arg_1) -> ComposeSDIDocumentBasedApplication.start$lambda$0(this, arg_0, arg_1));
                        if (files == null || files.length != 1) continue;
                        File file = files[0];
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"get(...)");
                        CPFile file2 = new CPFile(file);
                        this.startDocuments.add(new LocalDocumentOpener<D>(file2, this){
                            final /* synthetic */ CPFile $file;
                            final /* synthetic */ ComposeSDIDocumentBasedApplication<D, V> this$0;
                            {
                                this.$file = $file;
                                this.this$0 = $receiver;
                            }

                            public CPFile getFile() {
                                return this.$file;
                            }

                            public D openDocument(CPWindow window) throws OpenDocumentException {
                                return this.this$0.openLocalDocument(this.$file, null, window);
                            }
                        });
                        break;
                    }
                }
                catch (Throwable e) {
                    Logging.Companion.getInstance().process(e);
                }
            }
        }
        this.runAsyncBackground(new Command(window, this){
            private CPWindow w;
            final /* synthetic */ ComposeSDIDocumentBasedApplication<D, V> this$0;
            {
                this.this$0 = $receiver;
                this.w = $window;
            }

            public final CPWindow getW() {
                return this.w;
            }

            public final void setW(CPWindow cPWindow) {
                this.w = cPWindow;
            }

            public void execute() {
                boolean success = false;
                if (ComposeSDIDocumentBasedApplication.access$getStartDocuments$p(this.this$0).isEmpty()) {
                    try {
                        Boolean bl = ComposeSDIDocumentBasedApplication.Companion.invokeAndWait(() -> start.4.execute$lambda$0(this.this$0, this));
                        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"invokeAndWait(...)");
                        success = bl;
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Exception e) {
                        Boolean bl = Logging.Companion.getInstance().process((Throwable)e);
                    }
                } else {
                    for (DocumentOpener documentOpener2 : ComposeSDIDocumentBasedApplication.access$getStartDocuments$p(this.this$0)) {
                        CPWindow newWindow = null;
                        if (this.w != null) {
                            newWindow = this.w;
                        } else {
                            Boolean bl;
                            try {
                                newWindow = ComposeSDIDocumentBasedApplication.Companion.invokeAndWait(() -> start.4.execute$lambda$1(this.this$0));
                                bl = Unit.INSTANCE;
                            }
                            catch (Exception e) {
                                bl = Logging.Companion.getInstance().process((Throwable)e);
                            }
                        }
                        try {
                            D document = documentOpener2.openDocument(newWindow);
                            CPWindow nw = newWindow;
                            ComposeSDIDocumentBasedApplication.Companion.invokeAndWait(new Callable(documentOpener2, this.this$0, nw, document){
                                final /* synthetic */ DocumentOpener<D> $documentOpener;
                                final /* synthetic */ ComposeSDIDocumentBasedApplication<D, V> this$0;
                                final /* synthetic */ CPWindow $nw;
                                final /* synthetic */ D $document;
                                {
                                    this.$documentOpener = $documentOpener;
                                    this.this$0 = $receiver;
                                    this.$nw = $nw;
                                    this.$document = $document;
                                }

                                public final Void call() {
                                    if (this.$documentOpener instanceof LocalDocumentOpener) {
                                        CPFileManager cPFileManager = this.this$0.getFileManager();
                                        Intrinsics.checkNotNull((Object)cPFileManager);
                                        DocumentOpener<D> documentOpener2 = this.$documentOpener;
                                        Intrinsics.checkNotNull(documentOpener2, (String)"null cannot be cast to non-null type com.macrofocus.application.document.compose.LocalDocumentOpener<D of com.macrofocus.application.document.compose.ComposeSDIDocumentBasedApplication>");
                                        cPFileManager.setFile(this.$nw, ((LocalDocumentOpener)documentOpener2).getFile());
                                    }
                                    this.this$0.setup(this.$nw, this.this$0.createView(this.$nw, this.$document));
                                    return null;
                                }
                            });
                            if (this.w != null) {
                                this.w = null;
                            }
                            success = true;
                        }
                        catch (Throwable e) {
                            Logging.Companion.getInstance().process(e);
                            if (newWindow == this.w) continue;
                            CPWindowManager<V> cPWindowManager = this.this$0.getWindowManager();
                            Intrinsics.checkNotNull(cPWindowManager);
                            CPWindow cPWindow = newWindow;
                            Intrinsics.checkNotNull((Object)cPWindow);
                            cPWindowManager.closeWindow(cPWindow);
                        }
                    }
                }
                if (!success) {
                    CPWindow cPWindow = this.w;
                    Intrinsics.checkNotNull((Object)cPWindow);
                    this.this$0.start(cPWindow);
                }
                ComposeSDIDocumentBasedApplication.access$setStarted$p(this.this$0, true);
            }

            private static final Boolean execute$lambda$0(ComposeSDIDocumentBasedApplication this$0, start.4 this$1) {
                CPWindow cPWindow = this$1.w;
                Intrinsics.checkNotNull((Object)cPWindow);
                this$0.start(cPWindow);
                return true;
            }

            private static final CPWindow execute$lambda$1(ComposeSDIDocumentBasedApplication this$0) {
                CPWindowManager<V> cPWindowManager = this$0.getWindowManager();
                Intrinsics.checkNotNull(cPWindowManager);
                return cPWindowManager.createWindow();
            }
        });
    }

    private final Iterable<File> getInstallLocations() {
        File dir;
        String exeDir;
        File dir2;
        String appDir;
        File dir3;
        Set directories = new LinkedHashSet();
        Path currentRelativePath = Paths.get("", new String[0]);
        File file = currentRelativePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        directories.add(file);
        String userDir = System.getProperty("user.dir");
        if (userDir != null && (dir3 = new File(userDir)).exists()) {
            directories.add(dir3);
        }
        if ((appDir = System.getProperty("install4j.appDir")) != null && (dir2 = new File(appDir)).exists()) {
            directories.add(dir2);
        }
        if ((exeDir = System.getProperty("install4j.exeDir")) != null && (dir = new File(exeDir)).exists()) {
            directories.add(dir);
        }
        return directories;
    }

    protected final void start(@NotNull CPWindow firstWindow) {
        Intrinsics.checkNotNullParameter((Object)firstWindow, (String)"firstWindow");
        if (this.startWithNewDocument) {
            this.setup(firstWindow, this.createView(firstWindow, this.newDocument()));
        } else {
            this.setup(firstWindow, this.createView(firstWindow, null));
        }
    }

    @Override
    public void stop() {
        DocumentBasedApplicationState<D, V> documentBasedApplicationState = this.getApplicationState();
        Intrinsics.checkNotNull(documentBasedApplicationState);
        documentBasedApplicationState.triggerClossing();
        System.exit(0);
    }

    @Override
    @NotNull
    public CPWindow createWindow() {
        CPWindowManager<V> cPWindowManager = this.windowManager;
        Intrinsics.checkNotNull(cPWindowManager);
        return cPWindowManager.createWindow();
    }

    @Override
    public void showDocument(@Nullable CPWindow window, @Nullable D document) {
        CPWindow newWindow = this.createWindow();
        Object view = this.createView(newWindow, document);
        this.setup(newWindow, view);
    }

    @Override
    public void openAndShowDocument(@Nullable CPWindow window, @NotNull DocumentOpener<D> documentOpener2, @Nullable CPFile file) {
        Intrinsics.checkNotNullParameter(documentOpener2, (String)"documentOpener");
        CPWindow newWindow = this.createWindow();
        this.runAsyncBackground(new Command(documentOpener2, newWindow, this, file){
            final /* synthetic */ DocumentOpener<D> $documentOpener;
            final /* synthetic */ CPWindow $newWindow;
            final /* synthetic */ ComposeSDIDocumentBasedApplication<D, V> this$0;
            final /* synthetic */ CPFile $file;
            {
                this.$documentOpener = $documentOpener;
                this.$newWindow = $newWindow;
                this.this$0 = $receiver;
                this.$file = $file;
            }

            public void execute() {
                try {
                    D document = this.$documentOpener.openDocument(this.$newWindow);
                    SwingUtilities.invokeAndWait(() -> openAndShowDocument.1.execute$lambda$0(this.$file, this.this$0, this.$newWindow, document));
                }
                catch (Throwable t) {
                    Logging.Companion.getInstance().process(t);
                    try {
                        CPWindowManager<V> cPWindowManager = this.this$0.getWindowManager();
                        Intrinsics.checkNotNull(cPWindowManager);
                        cPWindowManager.closeWindow(this.$newWindow);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Exception e) {
                        Boolean bl = Logging.Companion.getInstance().process((Throwable)e);
                    }
                }
            }

            private static final void execute$lambda$0(CPFile $file, ComposeSDIDocumentBasedApplication this$0, CPWindow $newWindow, Document $document) {
                if ($file != null) {
                    CPFileManager cPFileManager = this$0.getFileManager();
                    Intrinsics.checkNotNull((Object)cPFileManager);
                    cPFileManager.setFile($newWindow, $file);
                }
                this$0.setup($newWindow, this$0.createView($newWindow, $document));
            }
        });
    }

    public final void configureWindow(@NotNull JFrame window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        window.setIconImage(this.getApplicationIcon());
    }

    @ExperimentalStdlibApi
    public final void closeWindow(@Nullable CPWindow window) {
        block0: {
            V view;
            DocumentBasedApplicationState<D, V> documentBasedApplicationState = this.getApplicationState();
            Intrinsics.checkNotNull(documentBasedApplicationState);
            V v = view = documentBasedApplicationState.getView(window);
            if (v == null) break block0;
            V it = v;
            boolean bl = false;
            this.closeView(it);
        }
    }

    @Nullable
    protected Image getApplicationIcon() {
        return null;
    }

    @Override
    public void setup(@Nullable CPWindow window, @Nullable V view) {
        DocumentBasedApplicationState<D, V> documentBasedApplicationState = this.state;
        Intrinsics.checkNotNull(documentBasedApplicationState);
        documentBasedApplicationState.remove(window);
        DocumentBasedApplicationState<D, V> documentBasedApplicationState2 = this.state;
        Intrinsics.checkNotNull(documentBasedApplicationState2);
        documentBasedApplicationState2.remove(view);
        DocumentBasedApplicationState<D, V> documentBasedApplicationState3 = this.state;
        Intrinsics.checkNotNull(documentBasedApplicationState3);
        documentBasedApplicationState3.add(window, view);
        String string = this.getName();
        Intrinsics.checkNotNull((Object)string);
        Object title = string;
        V v = view;
        Intrinsics.checkNotNull(v);
        if (v.getDocument() != null) {
            Object d = view.getDocument();
            Intrinsics.checkNotNull(d);
            DocumentState documentState = d.getDocumentState();
            Intrinsics.checkNotNull((Object)documentState);
            title = (String)title + " - " + documentState.getName();
        }
    }

    protected void customizeEmptyView(@Nullable CPDragDropHere dragDropHere, @Nullable CPWindow window) {
    }

    @Nullable
    protected final JMenuBar createMenuBar(@NotNull CPWindow window, @NotNull V view) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        CPMenuBar cpMenuBar = new CPMenuBar();
        return null;
    }

    private final void restoreReopen(CPMenu reopenMenu, V view) {
        this.populateReopen(reopenMenu, view);
    }

    private final void populateReopen(CPMenu reopenMenu, V view) {
    }

    private final void saveReopen(CPMenu reopenMenu) {
    }

    @NotNull
    protected final CPStatusBar createStatusBar(@Nullable CPWindow window, @NotNull V view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        CPStatusBar statusBar = new CPStatusBar();
        view.customizeStatusBar(statusBar);
        return statusBar;
    }

    @Override
    public void runAsyncUIThread(@NotNull Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        SwingUtilities.invokeLater(() -> ComposeSDIDocumentBasedApplication.runAsyncUIThread$lambda$0(command));
    }

    @Override
    public void runAsyncBackground(@NotNull Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        new Thread(() -> ComposeSDIDocumentBasedApplication.runAsyncBackground$lambda$0(command)).start();
    }

    @Override
    public <C extends Command, R> void runAsyncBackground(@Nullable C command, @Nullable DocumentBasedApplication.Callback<C, R> callback) {
        new Thread(() -> ComposeSDIDocumentBasedApplication.runAsyncBackground$lambda$1(command, callback)).start();
    }

    @Override
    @Nullable
    public <C extends FutureCommand<R>, R> Future<R> runAsyncFuture(@Nullable FutureCommand<R> command) {
        Callable<Object> callable = () -> ComposeSDIDocumentBasedApplication.runAsyncFuture$lambda$0(command);
        FutureTask<Object> future = new FutureTask<Object>(callable);
        new Thread(future).start();
        return new Future<R>(future){
            final /* synthetic */ FutureTask<R> $future;
            {
                this.$future = $future;
            }

            public boolean isCancelled() {
                return false;
            }

            public boolean isDone() {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            public R get() throws Exception {
                return this.$future.get();
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void closeView(@Nullable V view) {
        super.closeView(view);
        DocumentBasedApplicationState<D, V> documentBasedApplicationState = this.getApplicationState();
        Intrinsics.checkNotNull(documentBasedApplicationState);
        CPWindow window = documentBasedApplicationState.getWindow(view);
        DocumentBasedApplicationState<D, V> documentBasedApplicationState2 = this.getApplicationState();
        Intrinsics.checkNotNull(documentBasedApplicationState2);
        documentBasedApplicationState2.remove(window);
        DocumentBasedApplicationState<D, V> documentBasedApplicationState3 = this.getApplicationState();
        Intrinsics.checkNotNull(documentBasedApplicationState3);
        documentBasedApplicationState3.remove(view);
        CPFileManager cPFileManager = this.fileManager;
        Intrinsics.checkNotNull((Object)cPFileManager);
        cPFileManager.removeWindow(window);
        DocumentBasedApplicationState<D, V> documentBasedApplicationState4 = this.getApplicationState();
        Intrinsics.checkNotNull(documentBasedApplicationState4);
        if (!documentBasedApplicationState4.isEmpty()) {
            if (window != null) {
                CPWindowManager<V> cPWindowManager = this.windowManager;
                Intrinsics.checkNotNull(cPWindowManager);
                cPWindowManager.closeWindow(window);
                return;
            }
            this.stop();
            return;
        }
        if (!this.exitOnClose) {
            V v = view;
            Intrinsics.checkNotNull(v);
            if (v.getDocument() != null) {
                this.setup(window, this.createView(window, null));
                return;
            }
        }
        CPWindowManager<V> cPWindowManager = this.windowManager;
        Intrinsics.checkNotNull(cPWindowManager);
        CPWindow cPWindow = window;
        Intrinsics.checkNotNull((Object)cPWindow);
        cPWindowManager.closeWindow(cPWindow);
        this.stop();
    }

    public final void openFileChooser(@NotNull CPWindow window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        CPFileChooser cPFileChooser = this.getFileChooser();
        Intrinsics.checkNotNull((Object)cPFileChooser);
        CPFileChooser fileChooser = cPFileChooser;
        fileChooser.setTitle("Open File");
        FileType[] fileTypeArray = this.getOpenFileTypes();
        fileChooser.setFileTypes(Arrays.copyOf(fileTypeArray, fileTypeArray.length));
        CPFile file = fileChooser.showOpenDialog(window);
        if (file != null) {
            try {
                DocumentOpener documentOpener2 = new DocumentOpener<D>(this, file){
                    final /* synthetic */ ComposeSDIDocumentBasedApplication<D, V> this$0;
                    final /* synthetic */ CPFile $file;
                    {
                        this.this$0 = $receiver;
                        this.$file = $file;
                    }

                    public D openDocument(CPWindow window) throws OpenDocumentException {
                        return this.this$0.openLocalDocument(this.$file, null, window);
                    }
                };
                this.openAndShowDocument(window, documentOpener2, file);
            }
            catch (Throwable e) {
                Logging.Companion.getInstance().process(e);
            }
        }
    }

    private static final boolean start$lambda$0(ComposeSDIDocumentBasedApplication this$0, File dir, String name) {
        FileType file = this$0.getOpenFileTypes()[0];
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.endsWith$default((String)name, (String)("." + file.getExtensions()[0]), (boolean)false, (int)2, null);
    }

    private static final void runAsyncUIThread$lambda$0(Command $command) {
        try {
            $command.execute();
        }
        catch (Throwable e) {
            Logging.Companion.getInstance().process(e);
        }
    }

    private static final void runAsyncBackground$lambda$0(Command $command) {
        try {
            $command.execute();
        }
        catch (Throwable e) {
            Logging.Companion.getInstance().process(e);
        }
    }

    private static final void runAsyncBackground$lambda$1(Command $command, DocumentBasedApplication.Callback $callback) {
        try {
            Command command = $command;
            Intrinsics.checkNotNull((Object)command);
            command.execute();
            DocumentBasedApplication.Callback callback = $callback;
            Intrinsics.checkNotNull((Object)callback);
            callback.execute($command);
        }
        catch (Throwable e) {
            Logging.Companion.getInstance().process(e);
        }
    }

    private static final Object runAsyncFuture$lambda$0(FutureCommand $command) {
        FutureCommand futureCommand = $command;
        Intrinsics.checkNotNull((Object)futureCommand);
        return futureCommand.execute();
    }

    public static final /* synthetic */ List access$getStartDocuments$p(ComposeSDIDocumentBasedApplication $this) {
        return $this.startDocuments;
    }

    public static final /* synthetic */ void access$setStarted$p(ComposeSDIDocumentBasedApplication $this, boolean bl) {
        $this.started = bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0002\u0010\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\nJ\u001f\u0010\u000b\u001a\u0002H\b\"\u0004\b\u0002\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n\u00a2\u0006\u0002\u0010\fJ!\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0002\u0010\u000e2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\n\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/macrofocus/application/document/compose/ComposeSDIDocumentBasedApplication$Companion;", "", "<init>", "()V", "BACKGROUND_LOADING", "", "invokeLater", "Ljava/util/concurrent/FutureTask;", "T", "callable", "Ljava/util/concurrent/Callable;", "invokeAndWait", "(Ljava/util/concurrent/Callable;)Ljava/lang/Object;", "getFromEDT", "V", "macrofocus-application"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> FutureTask<T> invokeLater(@Nullable Callable<T> callable) {
            FutureTask<T> task = new FutureTask<T>(callable);
            SwingUtilities.invokeLater(task);
            return task;
        }

        public final <T> T invokeAndWait(@NotNull Callable<T> callable) throws InterruptedException, InvocationTargetException {
            T t;
            Intrinsics.checkNotNullParameter(callable, (String)"callable");
            if (SwingUtilities.isEventDispatchThread()) {
                T t2;
                try {
                    t2 = callable.call();
                }
                catch (Exception e) {
                    Throwable t3 = e.getCause();
                    if (t3 instanceof RuntimeException) {
                        throw (RuntimeException)t3;
                    }
                    if (t3 instanceof InvocationTargetException) {
                        throw (InvocationTargetException)t3;
                    }
                    throw new InvocationTargetException(t3);
                }
                t = t2;
            } else {
                T t4;
                try {
                    t4 = this.invokeLater(callable).get();
                }
                catch (ExecutionException e) {
                    Throwable t5 = e.getCause();
                    if (t5 instanceof RuntimeException) {
                        throw (RuntimeException)t5;
                    }
                    if (t5 instanceof InvocationTargetException) {
                        throw (InvocationTargetException)t5;
                    }
                    throw new InvocationTargetException(t5);
                }
                t = t4;
            }
            return t;
        }

        public final <V> V getFromEDT(@Nullable Callable<V> callable) throws InterruptedException, ExecutionException {
            RunnableFuture f = new FutureTask<V>(callable);
            if (SwingUtilities.isEventDispatchThread()) {
                f.run();
            } else {
                SwingUtilities.invokeLater(f);
            }
            return f.get();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

