/*
 * Copyright (c) 2018 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.document

import com.macrofocus.application.properties.DocumentBasedApplicationProperties
import com.macrofocus.common.command.AbstractUICommand
import com.macrofocus.common.properties.MutableProperty
import org.kamaeleo.window.CPWindow

class NewUICommand<D : Document>(application: DocumentBasedApplication<D,View<D>>, view: View<D>) :
    AbstractUICommand(view.properties.getProperty(DocumentBasedApplicationProperties.ACTION_NEW_LABEL) as MutableProperty<String?>) {
    private val application: DocumentBasedApplication<D,View<D>>

    init {
        this.application = application
    }

    override fun execute(source: Any?) {
        val newWindow: CPWindow = application.createWindow()
        application.setup(newWindow, application.createView(newWindow, application.newDocument()))
    }
}