/*
 * Copyright (c) 2018 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.file

import com.macrofocus.common.file.CPFile
import org.kamaeleo.window.CPWindow


class DefaultFileManager : CPFileManager {
    private val windowCurrentDirectory: MutableMap<CPWindow?, CPFile?>?
    private val windowFile: MutableMap<CPWindow?, CPFile?>?
    override fun getCurrentDirectory(window: CPWindow?): CPFile? {
        return windowCurrentDirectory!![window]
    }

    override fun getFile(window: CPWindow?): CPFile? {
        return windowFile!![window]
    }

    override fun setWindowCurrentDirectory(window: CPWindow?, currentDirectory: CPFile?) {
        windowCurrentDirectory!![window] = currentDirectory
    }

    override fun setFile(window: CPWindow?, file: CPFile?) {
        windowFile!![window] = file
    }

    override fun removeWindow(window: CPWindow?) {
        windowCurrentDirectory!!.remove(window)
        windowFile!!.remove(window)
    }

    init {
        windowCurrentDirectory = HashMap()
        windowFile = HashMap()
    }
}