/*
 * Copyright (c) 2018 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.properties

import com.macrofocus.common.properties.MutableProperty

class LocalDocumentBasedApplicationProperties(properties: DocumentBasedApplicationProperties) : WrappedMutableProperties<String?>(properties), DocumentBasedApplicationProperties {
    private var properties: DocumentBasedApplicationProperties?
    override fun languageProperty(): MutableProperty<String?> {
        return getWrappedProperty<String?>(properties!!.languageProperty()) as MutableProperty<String?>
    }

    override fun dispose() {
        super.dispose()
        properties = null
    }

    init {
        this.properties = properties
    }
}