/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.document;

import com.macrofocus.application.document.Document;
import com.macrofocus.application.document.DocumentState;
import com.macrofocus.application.document.View;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.window.CPWindow;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005:\u00011B\u0019\u0012\u0012\b\u0002\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u001f\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u00182\b\u0010#\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010\u000fJ\u0013\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0007\u00a2\u0006\u0002\u0010(J\u0017\u0010)\u001a\u0004\u0018\u00018\u00012\b\u0010\"\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010*J\u0017\u0010+\u001a\u0004\u0018\u00010\u00182\b\u0010#\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010,J\u0015\u0010-\u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010.J\u0010\u0010-\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0018J\u0006\u0010/\u001a\u00020!J\u0006\u00100\u001a\u00020!R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0018\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001c\u00a8\u00062"}, d2={"Lcom/macrofocus/application/document/DocumentBasedApplicationState;", "D", "Lcom/macrofocus/application/document/Document;", "V", "Lcom/macrofocus/application/document/View;", "", "urls", "", "", "([Ljava/lang/String;)V", "isEmpty", "", "()Z", "listeners", "", "Lcom/macrofocus/application/document/DocumentBasedApplicationState$Listener;", "recent", "Lkotlin/collections/ArrayDeque;", "Lcom/macrofocus/application/document/DocumentState;", "recentURLs", "getRecentURLs", "()[Ljava/lang/String;", "viewWindow", "", "Lorg/mkui/window/CPWindow;", "views", "", "getViews", "()Ljava/lang/Iterable;", "windowView", "windows", "getWindows", "add", "", "window", "view", "(Lorg/mkui/window/CPWindow;Lcom/macrofocus/application/document/View;)V", "addListener", "listener", "getRecent", "()[Lcom/macrofocus/application/document/DocumentState;", "getView", "(Lorg/mkui/window/CPWindow;)Lcom/macrofocus/application/document/View;", "getWindow", "(Lcom/macrofocus/application/document/View;)Lorg/mkui/window/CPWindow;", "remove", "(Lcom/macrofocus/application/document/View;)V", "triggerClossing", "triggerRecentChanged", "Listener", "macrofocus-application"})
@SourceDebugExtension(value={"SMAP\nDocumentBasedApplicationState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentBasedApplicationState.kt\ncom/macrofocus/application/document/DocumentBasedApplicationState\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,125:1\n37#2,2:126\n*S KotlinDebug\n*F\n+ 1 DocumentBasedApplicationState.kt\ncom/macrofocus/application/document/DocumentBasedApplicationState\n*L\n71#1:126,2\n*E\n"})
public final class DocumentBasedApplicationState<D extends Document, V extends View<D>> {
    @Nullable
    private final Map<V, CPWindow> viewWindow;
    @Nullable
    private final Map<CPWindow, V> windowView;
    @NotNull
    private final ArrayDeque<DocumentState> recent;
    @Nullable
    private final List<Listener> listeners;

    public DocumentBasedApplicationState(@Nullable String[] urls) {
        this.listeners = new ArrayList();
        this.viewWindow = new HashMap();
        this.windowView = new HashMap();
        this.recent = new ArrayDeque(10);
        if (urls != null) {
            Set set = new HashSet(urls.length);
            Iterator iterator = ArrayIteratorKt.iterator((Object[])urls);
            while (iterator.hasNext()) {
                String url = (String)iterator.next();
                if (set.contains(url)) continue;
                set.add(url);
                DocumentState state = new DocumentState(url);
                this.recent.addLast((Object)state);
            }
        }
    }

    public /* synthetic */ DocumentBasedApplicationState(String[] stringArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            stringArray = null;
        }
        this(stringArray);
    }

    @NotNull
    public final Iterable<Object> getWindows() {
        Map<CPWindow, V> map = this.windowView;
        Intrinsics.checkNotNull(map);
        return map.keySet();
    }

    @NotNull
    public final Iterable<V> getViews() {
        Map<V, CPWindow> map = this.viewWindow;
        Intrinsics.checkNotNull(map);
        return map.keySet();
    }

    @Nullable
    public final V getView(@Nullable CPWindow window) {
        Map<CPWindow, V> map = this.windowView;
        Intrinsics.checkNotNull(map);
        return (V)((View)map.get(window));
    }

    @Nullable
    public final CPWindow getWindow(@Nullable V view) {
        Map<V, CPWindow> map = this.viewWindow;
        Intrinsics.checkNotNull(map);
        return map.get(view);
    }

    public final void add(@Nullable CPWindow window, @Nullable V view) {
        CPWindow w = this.getWindow(view);
        V v = this.getView(window);
        this.remove(v);
        this.remove(w);
        this.remove(view);
        this.remove(window);
        Map<CPWindow, CPWindow> map = this.viewWindow;
        Intrinsics.checkNotNull(map);
        map.put((CPWindow)view, window);
        Map<CPWindow, V> map2 = this.windowView;
        Intrinsics.checkNotNull(map2);
        map2.put(window, view);
        V v2 = view;
        Intrinsics.checkNotNull(v2);
        Object d = v2.getDocument();
        if (d != null) {
            CollectionsKt.removeAll((List)((List)this.recent), (Function1)((Function1)new Function1<DocumentState, Boolean>(d){
                final /* synthetic */ D $d;
                {
                    this.$d = $d;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull DocumentState documentState) {
                    Intrinsics.checkNotNullParameter((Object)documentState, (String)"documentState");
                    String string = documentState.getUrl();
                    DocumentState documentState2 = this.$d.getDocumentState();
                    Intrinsics.checkNotNull((Object)documentState2);
                    return Intrinsics.areEqual((Object)string, (Object)documentState2.getUrl());
                }
            }));
            DocumentState documentState = d.getDocumentState();
            Intrinsics.checkNotNull((Object)documentState);
            this.recent.addFirst((Object)documentState);
            this.triggerRecentChanged();
        }
    }

    public final void remove(@Nullable CPWindow window) {
        Map<CPWindow, V> map = this.windowView;
        Intrinsics.checkNotNull(map);
        View view = (View)map.get(window);
        this.windowView.remove(window);
        Map<V, CPWindow> map2 = this.viewWindow;
        Intrinsics.checkNotNull(map2);
        map2.remove(view);
    }

    public final void remove(@Nullable V view) {
        Map<V, CPWindow> map = this.viewWindow;
        Intrinsics.checkNotNull(map);
        CPWindow window = map.get(view);
        Map<CPWindow, V> map2 = this.windowView;
        Intrinsics.checkNotNull(map2);
        map2.remove(window);
        this.viewWindow.remove(view);
    }

    public final boolean isEmpty() {
        Map<CPWindow, V> map = this.windowView;
        Intrinsics.checkNotNull(map);
        return map.size() == 0;
    }

    @NotNull
    public final DocumentState[] getRecent() {
        Collection $this$toTypedArray$iv = (Collection)this.recent;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new DocumentState[0]);
    }

    @Nullable
    public final String[] getRecentURLs() {
        String[] recent = new String[this.recent.size()];
        int i = 0;
        for (DocumentState documentState : this.recent) {
            recent[i] = documentState.getUrl();
            ++i;
        }
        return recent;
    }

    public final void triggerRecentChanged() {
        List<Listener> list = this.listeners;
        Intrinsics.checkNotNull(list);
        Iterator<Listener> iterator = list.iterator();
        while (iterator.hasNext()) {
            Listener listener2;
            Listener listener3 = listener2 = iterator.next();
            Intrinsics.checkNotNull((Object)listener3);
            listener3.recentChanged();
        }
    }

    public final void triggerClossing() {
        List<Listener> list = this.listeners;
        Intrinsics.checkNotNull(list);
        Iterator<Listener> iterator = list.iterator();
        while (iterator.hasNext()) {
            Listener listener2;
            Listener listener3 = listener2 = iterator.next();
            Intrinsics.checkNotNull((Object)listener3);
            listener3.recentChanged();
        }
    }

    public final void addListener(@Nullable Listener listener2) {
        List<Listener> list = this.listeners;
        Intrinsics.checkNotNull(list);
        list.add(listener2);
    }

    public DocumentBasedApplicationState() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lcom/macrofocus/application/document/DocumentBasedApplicationState$Listener;", "", "closing", "", "recentChanged", "macrofocus-application"})
    public static interface Listener {
        public void recentChanged();

        public void closing();
    }
}

