/*
 * Copyright (c) 2018 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.document

import org.mkui.window.CPWindow


@ExperimentalStdlibApi
class DocumentBasedApplicationState<D : Document, V : View<D>?> constructor(
    urls: Array<String?>? = null
) {
    private val viewWindow: MutableMap<V?, CPWindow?>?
    private val windowView: MutableMap<CPWindow?, V?>?
    private val recent: ArrayDeque<DocumentState>
    val windows: Iterable<Any?>?
        get() = windowView!!.keys

    val views: Iterable<V?>?
        get() = viewWindow!!.keys

    fun getView(window: CPWindow?): V? {
        return windowView!![window]
    }

    fun getWindow(view: V?): CPWindow? {
        return viewWindow!![view]
    }

    fun add(window: CPWindow?, view: V?) {
//        assert(window != null)
//        assert(view != null)
        val w: CPWindow? = getWindow(view)
        val v = getView(window)
        remove(v)
        remove(w)
        remove(view)
        remove(window)
        viewWindow!![view] = window
        windowView!![window] = view
        val d: D? = view!!.document
        if (d != null) {
            // Avoid duplicates
            recent.removeAll { documentState -> documentState.url == d.documentState!!.url }
            recent.addFirst(d.documentState!!)
            triggerRecentChanged()
        }
//        assert(windowView.size == viewWindow.size)
    }

    fun remove(window: CPWindow?) {
        val view = windowView!![window]
        windowView.remove(window)
        viewWindow!!.remove(view)
//        assert(windowView.size == viewWindow.size)
    }

    fun remove(view: V?) {
        val window: CPWindow? = viewWindow!![view]
        windowView!!.remove(window)
        viewWindow.remove(view)
//        assert(windowView.size == viewWindow.size)
    }

    val isEmpty: Boolean
        get() {
//            assert(windowView!!.size == viewWindow!!.size)
            return windowView!!.size == 0
        }

    fun getRecent(): Array<DocumentState?>? {
        return recent.toTypedArray()
    }

    val recentURLs: Array<String?>?
        get() {
            val recent = arrayOfNulls<String?>(recent.size)
            var i = 0
            for (documentState in this.recent) {
                recent[i] = documentState.url
                i++
            }
            return recent
        }

    private val listeners: MutableList<Listener?>? =
        ArrayList<Listener?>()

    fun triggerRecentChanged() {
        for (listener in listeners!!) {
            listener!!.recentChanged()
        }
    }

    fun triggerClossing() {
        for (listener in listeners!!) {
            listener!!.recentChanged()
        }
    }

    fun addListener(listener: Listener?) {
        listeners!!.add(listener)
    }

    interface Listener {
        fun recentChanged()
        fun closing()
    }

    init {
        viewWindow = HashMap<V?, CPWindow?>()
        windowView = HashMap<CPWindow?, V?>()
        recent = ArrayDeque<DocumentState>(10)
        if (urls != null) {
            val set: MutableSet<String?> = HashSet(urls.size)
            for (url in urls) {
                // Avoid duplicates
                if (!set.contains(url)) {
                    set.add(url)
                    val state = DocumentState(url)
                    recent.addLast(state)
                }
            }
        }
    }
}