/*
 * Copyright (c) 2019 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.document.swing

import java.awt.Desktop
import java.awt.desktop.AboutHandler
import java.awt.desktop.OpenFilesHandler
import java.awt.desktop.OpenURIHandler
import java.awt.desktop.QuitHandler

open class DesktopDesktop : CPDesktop {
    private val desktop: Desktop
    override fun isSupported(action: Desktop.Action): Boolean {
        return desktop.isSupported(action)
    }

    override fun setOpenFileHandler(openFileHandler: OpenFilesHandler) {
        desktop.setOpenFileHandler(openFileHandler)
    }

    override fun setOpenURIHandler(openURIHandler: OpenURIHandler) {
        desktop.setOpenURIHandler(openURIHandler)
    }

    override fun setQuitHandler(quitHandler: QuitHandler) {
        desktop.setQuitHandler(quitHandler)
    }

    override fun setAboutHandler(aboutHandler: AboutHandler) {
        desktop.setAboutHandler(aboutHandler)
    }

    init {
        desktop = Desktop.getDesktop()
    }
}