/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.file;

import com.macrofocus.application.file.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u001e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0004J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0016J\u0016\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0006\u001a\u00020\u0004J\u0018\u0010\u001d\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a8\u0006\u001e"}, d2={"Lcom/macrofocus/application/file/FileHelper;", "", "()V", "addSuffix", "", "name", "suffix", "copy", "", "in", "Ljava/io/InputStream;", "out", "Ljava/io/OutputStream;", "getName", "path", "getPath", "getRelativePath", "targetPath", "basePath", "pathSeparator", "getSuffix", "f", "Ljava/io/File;", "s", "hasSuffix", "", "file", "extension", "removeSuffix", "replaceSuffix", "macrofocus-application"})
public final class FileHelper {
    @NotNull
    public static final FileHelper INSTANCE = new FileHelper();

    private FileHelper() {
    }

    @Nullable
    public final String getSuffix(@Nullable File f) {
        String string;
        if (f != null) {
            String s = f.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)s, (String)"s");
            string = this.getSuffix(s);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final String getSuffix(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String s2 = s;
        Object suffix = null;
        int i = StringsKt.lastIndexOf$default((CharSequence)s2, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (i > 0 && i < s2.length() - 1) {
            String string = s2.substring(i + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String string2 = string.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
            suffix = string2;
            String string3 = s2.substring(0, i);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            s2 = string3;
        }
        if (suffix != null && Intrinsics.areEqual(suffix, (Object)"gz") && (i = StringsKt.lastIndexOf$default((CharSequence)s2, (char)'.', (int)0, (boolean)false, (int)6, null)) > 0 && i < s2.length() - 1) {
            String string = s2.substring(i + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String string4 = string.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase()");
            suffix = string4 + "." + (String)suffix;
        }
        return suffix;
    }

    public final boolean hasSuffix(@NotNull File file, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String name = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        return StringsKt.endsWith$default((String)name, (String)("." + extension), (boolean)false, (int)2, null);
    }

    @Nullable
    public final File replaceSuffix(@Nullable File file, @NotNull String suffix) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        File parent = file != null && file.getParentFile() != null ? file.getParentFile() : null;
        File file3 = file;
        String name = file3 != null ? file3.getName() : "Untitled";
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        if (StringsKt.endsWith$default((String)name, (String)("." + suffix), (boolean)false, (int)2, null)) {
            file2 = file;
        } else {
            int index = StringsKt.lastIndexOf$default((CharSequence)name, (String)".", (int)0, (boolean)false, (int)6, null);
            if (index > 0 && name.length() - index <= 5) {
                String string = name.substring(0, index);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String newName = string;
                file2 = new File(parent, newName + "." + suffix);
            } else {
                file2 = new File(parent, name + "." + suffix);
            }
        }
        return file2;
    }

    @NotNull
    public final String addSuffix(@Nullable String name, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        String name2 = name;
        String string = name2;
        if (string == null) {
            string = "Untitled";
        }
        return StringsKt.endsWith$default((String)(name2 = string), (String)("." + suffix), (boolean)false, (int)2, null) ? name2 : name2 + "." + suffix;
    }

    @NotNull
    public final String replaceSuffix(@Nullable String name, @NotNull String suffix) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        String name2 = name;
        String string = name2;
        if (string == null) {
            string = "Untitled";
        }
        if (StringsKt.endsWith$default((String)(name2 = string), (String)("." + suffix), (boolean)false, (int)2, null)) {
            object = name2;
        } else {
            int index = StringsKt.lastIndexOf$default((CharSequence)name2, (String)".", (int)0, (boolean)false, (int)6, null);
            if (index > 0) {
                String string2 = name2.substring(0, index);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String newName = string2;
                object = newName + "." + suffix;
            } else {
                object = name2 + "." + suffix;
            }
        }
        return object;
    }

    @NotNull
    public final String removeSuffix(@NotNull File file, @NotNull String suffix) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        String name = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        if (StringsKt.endsWith$default((String)name, (String)("." + suffix), (boolean)false, (int)2, null)) {
            int index = StringsKt.lastIndexOf$default((CharSequence)name, (String)".", (int)0, (boolean)false, (int)6, null);
            String string2 = name.substring(0, index);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = name;
        }
        return string;
    }

    @NotNull
    public final String removeSuffix(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String name = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        return this.removeSuffix(name);
    }

    @NotNull
    public final String removeSuffix(@NotNull String name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)".", (boolean)false, (int)2, null)) {
            int index = StringsKt.lastIndexOf$default((CharSequence)name, (String)".", (int)0, (boolean)false, (int)6, null);
            String string2 = name.substring(0, index);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = name;
        }
        return string;
    }

    @NotNull
    public final String getName(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.contains$default((CharSequence)path, (CharSequence)"\\", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)path, (CharSequence)"/", (boolean)false, (int)2, null)) {
            int index = Math.max(StringsKt.lastIndexOf$default((CharSequence)path, (String)"\\", (int)0, (boolean)false, (int)6, null), StringsKt.lastIndexOf$default((CharSequence)path, (String)"/", (int)0, (boolean)false, (int)6, null));
            String string2 = path.substring(index + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string = path;
        }
        return string;
    }

    @NotNull
    public final String getPath(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.contains$default((CharSequence)path, (CharSequence)"\\", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)path, (CharSequence)"/", (boolean)false, (int)2, null)) {
            int index = Math.max(StringsKt.lastIndexOf$default((CharSequence)path, (String)"\\", (int)0, (boolean)false, (int)6, null), StringsKt.lastIndexOf$default((CharSequence)path, (String)"/", (int)0, (boolean)false, (int)6, null));
            String string2 = path.substring(0, index);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = path;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copy(@NotNull InputStream in, @NotNull OutputStream out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        InputStream inputStream = in;
        synchronized (inputStream) {
            boolean bl = false;
            OutputStream outputStream = out;
            synchronized (outputStream) {
                int bytesRead;
                boolean bl2 = false;
                byte[] buffer = new byte[256];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                Unit unit = Unit.INSTANCE;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getRelativePath(@NotNull String targetPath, @NotNull String basePath, @NotNull String pathSeparator) {
        int commonIndex;
        void $this$toTypedArray$iv;
        void $this$toTypedArray$iv2;
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)pathSeparator, (String)"pathSeparator");
        String targetPath2 = targetPath;
        String basePath2 = basePath;
        String string = targetPath2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
        if (StringsKt.startsWith$default((String)string, (String)"file:/", (boolean)false, (int)2, null)) {
            String string2 = targetPath2.substring(6);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            targetPath2 = string2;
            while (StringsKt.startsWith$default((String)targetPath2, (String)"/", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNullExpressionValue((Object)targetPath2.substring(1), (String)"this as java.lang.String).substring(startIndex)");
            }
        }
        String string3 = basePath2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase()");
        if (StringsKt.startsWith$default((String)string3, (String)"file:/", (boolean)false, (int)2, null)) {
            String string4 = basePath2.substring(6);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            basePath2 = string4;
            while (StringsKt.startsWith$default((String)basePath2, (String)"/", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNullExpressionValue((Object)basePath2.substring(1), (String)"this as java.lang.String).substring(startIndex)");
            }
        }
        Object tempS = basePath2;
        while (true) {
            File baseF;
            if ((baseF = new File((String)tempS)).exists() && baseF.isFile()) {
                String string5 = baseF.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"baseF.absolutePath");
                basePath2 = string5;
                break;
            }
            if (!Intrinsics.areEqual((Object)pathSeparator, (Object)"/") || StringsKt.startsWith$default((String)tempS, (String)"/", (boolean)false, (int)2, null)) break;
            tempS = "/" + (String)tempS;
        }
        tempS = targetPath2;
        while (true) {
            File targetF;
            if ((targetF = new File((String)tempS)).exists() && targetF.isFile()) {
                String string6 = targetF.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"targetF.absolutePath");
                targetPath2 = string6;
                break;
            }
            if (!Intrinsics.areEqual((Object)pathSeparator, (Object)"/") || StringsKt.startsWith$default((String)tempS, (String)"/", (boolean)false, (int)2, null)) break;
            tempS = "/" + (String)tempS;
        }
        String normalizedTargetPath = FilenameUtils.INSTANCE.normalizeNoEndSeparator(targetPath2);
        String normalizedBasePath = FilenameUtils.INSTANCE.normalizeNoEndSeparator(basePath2);
        if (Intrinsics.areEqual((Object)pathSeparator, (Object)"/")) {
            normalizedTargetPath = FilenameUtils.INSTANCE.separatorsToUnix(normalizedTargetPath);
            normalizedBasePath = FilenameUtils.INSTANCE.separatorsToUnix(normalizedBasePath);
        } else if (Intrinsics.areEqual((Object)pathSeparator, (Object)"\\")) {
            normalizedTargetPath = FilenameUtils.INSTANCE.separatorsToWindows(normalizedTargetPath);
            normalizedBasePath = FilenameUtils.INSTANCE.separatorsToWindows(normalizedBasePath);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + pathSeparator + "'");
        }
        String string7 = normalizedBasePath;
        Intrinsics.checkNotNull((Object)string7);
        Object object = string7;
        String string8 = Pattern.quote(pathSeparator);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"quote(pathSeparator)");
        String string9 = string8;
        string9 = new Regex(string9);
        int n = 0;
        object = string9.split((CharSequence)object, n);
        boolean $i$f$toTypedArray22 = false;
        String thisCollection$iv = $this$toTypedArray$iv2;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] base = stringArray;
        String string10 = normalizedTargetPath;
        Intrinsics.checkNotNull((Object)string10);
        Object $i$f$toTypedArray22 = string10;
        String string11 = Pattern.quote(pathSeparator);
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"quote(pathSeparator)");
        thisCollection$iv = string11;
        thisCollection$iv = new Regex(thisCollection$iv);
        int n2 = 0;
        $i$f$toTypedArray22 = thisCollection$iv.split((CharSequence)$i$f$toTypedArray22, n2);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv2 = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] target = stringArray2;
        StringBuffer common = new StringBuffer();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length; ++commonIndex) {
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            String $this$trim$iv = target[commonIndex];
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            $this$trim$iv = base[commonIndex];
            CharSequence charSequence = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            $i$f$trim = false;
            $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim2 = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (!Intrinsics.areEqual((Object)charSequence, (Object)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) break;
            $this$trim$iv = target[commonIndex];
            charSequence = common;
            $i$f$trim = false;
            $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim2 = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            ((StringBuffer)charSequence).append(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString() + pathSeparator);
        }
        if (commonIndex == 0) {
            File ff = new File(targetPath2);
            if (!ff.exists() || !ff.isFile()) {
                throw new IllegalArgumentException("No common path element found for '" + normalizedTargetPath + "' and '" + normalizedBasePath + "'");
            }
            String string12 = ff.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"ff.absolutePath");
            return string12;
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (StringsKt.endsWith$default((String)basePath2, (String)pathSeparator, (boolean)false, (int)2, null)) {
            baseIsFile = false;
        }
        StringBuffer relative = new StringBuffer();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append(".." + pathSeparator);
            }
        }
        if (common.length() >= normalizedTargetPath.length()) {
            return ".";
        }
        String string13 = normalizedTargetPath.substring(common.length());
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"this as java.lang.String).substring(startIndex)");
        relative.append(string13);
        String string14 = relative.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"relative.toString()");
        return string14;
    }
}

