package com.macrofocus.application

import com.macrofocus.license.LicenseModel

/**
 * Holds information about an application
 */
interface ApplicationModel {
    /**
     * Gets the name of this application
     *
     * @return the name of the application
     */
    val name: String?

    /**
     * Gets the edition name of this application
     *
     * @return the edition name of the application
     */
    val edition: String?

    /**
     * Gets the version number of this application
     *
     * @return the version number of this application
     */
    val version: String?
    val versionModel: VersionModel?
    val copyright: String?
//    val mainClass: java.lang.Class?
    val validity: LicenseModel.Validity?
    val expiration: LicenseModel.Expiration?
    var licenseModel: LicenseModel?
}
