/*
 * Copyright (c) 2019 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.document.swing

import com.install4j.api.launcher.StartupNotification
import com.macrofocus.common.logging.Logging
import java.awt.Desktop
import java.awt.desktop.OpenFilesEvent
import java.awt.desktop.OpenFilesHandler
import java.io.File
import java.util.*
import java.util.regex.Pattern
import javax.swing.SwingUtilities

class Install4JDesktop : DesktopDesktop() {
    private val startupNotification: Class<StartupNotification>?
    override fun isSupported(action: Desktop.Action): Boolean {
        return startupNotification != null && action == java.awt.Desktop.Action.APP_OPEN_FILE || super.isSupported(action)
    }

    override fun setOpenFileHandler(openFileHandler: OpenFilesHandler) {
        val listener: StartupNotification.Listener = object : StartupNotification.Listener {
            override fun startupPerformed(s: String?) {
                if (s != null) {
                    try {
                        val list: MutableList<File> = ArrayList()
                        val m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(s)
                        while (m.find()) {
                            val file = File(m.group(1).replace("\"", ""))
                            list.add(file)
                        }
                        SwingUtilities.invokeLater { openFileHandler.openFiles(OpenFilesEvent(list, null)) }
                    } catch (e: Exception) {
                        SwingUtilities.invokeLater { Logging.instance.process(e) }
                    }
                }
            }
        }
        StartupNotification.registerStartupListener(listener)
    }

    init {
        startupNotification = StartupNotification::class.java
    }
}