package com.macrofocus.application.file

import java.io.File
import java.net.URL
import java.util.*
import javax.swing.filechooser.FileFilter


abstract class AbstractFileFilter : FileFilter, java.io.FileFilter {
    private var allowDirectories = true

    constructor() {}
    constructor(allowDirectories: Boolean) {
        this.allowDirectories = allowDirectories
    }

    /**
     * {@inheritDoc}
     */
    override fun accept(f: File): Boolean {
        return if (f != null) {
            var accept = f.isDirectory && allowDirectories
            if (!accept) {
                val suffix: String? = FileHelper.getSuffix(f)
                for (ext in extensions) {
                    if (suffix != null && ext != null) {
                        accept = suffix.compareTo(ext, ignoreCase = true) == 0
                        if (accept) {
                            return true
                        }
                    }
                }
            }
            accept
        } else {
            false
        }
    }

    fun accept(f: URL?): Boolean {
        return if (f != null) {
            val suffix: String? = FileHelper.getSuffix(f.path)
            var accept = false
            for (ext in extensions) {
                if (suffix != null && ext != null) {
                    accept = suffix.compareTo(ext, ignoreCase = true) == 0
                    if (accept) {
                        return true
                    }
                }
            }
            accept
        } else {
            false
        }
    }

    fun accept(f: String?): Boolean {
        return if (f != null) {
            val suffix: String? = FileHelper.getSuffix(f)
            var accept = false
            for (ext in extensions) {
                if (suffix != null && ext != null) {
                    accept = suffix.compareTo(ext, ignoreCase = true) == 0
                    if (accept) {
                        return true
                    }
                }
            }
            accept
        } else {
            false
        }
    }

    fun acceptContentType(contentType: String?): Boolean {
        return false
    }

    /**
     * The default extension of this filter.
     *
     * @return the extension of this filter;
     */
    abstract val defaultExtension: String

    /**
     * The extensions supported by this filter.
     *
     * @return the extensions supported;
     */
    open val extensions: Array<String>
        get() = arrayOf(defaultExtension)
    abstract val name: String

    /**
     * {@inheritDoc}
     */
    override fun getDescription(): String {
        return buildDescription(name)
    }

    fun buildDescription(name: String?): String {
        val buffer = StringBuffer(name)
        buffer.append(" (")
        var first = true
        for (s in extensions) {
            if (!first) {
                buffer.append(";")
            }
            buffer.append("*.")
            buffer.append(s)
            first = false
        }
        buffer.append(")")
        return buffer.toString()
    }

    override fun equals(o: Any?): Boolean {
        if (this === o) return true
        if (o !is AbstractFileFilter) return false
        return name == o.name
    }

    override fun hashCode(): Int {
        return Objects.hash(name)
    }
}
