package com.macrofocus.application.file

import com.macrofocus.common.file.CPFile
import com.macrofocus.common.file.FileType
import org.mkui.window.CPWindow
import javax.swing.JFileChooser
import javax.swing.filechooser.FileFilter

actual class CPFileChooser {
    private var fileChooser: JFileChooser? = null

    private val map: MutableMap<FileFilter, FileType> = HashMap()
    private val reverseMap: MutableMap<FileType, FileFilter> = HashMap()

    fun SwingFileChooser() {
        fileChooser = MFileChooser()
        fileChooser!!.fileSelectionMode = JFileChooser.FILES_ONLY
        fileChooser!!.isAcceptAllFileFilterUsed = false
        fileChooser!!.controlButtonsAreShown = true
    }

    actual fun setTitle(title: String?) {
        fileChooser!!.dialogTitle = title
    }

    actual fun setFileTypes(vararg fileTypes: FileType) {
        fileChooser!!.resetChoosableFileFilters()
        map.clear()
        reverseMap.clear()
        var first: FileFilter? = null
        for (fileType in fileTypes) {
            val extensionFilters = arrayOfNulls<String>(fileType.extensions.size)
            for (i in extensionFilters.indices) {
                extensionFilters[i] = "*." + fileType.extensions[i]
            }
            // ToDo: reimplement
            val filter: FileFilter = object : AbstractFileFilter() {
                override val name: String = "Undefined"

                override val extensions: Array<String>
                    get() = fileType.extensions as Array<String>
                override val defaultExtension: String
                    get() = fileType.extensions[0]
            }
            if (first == null) {
                first = filter
            }
            fileChooser!!.addChoosableFileFilter(filter)
            map[filter] = fileType
            reverseMap[fileType] = filter
        }
        if (first != null) {
            fileChooser!!.fileFilter = first
        }
    }

    actual fun showOpenDialog(window: CPWindow?): CPFile? {
        val accept = fileChooser!!.showOpenDialog(window!!.nativeWindow)
        return if (accept == JFileChooser.APPROVE_OPTION) {
            CPFile(fileChooser!!.selectedFile)
        } else {
            null
        }
    }

    actual fun showSaveDialog(window: CPWindow?): CPFile? {
        val accept = fileChooser!!.showSaveDialog(window!!.nativeWindow)
        return if (accept == JFileChooser.APPROVE_OPTION) {
            CPFile(fileChooser!!.selectedFile)
        } else {
            null
        }
    }

    actual var selectedFileType: FileType?
        get() = map[fileChooser!!.fileFilter]
        set(value) {fileChooser!!.fileFilter = reverseMap[value]}

    actual fun setCurrentDirectory(currentDirectory: CPFile?) {
        fileChooser!!.currentDirectory = currentDirectory!!.nativeFile
    }

    actual fun setSelectedFile(selectedFile: CPFile?) {
        fileChooser!!.selectedFile = selectedFile!!.nativeFile
    }
}