/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.root;

import com.macrofocus.application.root.VerticalFlowLayout;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.component.CPComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/macrofocus/application/root/CPDragDropHere;", "Lorg/mkui/component/CPComponent;", "target", "Ljavax/swing/JComponent;", "(Ljavax/swing/JComponent;)V", "content", "Ljavax/swing/JPanel;", "listeners", "", "Lcom/macrofocus/application/root/CPDragDropHere$Listener;", "nativeComponent", "getNativeComponent", "()Ljavax/swing/JComponent;", "panel", "getPanel", "addComponent", "", "component", "addListener", "listener", "configure", "DragHereIcon", "Listener", "macrofocus-application"})
public final class CPDragDropHere
implements CPComponent {
    @NotNull
    private final JComponent panel;
    @NotNull
    private final JPanel content;
    @NotNull
    private List<Listener> listeners;

    public CPDragDropHere(@NotNull JComponent target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.listeners = new ArrayList();
        JLabel icon = new JLabel(new DragHereIcon());
        JLabel label = new JLabel();
        label.setText("<html>Drag <b>file</b> here");
        label.setVerticalTextPosition(3);
        label.setHorizontalTextPosition(0);
        label.setForeground(Color.GRAY);
        label.setFont(new Font("Monospace", 0, 24));
        this.content = new JPanel();
        this.content.setLayout(new VerticalFlowLayout(0, 0, 0, 0, 15, null));
        this.content.add(label);
        this.content.add(icon);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)this.content, "Center");
        this.panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.configure(target);
    }

    @NotNull
    public final JComponent getPanel() {
        return this.panel;
    }

    public final void addListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @NotNull
    public JComponent getNativeComponent() {
        return this.panel;
    }

    public final void configure(@NotNull JComponent target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        target.setTransferHandler(new TransferHandler(this){
            final /* synthetic */ CPDragDropHere this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean canImport(@NotNull TransferHandler.TransferSupport supp) {
                Intrinsics.checkNotNullParameter((Object)supp, (String)"supp");
                return !supp.isDrop() ? false : supp.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            public boolean importData(@NotNull TransferHandler.TransferSupport support) {
                Intrinsics.checkNotNullParameter((Object)support, (String)"support");
                if (!this.canImport(support)) {
                    return false;
                }
                Transferable t = support.getTransferable();
                try {
                    Object data = t.getTransferData(DataFlavor.javaFileListFlavor);
                    Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.collections.List<java.io.File>");
                    List fileList = (List)data;
                    for (Listener listener2 : CPDragDropHere.access$getListeners$p(this.this$0)) {
                        listener2.filesDropped(fileList);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        });
    }

    public final void addComponent(@Nullable JComponent component) {
        this.content.add(component);
    }

    public static final /* synthetic */ List access$getListeners$p(CPDragDropHere $this) {
        return $this.listeners;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000e*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/macrofocus/application/root/CPDragDropHere$DragHereIcon;", "Ljavax/swing/Icon;", "(Lcom/macrofocus/application/root/CPDragDropHere;)V", "a", "", "b", "f", "", "font", "Ljava/awt/Font;", "frc", "Ljava/awt/font/FontRenderContext;", "linec", "Ljava/awt/Color;", "kotlin.jvm.PlatformType", "r", "s", "Ljava/awt/Shape;", "size", "getIconHeight", "getIconWidth", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "macrofocus-application"})
    public final class DragHereIcon
    implements Icon {
        private final int size;
        private final float a;
        private final float b;
        private final int r;
        private final int f;
        @NotNull
        private final Font font;
        @NotNull
        private final FontRenderContext frc;
        private final Shape s;
        private final Color linec;

        public DragHereIcon() {
            this.size = 80;
            this.a = 4.0f;
            this.b = 8.0f;
            this.r = 16;
            this.f = this.size / 4;
            this.font = new Font("Monospace", 0, this.size);
            this.frc = new FontRenderContext(null, true, true);
            this.s = new TextLayout("\u21e9", this.font, this.frc).getOutline(null);
            this.linec = Color.GRAY;
        }

        @Override
        public void paintIcon(@NotNull Component c, @NotNull Graphics g, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Graphics graphics = g.create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2 = (Graphics2D)graphics;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.translate(x, y);
            g2.setStroke(new BasicStroke(this.a));
            g2.setPaint(this.linec);
            g2.draw(new RoundRectangle2D.Float(this.a, this.a, (float)this.size - (float)2 * this.a - 1.0f, (float)this.size - (float)2 * this.a - 1.0f, this.r, this.r));
            g2.setStroke(new BasicStroke(this.b));
            g2.setColor(UIManager.getColor("Panel.background"));
            g2.drawLine(1 * this.f, 0 * this.f, 1 * this.f, 4 * this.f);
            g2.drawLine(2 * this.f, 0 * this.f, 2 * this.f, 4 * this.f);
            g2.drawLine(3 * this.f, 0 * this.f, 3 * this.f, 4 * this.f);
            g2.drawLine(0 * this.f, 1 * this.f, 4 * this.f, 1 * this.f);
            g2.drawLine(0 * this.f, 2 * this.f, 4 * this.f, 2 * this.f);
            g2.drawLine(0 * this.f, 3 * this.f, 4 * this.f, 3 * this.f);
            g2.setPaint(this.linec);
            Rectangle rectangle = this.s.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
            Rectangle2D b = rectangle;
            Point2D.Double p = new Point2D.Double(b.getX() + b.getWidth() / 2.0, b.getY() + b.getHeight() / 2.0);
            AffineTransform toCenterAT = AffineTransform.getTranslateInstance((double)this.size / 2.0 - p.getX(), (double)this.size / 2.0 - p.getY());
            g2.fill(toCenterAT.createTransformedShape(this.s));
            g2.translate(-x, -y);
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0010\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/macrofocus/application/root/CPDragDropHere$Listener;", "", "filesDropped", "", "files", "", "Ljava/io/File;", "macrofocus-application"})
    public static interface Listener {
        public void filesDropped(@Nullable Iterable<? extends File> var1);
    }
}

