/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.window;

import com.macrofocus.application.document.View;
import com.macrofocus.application.document.swing.SwingSDIDocumentBasedApplication;
import com.macrofocus.application.window.AbstractWindowManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.FocusManager;
import kotlin.ExperimentalStdlibApi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.component.CPComponent;
import org.mkui.window.CPWindow;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0010H\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\bH\u0005J\b\u0010\u001f\u001a\u00020\bH\u0016J\u000e\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\bR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/macrofocus/application/window/SwingMFIWindowManager;", "V", "Lcom/macrofocus/application/document/View;", "Lcom/macrofocus/application/window/AbstractWindowManager;", "application", "Lcom/macrofocus/application/document/swing/SwingSDIDocumentBasedApplication;", "(Lcom/macrofocus/application/document/swing/SwingSDIDocumentBasedApplication;)V", "activeWindow", "Lorg/mkui/window/CPWindow;", "getActiveWindow", "()Lorg/mkui/window/CPWindow;", "newWindow", "getNewWindow", "setNewWindow", "(Lorg/mkui/window/CPWindow;)V", "singleNewWindow", "", "windowCount", "", "getWindowCount", "()I", "windows", "", "assign", "", "component", "Lorg/mkui/component/CPComponent;", "window", "newView", "closeWindow", "configureWindow", "createWindow", "isFrameMinimized", "frame", "macrofocus-application"})
@ExperimentalStdlibApi
public final class SwingMFIWindowManager<V extends View<?>>
extends AbstractWindowManager<V> {
    @NotNull
    private final SwingSDIDocumentBasedApplication<?, ?> application;
    private final boolean singleNewWindow;
    @NotNull
    private final List<CPWindow> windows;
    @Nullable
    private CPWindow newWindow;

    public SwingMFIWindowManager(@NotNull SwingSDIDocumentBasedApplication<?, ?> application) {
        Intrinsics.checkNotNullParameter(application, (String)"application");
        this.application = application;
        this.singleNewWindow = true;
        this.windows = new ArrayList();
        this.setNewWindow(null);
    }

    @Override
    @Nullable
    public CPWindow getNewWindow() {
        return this.newWindow;
    }

    @Override
    public void setNewWindow(@Nullable CPWindow cPWindow) {
        this.newWindow = cPWindow;
    }

    @Override
    public int getWindowCount() {
        return this.windows.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CPWindow createWindow() {
        CPWindow cPWindow;
        if (this.singleNewWindow && this.getNewWindow() != null) {
            CPWindow cPWindow2 = this.getNewWindow();
            Intrinsics.checkNotNull((Object)cPWindow2);
            CPWindow window = cPWindow2;
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(1) && this.isFrameMinimized(window)) {
                window.getNativeWindow().setState(0);
            }
            window.getNativeWindow().toFront();
            window.getNativeWindow().requestFocus();
            cPWindow = window;
        } else {
            void var1_2;
            CPWindow window = null;
            window = new CPWindow();
            this.configureWindow(window);
            window.getNativeWindow().setSize(1000, 720);
            window.getNativeWindow().setLocationRelativeTo(null);
            window.getNativeWindow().setVisible(true);
            window.getNativeWindow().toFront();
            window.getNativeWindow().requestFocus();
            this.windows.add(window);
            this.setNewWindow(window);
            cPWindow = var1_2;
        }
        return cPWindow;
    }

    public final boolean isFrameMinimized(@NotNull CPWindow frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return (frame.getNativeWindow().getExtendedState() & 1) != 0;
    }

    @ExperimentalStdlibApi
    protected final void configureWindow(@NotNull CPWindow window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        window.getNativeWindow().setDefaultCloseOperation(0);
        window.getNativeWindow().addWindowListener(new WindowAdapter(this, window){
            final /* synthetic */ SwingMFIWindowManager<V> this$0;
            final /* synthetic */ CPWindow $window;
            {
                this.this$0 = $receiver;
                this.$window = $window;
            }

            public void windowClosing(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SwingMFIWindowManager.access$getApplication$p(this.this$0).closeWindow(this.$window);
            }
        });
        this.application.configureWindow(window.getNativeWindow());
    }

    @Override
    public void closeWindow(@NotNull CPWindow window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        window.getNativeWindow().getContentPane().removeAll();
        if (this.getNewWindow() == window) {
            this.setNewWindow(null);
        }
        this.windows.remove(window);
        window.getNativeWindow().dispose();
    }

    @Override
    public void assign(@Nullable CPComponent component, @NotNull CPWindow window, boolean newView) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (newView) {
            this.setNewWindow(window);
        } else if (this.getNewWindow() == window) {
            this.setNewWindow(null);
        }
    }

    @Override
    @Nullable
    public CPWindow getActiveWindow() {
        Window activeWindow = FocusManager.getCurrentManager().getActiveWindow();
        if (activeWindow != null) {
            for (CPWindow window : this.windows) {
                if (activeWindow != window.getNativeWindow()) continue;
                return window;
            }
        }
        return null;
    }

    public static final /* synthetic */ SwingSDIDocumentBasedApplication access$getApplication$p(SwingMFIWindowManager $this) {
        return $this.application;
    }
}

