/*
 * Copyright (c) 2019 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.document.swing


import java.awt.Desktop
import java.awt.desktop.AboutHandler
import java.awt.desktop.OpenFilesHandler
import java.awt.desktop.OpenURIHandler
import java.awt.desktop.QuitHandler
import java.util.*

interface CPDesktop {
    fun isSupported(action: Desktop.Action): Boolean
    fun setOpenFileHandler(openFileHandler: OpenFilesHandler)
    fun setOpenURIHandler(openURIHandler: OpenURIHandler)
    fun setQuitHandler(quitHandler: QuitHandler)
    fun setAboutHandler(aboutHandler: AboutHandler)

    companion object {
        val instance: CPDesktop?
            get() {
                var desktop: CPDesktop? = null
                if (System.getProperty("os.name").lowercase(Locale.US).startsWith("mac")) {
                    try {
                        desktop = MacDesktop()
                    } catch (e: Throwable) {
                    }
                }
                if (desktop == null) {
                    try {
                        desktop = Install4JDesktop()
                    } catch (e: Throwable) {
                    }
                }
                if (desktop == null) {
                    desktop = if (Desktop.isDesktopSupported()) {
                        DesktopDesktop()
                    } else {
                        DummyDesktop()
                    }
                }
                return desktop
            }
    }
}