/*
 * Copyright (c) 2019 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.document.swing

import com.apple.eawt.Application
import java.awt.Desktop
import java.awt.desktop.*

class MacDesktop : CPDesktop {
    private val application: Application?
    override fun isSupported(action: Desktop.Action): Boolean {
        return application != null
    }

    override fun setOpenFileHandler(openFileHandler: OpenFilesHandler) {
        // ToDo: Type mismatch: inferred type is (MutableList<Any?>..List<*>?) but (Mutable)List<File
//        application!!.setOpenFileHandler { e -> openFileHandler.openFiles(OpenFilesEvent(e.files, e.searchTerm)) }
    }

    override fun setOpenURIHandler(openURIHandler: OpenURIHandler) {
        application!!.setOpenURIHandler { e -> openURIHandler.openURI(OpenURIEvent(e.uri)) }
    }

    override fun setQuitHandler(quitHandler: QuitHandler) {
        application!!.setQuitHandler { e, response ->
            quitHandler.handleQuitRequestWith(QuitEvent(), object : QuitResponse {
                override fun performQuit() {}
                override fun cancelQuit() {}
            })
            response.cancelQuit()
        }
    }

    override fun setAboutHandler(aboutHandler: AboutHandler) {
        application!!.setAboutHandler { aboutHandler.handleAbout(AboutEvent()) }
    }

    init {
        application = Application.getApplication()
    }
}