package com.macrofocus.application.file

import org.mkui.window.CPWindow
import java.io.File
import javax.swing.JFileChooser

class SwingDirectoryChooser : CPDirectoryChooser<File?> {
    private val fileChooser: JFileChooser
    override fun setTitle(title: String?) {
        fileChooser.dialogTitle = title
    }

    override fun showDialog(window: CPWindow): File? {
        val accept = fileChooser.showOpenDialog(window.nativeWindow)
        return if (accept == JFileChooser.APPROVE_OPTION) {
            fileChooser.selectedFile
        } else {
            null
        }
    }

    init {
        fileChooser = JFileChooser()
        fileChooser.fileSelectionMode = JFileChooser.DIRECTORIES_ONLY
    }
}